/* Yahoo! Weather for RiveScript
   Retrieve weather conditions and forecast from Yahoo! Weather.
   Usage: weather <zipcode>
      or: how is the weather?

   Author: Casey Kirsle, www.kirsle.net

   Perl Dependencies:
      LWP::Simple (to retrieve Yahoo Weather)
      XML::Simple (to parse the XML data)

   RiveScript Dependencies:
      ! sub don't = do not
*/
! version = 2.0

+ weather #{weight=100}
- <call>weather <star></call>

+ what is the weather
* <get zipcode> != undefined => {@weather <get zipcode>}
- I can tell you how the weather is, but I don't know your zip code. What is it?

+ #
% * i do not know your zip code what is it
* <call>validzip <star></call> == 1 => <set zipcode=<star>>Okay, I will remember that your zip code is <star>.\n\n{@weather <star>}
- That isn't a valid zip code. You should've answered as a number, like "90230".

+ how is the weather
@ what is the weather

+ what is the weather like
@ what is the weather

+ do you know [how] the weather [is]
@ what is the weather

+ how (warm|hot|cold) is it [outside]
@ what is the weather

+ weather{weight=100}
@ what is the weather

+ what is the weather [like] in #
@ weather <star>

+ how is the weather in #
@ weather <star>

+ do you know [how] the weather is in #
@ weather <star>

+ how (warm|hot|cold) is it in #
@ weather <star>

+ my zip code is #{weight=100}
* <call>validzip <star></call> == 1 => <set zipcode=<star>>I will remember that your zip code is <star>.
- That zip code doesn't seem to be valid. It should be 5 numbers.

+ my zip is #{weight=100}
@ my zip code is <star>

+ my zipcode is #{weight=100}
@ my zip code is <star>

> object validzip perl
   my ($rs,$zip) = (shift,shift);

   if (length $zip == 5) {
      return 1;
   }
   else {
      return 0;
   }
< object

> object weather perl
   my ($rs,$zip) = (shift,shift);

   if (length $zip != 5) {
      return "That isn't a valid zip code!";
   }

   use LWP::Simple;
   use XML::Simple;

   my $o_xs = new XML::Simple;

   my $rss = get "http://weather.yahooapis.com/forecastrss?p=$zip";
   my $xml = XMLin($rss);

   if (exists $xml->{channel}) {
      my $channel = $xml->{channel}->{item};
      my $temp = $channel->{'yweather:condition'}->{temp};
      my $condition = $channel->{'yweather:condition'}->{text};

      my $city = $xml->{channel}->{'yweather:location'}->{city};
      my $state = $xml->{channel}->{'yweather:location'}->{region};
      my $wind = $xml->{channel}->{'yweather:wind'}->{speed};
      my $tomorrow = $channel->{'yweather:forecast'}->[0];
      my $nextday  = $channel->{'yweather:forecast'}->[1];

      my $tip = "";
      if (int(rand(3)) == 0) {
         $tip = "\n\nTip: I can tell you the weather for somewhere else "
            . "if you say e.g. \"how is the weather in 48433\". If I know "
            . "your zip code and you want me to remember something else, "
            . "say e.g. \"my zip code is 90230\".";
      }

      return "Current Weather conditions for <b>$city, $state $zip</b>:\n\n"
         . "<b>Current Conditions:</b>\n"
         . "$condition, $temp F\n\n"
         . "<b>Forecast:</b>\n"
         . "$tomorrow->{day} - $tomorrow->{text}. High: $tomorrow->{high}; Low: $tomorrow->{low}\n"
         . "$nextday->{day} - $nextday->{text}. High: $nextday->{high}; Low: $nextday->{low}$tip";
   }
   else {
      return "There was an error retrieving the weather.";
   }
< object