###############################################################################
# YaBBC.pl                                                                    #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$yabbcplver = 'YaBB 2.2.1 $Revision: 1.38.2.10 $';
if ($action eq 'detailedversion') { return 1; }

&LoadLanguage('Post');

$yyYaBBCloaded = 1;

sub decode_direction {
	$_ = $_[0];
	$_ =~ s~left~270~ig;
	$_ =~ s~right~90~ig;
	$_ =~ s~top~0~ig;
	$_ =~ s~bottom~180~ig;
	$_ =~ s~topright~45~ig;
	$_ =~ s~bottomright~135~ig;
	$_ =~ s~bottomleft~225~ig;
	$_ =~ s~topleft~315~ig;
	return $_;
}

sub validwidth { return ($_[0] > 400 ? 400 : $_[0]); }

sub MakeSmileys {
	$message =~ s/\[smilie=(\S+?\.(gif|jpg|png|bmp))\]/\<img src="$smiliesurl\/$1" border="0" alt="$post_txt{'287'}" \/\>/isg;
	$message =~ s/\[smiley=(\S+?\.(gif|jpg|png|bmp))\]/\<img src="$smiliesurl\/$1" border="0" alt="$post_txt{'287'}" \/\>/isg;
	$message =~ s/(\W|\A)\;\)/$1\<img src="$imagesdir\/wink.gif" border="0" alt="$post_txt{'292'}" \/>/g;
	$message =~ s/(\W|\A)\;\-\)/$1\<img src="$imagesdir\/wink.gif" border="0" alt="$post_txt{'292'}" \/>/g;
	$message =~ s/(\W|\A)\;D/$1\<img src="$imagesdir\/grin.gif" border="0" alt="$post_txt{'293'}" \/>/g;
	$message =~ s/\Q:\'(\E/\<img src="$imagesdir\/cry.gif" border="0" alt="$post_txt{'530'}" \/>/g;
	$message =~ s/(\W|\A)\:\-\//$1\<img src="$imagesdir\/undecided.gif" border="0" alt="$post_txt{'528'}" \/>/g;
	$message =~ s/\Q:-X\E/\<img src="$imagesdir\/lipsrsealed.gif" border="0" alt="$post_txt{'527'}" \/>/g;
	$message =~ s/\Q:-[\E/\<img src="$imagesdir\/embarassed.gif" border="0" alt="$post_txt{'526'}" \/>/g;
	$message =~ s/\Q:-*\E/\<img src="$imagesdir\/kiss.gif" border="0" alt="$post_txt{'529'}" \/>/g;
	$message =~ s/\Q&gt;:(\E/\<img src="$imagesdir\/angry.gif" border="0" alt="$post_txt{'288'}" \/>/g;
	$message =~ s/\Q::)\E/\<img src="$imagesdir\/rolleyes\.gif" border="0" alt="$post_txt{'450'}" \/>/g;
	$message =~ s/\Q:P\E/\<img src="$imagesdir\/tongue\.gif" border="0" alt="$post_txt{'451'}" \/>/g;
	$message =~ s/\Q:)\E/\<img src="$imagesdir\/smiley\.gif" border="0" alt="$post_txt{'287'}" \/>/g;
	$message =~ s/\Q:-)\E/\<img src="$imagesdir\/smiley\.gif" border="0" alt="$post_txt{'287'}" \/>/g;
	$message =~ s/\Q:D\E/\<img src="$imagesdir\/cheesy.gif" border="0" alt="$post_txt{'289'}" \/>/g;
	$message =~ s/\Q:-(\E/\<img src="$imagesdir\/sad.gif" border="0" alt="$post_txt{'291'}" \/>/g;
	$message =~ s/\Q:(\E/\<img src="$imagesdir\/sad.gif" border="0" alt="$post_txt{'291'}" \/>/g;
	$message =~ s/\Q:o\E/\<img src="$imagesdir\/shocked.gif" border="0" alt="$post_txt{'294'}" \/>/gi;
	$message =~ s/\Q8-)\E/\<img src="$imagesdir\/cool.gif" border="0" alt="$post_txt{'295'}" \/>/g;
	$message =~ s/\Q:-?\E/\<img src="$imagesdir\/huh.gif" border="0" alt="$post_txt{'296'}" \/>/g;
	$message =~ s/\Q^_^\E/\<img src="$imagesdir\/happy.gif" border="0" alt="$post_txt{'801'}" \/>/g;
	$message =~ s/\Q:thumb:\E/\<img src="$imagesdir\/thumbsup.gif" border="0" alt="$post_txt{'282'}" \/>/g;
	$message =~ s/\Q&gt;:-D\E/\<img src="$imagesdir\/evil.gif" border="0" alt="$post_txt{'802'}" \/>/g;
	$count = 0;
	
	while ($SmilieURL[$count]) {
		if ($SmilieURL[$count] =~ /\//i) { $tmpurl = $SmilieURL[$count]; }
		else { $tmpurl = qq~$imagesdir/$SmilieURL[$count]~; }
		$tmpcode = $SmilieCode[$count];
		$tmpcode =~ s/&#36;/\$/g;
		$tmpcode =~ s/&#64;/\@/g;
		$message =~ s~\Q$tmpcode\E~<img src="$tmpurl" border="0" alt="$SmilieDescription[$count]" />$SmilieLinebreak[$count]~g;
		$count++;
	}
}

$MAXIMGWIDTH  = 400;
$MAXIMGHEIGHT = 500;

sub restrictimage {
	my ($w, $h, $s) = @_;
	$w = $w <= $MAXIMGWIDTH  ? $w : $MAXIMGWIDTH;
	$h = $h <= $MAXIMGHEIGHT ? $h : $MAXIMGHEIGHT;
	return qq~<img src="$s" width="$w" height="$h" alt="" border="0" />~;
}

sub quotemsg {
	my ($noquot, $qauthor, $qlink, $qdate, $qmessage) = @_;
	my ($testauthor,$fqauthor);
	if ($qauthor) {
		if (!-e "$memberdir/$qauthor.vars"){					## if the file is there it is an unencrypted user ID
			$qauthor = &decloak($qauthor); 					## if not, decrypt it and see if it is a regged user
			if (!-e "$memberdir/$qauthor.vars"){ 				## if still not found probably the author is a screen name
				$testauthor = &MemberIndex("who_is", "$qauthor");	## check if this name exists in the memberlist
				if ($testauthor ne ""){ 				## if it is, load the user id returned
					$qauthor = $testauthor;
					&LoadUser($qauthor);
					$fqauthor = ${$uid.$qauthor}{'realname'};	## set final author var to the current users screen name
				} else {
					$fqauthor = &decloak($qauthor); 		## if all fails it is a non existing real name so decode and asign as screenname
				}
			} else {
				&LoadUser($qauthor); 					## after encoding the user ID was found and loaded, setting the current real name
				$fqauthor = ${$uid.$qauthor}{'realname'};
			}
		} else {
			&LoadUser($qauthor); 						## it was an old style user id which could be loaded and screen name set to final author
			$fqauthor = ${$uid.$qauthor}{'realname'};
		}
		$qmessage =~ s~\/me\s+(.*?)(\n|\Z)(.*?)~<span style="color: #FF0000;">* $fqauthor $1</span>$2$3~ig;
	}
	$qmessage = &parseimgflash($qmessage);
	$qdate    = &timeformat($qdate);
	$_ = $post_txt{'599'};
	if ($action ne 'imshow' && $action ne 'imsend' && $action ne 'imsend2') { $_ = $post_txt{'600'}; }
	if ($fqauthor eq '' || $qlink eq '' || $qdate eq '') { $_ = $post_txt{'601'}; }
	if ($qlink eq 'impost') { $_ = $post_txt{'600a'}; $fqauthor2 = qq~$scripturl?action=viewprofile;username=$useraccount{$qauthor}~; }
	$_ =~ s~AUTHOR2~$fqauthor2~g;
	$_ =~ s~AUTHOR~$fqauthor~g;
	$_ =~ s~QUOTELINK~$scripturl?num=$qlink~g;
	$_ =~ s~DATE~$qdate~g;
	$_ =~ s~QUOTE~$qmessage~g;
	$cnvmessage = qq~$noquot$_~;
	return $cnvmessage;
}

#sub nstquotemsg {
	#$nstmessage = $_[0];
	#$nstmessage =~ s~(.*)\[quote+(\s+author=(.*?)\s*link=(.*?)\s+date=(.*?)\s*)?\]\n*(.*?)\n*\[/quote\]~&quotemsg($1,$3,$4,$5,$6)~eisg;
	#return $nstmessage;
#}

sub parseimgflash {
	my $tmp_message = $_[0];
	my $char_160    = '';

	$tmp_message =~ s~\[flash\=(\S+?),(\S+?)](\S+?)\[\/flash\]~<b>$display_txt{'769'} ($1 x $2):</b> <a href="$3" target="_blank" onclick="window.open('$3', 'flash', 'resizable,width=$1,height=$2'); return false;">>$3</a>~g;
	$char_160  = chr(160);
	$hardspace = qq~&nbsp;~;
	$tmp_message =~ s~\[img\](?:\s|\t|\n|$hardspace|$char_160)*(http\:\/\/)*(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~$1$2~isg;
	$tmp_message =~ s~\[img width=(\d+) height=(\d+)\](?:\s|\t|\n|$hardspace|$char_160)*(http\:\/\/)*(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[\/img\]~$3$4~ig;
	return $tmp_message;

}

sub sizefont {
	## limit minimum and maximum font pitch as CSS does not restrict it at all. ##
	my ($tsize, $ttext) = @_;
	if    (!$fontsizemax)         { $fontsizemax = 72; }
	if    (!$fontsizemin)         { $fontsizemin = 6; }
	if    ($tsize < $fontsizemin) { $tsize       = $fontsizemin; }
	elsif ($tsize > $fontsizemax) { $tsize       = $fontsizemax; }
	my $resized = qq~<span style="font-size:$tsize\px;">$ttext</span>~;
	return $resized;
}

{
	my %killhash = (
		';'  => '&#059;',
		'!'  => '&#33;',
		'('  => '&#40;',
		')'  => '&#41;',
		'-'  => '&#45;',
		'.'  => '&#46;',
		'/'  => '&#47;',
		':'  => '&#58;',
		'?'  => '&#63;',
		'['  => '&#91;',
		'\\' => '&#92;',
		']'  => '&#93;',
		'^'  => '&#94;',
		'D'  => '&#068;'
		);

	sub codemsg {
		my $code = $_[0];
		&ToChars($code);
		if ($code !~ /&\S*;/) { $code =~ s/;/&#059;/g; }
		$code =~ s~([\(\)\-\:\\\/\?\!\]\[\.\^\.D])~$killhash{$1}~g;
		$code =~ s~\&\#91\;highlight\&\#93\;(.*?)\&\#91\;\&\#47\;highlight\&\#93\;~<span class="highlight">$1</span>~isg;
		$_ = $post_txt{'602'};

		# Thx. to Michael Prager for the improved Code boxes
		# count lines in code
		$linecount = () = $code =~ /\n/g;

		# if more that 20 lines then limit code box height
		if ($linecount > 20) {
			$height = "height: 300px;";
		} else {
			$height = "";
		}

		# try to display text as it was originally intended
		$code =~ s~ \&nbsp; \&nbsp; \&nbsp;~\t~ig;
		$code =~ s~\&nbsp;~ ~ig;
		$code =~ s~\s*?\n\s*?~\[code_br\]~ig;            # we need to keep normal linebreaks inside <pre> tag
		$code = qq~<pre class="code" style="margin: 0px; width: 90%; $height overflow: auto;">$code\[code_br\][code_br\]</pre>~;
		$_ =~ s~CODE~$code~g;
		return $_;
	}
}

sub killimgurls {
	$_ = $_[0];
	$_ =~ s~\[url(.*?)\](.*?)\[\/url\]~~ig;
	$_ =~ s~\[link(.*?)\](.*?)\[\/link\]~~ig;
	return $_;
}

my $oops = qq~$maintxt{'40'}&nbsp;&nbsp;~;
$oops .= qq~$maintxt{'41'} <a href="$scripturl?action=login">$img{'login'}</a>~;
if ($regtype) { $oops .= qq~ $maintxt{'42'} <a href="$scripturl?action=register">$img{'register'}</a>!!<br />~; }


sub DoUBBC {
	if (($action eq "search2" || $action eq "pmsearch") && !$newswrap) {
		# Fix image/media URLs
		$message =~ s~\[(img|media|flash)([^\]]*?)\](.+?)\[\/\1\]~[$1 two=$2:;: three=$3:;:]~sig;
		# Use a complicated loop to only highlight matches outside of YaBBC.
		# To do this, we split the string into an array, then operate on that array.
		# We then join it together. The following does this all at once.
 		$message = join('', map {
			if(/^\[/) {$_} # Don't mess if it's a YaBBC piece
			else {
				my $piece = $_;
				foreach my $tmp (@search) {
					if ($searchtype == 4) { $piece =~ s~(\Q$tmp\E)~\[shighlight\]$1\[/shighlight\]~ig; }
					else { $piece =~ s~(^|\W|_)(\Q$tmp\E)(?=$|\W|_)~$1\[shighlight\]$2\[/shighlight\]$3~ig; }
				}
				$piece;
			}
		} split(/(\[[^\]]+?\])/, $message));
		$message =~ s~\[(img|media|flash) two=(.*?):;: three=(.*=?):;:\]~\[$1$2\]$3\[\/$1\]~sig;
	}

	$message =~ s~\[code\]~ \[code\]~ig;
	$message =~ s~\[/code\]~ \[/code\]~ig;
	$message =~ s~\[quote\]~ \[quote\]~ig;
	$message =~ s~\[/quote\]~ \[/quote\]~ig;
	$message =~ s~\[img\]~ \[img\]~ig;

	$message =~ s~\[img(.*?)\](.*?)\[/img\]~qq^[img$1\]^ . &killimgurls($2) . q^[/img]^~eisg;

	$message =~ s~\[glow\]~ \[glow\]~ig;
	$message =~ s~\[/glow\]~ \[/glow\]~ig;
	$message =~ s~<br>~\n~ig;
	$message =~ s~<br />~\n~ig;
	$message =~ s~\[code\]\n*(.+?)\n*\[/code\]~&codemsg($1)~eisg;

	$message =~ s~\[([^\]\[]{0,30})\n([^\]\[]{0,30})\]~\[$1$2\]~g;
	$message =~ s~\[/([^\]\[]{0,30})\n([^\]\[]{0,30})\]~\[/$1$2\]~g;
#	$message =~ s~(\w+://[^<>\s\n\"\]\[]+)\n([^<>\s\n\"\]\[]+)~$1\n$2~g;
	$message =~ s~\[b\](.*?)\[/b\]~<b>$1</b>~isg;
	$message =~ s~\[i\](.*?)\[/i\]~<i>$1</i>~isg;
	$message =~ s~\[u\](.*?)\[/u\]~<u>$1</u>~isg;
	$message =~ s~\[s\](.*?)\[/s\]~<s>$1</s>~isg;
	$message =~ s~\[glb\](.*?)\[/glb\]~<span style\=\"font-weight: bold\;\">$1</span>~isg;
	$message =~ s~\[move\](.*?)\[/move\]~<marquee>$1</marquee>~isg;

	#while ($message =~ s~(\[quote+(\s+author=(.*?)link=(.*?)\s+date=(.*?)\s*)?\]\n*(.*?)\n*\[/quote\])~&nstquotemsg($1)~eisg) { }
	while ($message =~ s~(.*)\[quote(\s+author=(.*?)\s+link=(.*?)\s+date=(.*?)\s*)?\]\n*(.*?)\n*\[/quote\]~&quotemsg($1,$3,$4,$5,$6)~eisg) { };

	$hardspace = qq~&nbsp;~;
	$char_160  = chr(160);
	$message =~ s~\[img\](?:\s|\t|\n|$hardspace|$char_160)*(https\:\/\/|ftp\:\/\/)(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~<img src="$1$2" alt="" border="0" />~isg;
	$message =~ s~\[img\](?:\s|\t|\n|$hardspace|$char_160)*(http\:\/\/)*(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~<img src="http\:\/\/$2" alt="" border="0" />~isg;
	$message =~ s~\[img width=(\d+) height=(\d+)\](?:\s|\t|\n|$hardspace|$char_160)*(http\:\/\/)*(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~restrictimage($1,$2,'http://'.$4)~eisg;

	$message =~ s~\[color=([A-Za-z0-9# ]+)\](.+?)\[/color\]~<span style="color: $1;">$2</span>~isg;
	$message =~ s~\[black\](.*?)\[/black\]~<span style="color:#000000;">$1</span>~isg;
	$message =~ s~\[white\](.*?)\[/white\]~<span style="color:#FFFFFF;">$1</span>~isg;
	$message =~ s~\[red\](.*?)\[/red\]~<span style="color:#FF0000;">$1</span>~isg;
	$message =~ s~\[green\](.*?)\[/green\]~<span style="color:#00FF00;">$1</span>~isg;
	$message =~ s~\[blue\](.*?)\[/blue\]~<span style="color:#0000FF;">$1</span>~isg;
	$message =~ s~\[timestamp\=([\d]{9,10})\]~&timeformat($1)~eisg;
	$message =~ s~\[moved\]~$maintxt{'160'}~;
	$message =~ s~\[move by\]~$maintxt{'525'}~;
	$message =~ s~\[split\]~$maintxt{'160c'}~;
	$message =~ s~\[splithere\]~$maintxt{'160b'}~;
	$message =~ s~\[spliced\]~$maintxt{'160a'}~;
	$message =~ s~\[splicedhere\]~$maintxt{'160b'}~;
	$message =~ s~\[splithere_end\]~$maintxt{'160d'}~;
	$message =~ s~\[font=([A-Za-z0-9# -]+)\](.+?)\[/font\]~<span style="font-family: $1;">$2</span>~isg;
	while ($message =~ s~\[size=([A-Za-z0-9# ]+)\](.+?)\[/size\]~&sizefont($1,$2)~eisg) { }

	$message =~ s~\[tt\](.*?)\[/tt\]~<tt>$1</tt>~isg;
	$message =~ s~\[left\](.*?)\[/left\]~<div style="text-align: left;">$1</div>~isg;
	$message =~ s~\[center\](.*?)\[/center\]~<center>$1</center>~isg;
	$message =~ s~\[right\](.*?)\[/right\]~<div style="text-align: right;">$1</div>~isg;
	$message =~ s~\[justify\](.*?)\[/justify\]~<div style="text-align: justify">$1</div>~isg;
	$message =~ s~\[sub\](.*?)\[/sub\]~<sub>$1</sub>~isg;
	$message =~ s~\[sup\](.*?)\[/sup\]~<sup>$1</sup>~isg;
	$message =~ s~\[fixed\](.*?)\[/fixed\]~<span style="font-family: Courier New;">$1</span>~isg;

	$message =~ s~\[hr\]\n~<hr width="40%" align="left" size="1" class="hr" />~g;
	$message =~ s~\[hr\]~<hr width="40%" align="left" size="1" class="hr" />~g;
	$message =~ s~\[br\]~\n~ig;
	$message =~ s~\s$YaBBversion\s~ \<a style\=\"font-weight: bold;\" href\=\"http\:\/\/www\.yabbforum\.com\/downloads\.php\"\>$YaBBversion Forum Software\<\/a\> ~g;

	$message =~ s~\[highlight\](.*?)\[/highlight\]~<span class="highlight">$1</span>~isg;
	$message =~ s~\[shighlight\](.*?)\[/shighlight\]~<span class="highlight">$1</span>~isg;

	sub format_url {
		my ($txtfirst, $txturl) = @_;
		my $lasttxt = "";
		if ($txturl =~ m~(.*?)(\.|\.\)|\)\.|\!|\!\)|\)\!|\,|\)\,|\)|\;|\&quot\;|\&quot\;\.|\.\&quot\;|\&quot\;\,|\,\&quot\;|\&quot\;\;|\<\/)\Z~) {
			$txturl = $1;
			$lasttxt = $2;
		}
		my $realurl = $txturl;
                $txturl =~ s~(\[shighlight\]|\[\/shighlight\]|\[highlight\]|\[\/highlight\]|\[edit\]|\[\/edit\])~~ig;
		$txturl =~ s~\[~&#91;~g;
		$txturl =~ s~\]~&#93;~g;
		$txturl =~ s~\<.+?\>~~ig;
		my $formaturl = qq~$txtfirst\[url\=$txturl\]$realurl\[\/url\]$lasttxt~;
		return $formaturl;
	}
	sub format_url2 {
		my ($txturl, $txtlink) = @_;
                $txturl =~ s~(\[shighlight\]|\[\/shighlight\]|\[highlight\]|\[\/highlight\]|\[edit\]|\[\/edit\])~~ig;
		$txturl =~ s~\<.+?\>~~ig;
		my $formaturl = qq~\[url\=$txturl\]$txtlink\[\/url\]~;
		return $formaturl;
	}
	sub format_url3 {
		my $txturl = $_[0];
		my $txtlink = $txturl;
                $txturl =~ s~(\[shighlight\]|\[\/shighlight\]|\[highlight\]|\[\/highlight\]|\[edit\]|\[\/edit\])~~ig;
		$txturl =~ s~\[~&#91;~g;
		$txturl =~ s~\]~&#93;~g;
		$txturl =~ s~\<.+?\>~~ig;
		my $formaturl = qq~\[url\=$txturl\]$txtlink\[\/url\]~;
		return $formaturl;
	}

	$message =~ s~\[url=\s*(.+?)\s*\]\s*(.+?)\s*\[/url\]~&format_url2($1, $2)~eisg;
	$message =~ s~\[url\]\s*(\S+?)\s*\[/url\]~&format_url3($1)~eisg;

	if ($autolinkurls) {
		$message =~ s~\[url\]\s*([^\[]+)\s*\[/url\]~[url]$1\[/url]~g;
		$message =~ s~\[link\]\s*([^\[]+)\s*\[/link\]~[link]$1\[/link]~g;
		$message =~ s~\[news\](\S+?)\[/news\]~<a href="$1">$1</a>~isg;
		$message =~ s~\[gopher\](\S+?)\[/gopher\]~<a href="$1">$1</a>~isg;
		$message =~ s~&quot;&gt;~">~g; #"
		$message =~ s~(\[\*\])~ $1~g;
		$message =~ s~(\[\/list\])~ $1~g;
		$message =~ s~(\[\/td\])~ $1~g;
		$message =~ s~(\[\/td\])~ $1~g;
		$message =~ s~\<span style\=~\<span_style\=~g;
		$message =~ s~\<div style\=~\<div_style\=~g;
		$message =~ s~([^\w\"\=\[\]]|[\n\b]|\&quot\;|\[quote.*?\]|\[edit\]|\[highlight\]|\[shighlight\]|\[\*\]|\[td\]|\A)\\*(\w+?\:\/\/(?:[\w\~\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\](?:\<\S+?\>\S+?\<\/\S+?\>)]+?)\.(?:[\w\~\.\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\]\x80-\xFF]{1,})+?)~&format_url($1,$2)~eisg;
		$message =~ s~([^\"\=\[\]/\:\.(\://\w+)]|[\n\b]|\&quot\;|\[quote.*?\]|\[edit\]|\[highlight\]|\[shighlight\]|\[\*\]|\[td\]|\A|\()\\*(www\.[^\.](?:[\w\~\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\](?:\<\S+?\>\S+?\<\/\S+?\>)]+?)\.(?:[\w\~\.\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\]\x80-\xFF]{1,})+?)~&format_url($1,$2)~eisg;
		$message =~ s~\<span_style\=~\<span style\=~g;
		$message =~ s~\<div_style\=~\<div style\=~g;
	}

	if ($stealthurl) {
#		$message =~ s~\[url\]\s*www\.\s*(.+?)\s*\[/url\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://www.$1" target="_blank">www.$1</a>~isg;
		$message =~ s~\[url=\s*(\w+\://.+?)\](.+?)\s*\[/url\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1" target="_blank">$2</a>~isg;
		$message =~ s~\[url=\s*(.+?)\]\s*(.+?)\s*\[/url\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://$1" target="_blank">$2</a>~isg;
#		$message =~ s~\[url\]\s*(.+?)\s*\[/url\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1" target="_blank">$1</a>~isg;

		$message =~ s~\[link\]\s*www\.\s*(.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://www.$1">www.$1</a>~isg;
		$message =~ s~\[link=\s*(\w+\://.+?)\](.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1">$2</a>~isg;
		$message =~ s~\[link=\s*(.+?)\]\s*(.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://$1">$2</a>~isg;
		$message =~ s~\[link\]\s*(.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1">$1</a>~isg;

		$message =~ s~\[ftp\]\s*(.+?)\s*\[/ftp\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1" target="_blank">$1</a>~isg;
	} else {
#		$message =~ s~\[url\]\s*www\.(\S+?)\s*\[/url\]~<a href="http://www.$1" target="_blank">www.$1</a>~isg;
		$message =~ s~\[url=\s*(\S\w+\://\S+?)\s*\](.+?)\[/url\]~<a href="$1" target="_blank">$2</a>~isg;
		$message =~ s~\[url=\s*(\S+?)\](.+?)\s*\[/url\]~<a href="http://$1" target="_blank">$2</a>~isg;
#		$message =~ s~\[url\]\s*(http://)?(\S+?)\s*\[/url\]~<a href="http://$2" target="_blank">$1$2</a>~isg;

		$message =~ s~\[link\]\s*www\.(\S+?)\s*\[/link\]~<a href="http://www.$1">www.$1</a>~isg;
		$message =~ s~\[link=\s*(\S\w+\://\S+?)\s*\](.+?)\[/link\]~<a href="$1">$2</a>~isg;
		$message =~ s~\[link=\s*(\S+?)\](.+?)\s*\[/link\]~<a href="http://$1">$2</a>~isg;
		$message =~ s~\[link\]\s*(\S+?)\s*\[/link\]~<a href="$1">$1</a>~isg;

		$message =~ s~\[ftp\]\s*(ftp://)?(.+?)\s*\[/ftp\]~<a href="ftp://$2">$1$2</a>~isg;
	}

	$message =~ s~(dereferer\;url\=http\:\/\/.*?)#(\S+?\")~$1;anch=$2~isg;
	$message =~ s~\[email\]\s*(\S+?\@\S+?)\s*\[/email\]~<a href="mailto:$1">$1</a>~isg;
	$message =~ s~\[email=\s*(\S+?\@\S+?)\](.*?)\[/email\]~<a href="mailto:$1">$2</a>~isg;

	$message =~ s~\[edit\](.*?)\[/edit\]~<b>$post_txt{'603'}: </b><br /><div class="editbg" style="overflow: auto;">$1</div>~isg;

	$message =~ s~\/me\s+(.*)~<span style="color: #FF0000;"><i>* $displayname $1</i></span>~ig;

	if($message =~ /\[media/ || $message =~ /\[flash/) {
		require "$sourcedir/MediaCenter.pl";
		$message =~ s~\[flash\](.*?)\[/flash\]~\[media\]$1\[/media\]~isg;				## convert old flash tags to media tags
		while ($message =~ s~\[flash\s*(.*?)\]\n*(.*?)\n*\[/flash\]~&flashconvert($2,$1)~eisg){ }	## convert old flash tags to media tags
		while ($message =~ s~\[media\]\n*(.*?)\n*\[/media\]~&embed($1)~eisg){ }
		while ($message =~ s~\[media\s*(.*?)\]\n*(.*?)\n*\[/media\]~&embed($2,$1)~eisg){ }
		$message =~ s~media:~http:~ig;
	}

 	if ($guest_media_disallowed && $iamguest) {
 		$showattach = '';
		$showattachhr = '';
 		$attachment =~ s~\<a href\=\"(.+?)</a>~[yyoops]~g;
		$attachment =~ s~\<img src\=\"(.+?)/>~[yyoops]~g;
		$attachment =~ s~\[yyoops\]~$oops~g;
		$message =~ s~\<a href\=\"(.+?)</a>~[yyoops]~g;
		$message =~ s~\<img src\=\"(.+?)/>~[yyoops]~g;
		$message =~ s~\[yyoops\]~$oops~g;
	}
	
	if ($message =~ /\#nosmileys/isg || $ns =~ "NS") { $message =~ s/\#nosmileys//isg; }
	else { &MakeSmileys; }

	$message =~ s~\s*\[\*\]~</li><li>~isg;
	$message =~ s~\[olist\]~<ol>~isg;
	$message =~ s~\s*\[/olist\]~</li></ol>~isg;
	$message =~ s~</li><ol>~<ol>~isg;
	$message =~ s~<ol></li>~<ol>~isg;
	$message =~ s~\[list\]~<ul>~isg;
	$message =~ s~\s*\[/list\]~</li></ul>~isg;
	$message =~ s~</li><ul>~<ul>~isg;
	$message =~ s~<ul></li>~<ul>~isg;

	$message =~ s~\[pre\](.+?)\[/pre\]~'<pre>' . dopre($1) . '</pre>'~iseg;

	if ($message =~ m~\[table\](?:.*?)\[/table\]~is) {
		while ($message =~ s~<marquee>(.*?)\[table\](.*?)\[/table\](.*?)</marquee>~<marquee>$1<table>$2</table>$3</marquee>~s)        { }
		while ($message =~ s~<marquee>(.*?)\[table\](.*?)</marquee>(.*?)\[/table\]~<marquee>$1\[//table\]$2</marquee>$3\[//table\]~s) { }
		while ($message =~ s~\[table\](.*?)<marquee>(.*?)\[/table\](.*?)</marquee>~\[//table\]$1<marquee>$2\[//table\]$3</marquee>~s) { }
		$message =~ s~\n{0,1}\[table\]\n*(.+?)\n*\[/table\]\n{0,1}~<table>$1</table>~isg;
		while ($message =~ s~\<table\>(.*?)\n*\[tr\]\n*(.*?)\n*\[/tr\]\n*(.*?)\</table\>~<table>$1<tr>$2</tr>$3</table>~is) { }
		while ($message =~ s~\<tr\>(.*?)\n*\[td\]\n{0,1}(.*?)\n{0,1}\[/td\]\n*(.*?)\</tr\>~<tr>$1<td>$2</td>$3</tr>~is)     { }
		$message =~ s~<table>((?:(?!<tr>|</tr>|<td>|</td>|<table>|</table>).)*)<tr>~<table><tr>~isg;
		$message =~ s~<tr>((?:(?!<tr>|</tr>|<td>|</td>|<table>|</table>).)*)<td>~<tr><td>~isg;
		$message =~ s~</td>((?:(?!<tr>|</tr>|<td>|</td>|<table>|</table>).)*)<td>~</td><td>~isg;
		$message =~ s~</td>((?:(?!<tr>|</tr>|<td>|</td>|<table>|</table>).)*)</tr>~</td></tr>~isg;
		$message =~ s~</td>((?!<tr>|</tr>|<td>|</td>|<table>|</table>).*?)<td>~</td><td>~isg;
		$message =~ s~</td>((?!<tr>|</tr>|<td>|</td>|<table>|</table>).*?)</tr>~</td></tr>~isg;
		$message =~ s~</tr>((?:(?!<tr>|</tr>|<td>|</td>|<table>|</table>).)*)<tr>~</tr><tr>~isg;
		$message =~ s~</tr>((?:(?!<tr>|</tr>|<td>|</td>|<table>|</table>).)*)</table>~</tr></table>~isg;
	}

	while ($message =~ s~<a([^>]*?)\n([^>]*)>~<a$1$2>~)                  { }
	while ($message =~ s~<a([^>]*)>([^<]*?)\n([^<]*)</a>~<a$1>$2$3</a>~) { }
	while ($message =~ s~<a([^>]*?)&amp;([^>]*)>~<a$1&$2>~)              { }
	while ($message =~ s~<img([^>]*?)\n([^>]*)>~<img$1$2>~)              { }
	while ($message =~ s~<img([^>]*?)&amp;([^>]*)>~<img$1&$2>~)          { }

	$message =~ s~\[\&table(.*?)\]~<table$1>~g;
	$message =~ s~\[/\&table\]~</table>~g;
	$message =~ s~\n~<br />~ig;
	$message =~ s~\[code_br\]~\n~ig;
}

sub DoUBBCTo {
	# Does UBBC to $_[0] using &DoUBBC and keeps $message the same
	my($messagecopy, $returnthis);
	$messagecopy = $message;
	$message = $_[0];
	&DoUBBC;
	$returnthis = $message;
	$message = $messagecopy;
	return $returnthis;
}

1;