###############################################################################
# TabMenu.pl                                                                  #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$tabmenuplver = 'YaBB 2.2.1 $Revision: 1.18.2.9 $';
if ($action eq 'detailedversion') { return 1; }

require "$sourcedir/AdvancedTabs.pl";

sub mainMenu {
	if ($action eq "addtab" && $iamadmin) { &AddNewTab; }
	elsif ($action eq "edittab" && $iamadmin) { &EditTab; }
	elsif ($action ne "") {
		if ($action eq "search2") { $tmpaction = "search"; }
		elsif ($action eq "favorites" || $action eq "shownotify" || $action eq "im" || $action eq "imdraft" || $action eq "imoutbox" || $action eq "imstorage" || $action eq "imsend" || $action eq "imsend2" || $action eq "imshow" || $action eq "profileCheck" || $action eq "myviewprofile" || $action eq "myprofile" || $action eq "myprofileContacts" || $action eq "myprofileOptions" || $action eq "myprofileBuddy" || $action eq "myprofileIM" || $action eq "myprofileAdmin" || $action eq "myusersrecentposts") { $tmpaction = "mycenter"; }
		elsif ($action eq "messagepagetext" || $action eq "messagepagedrop" || $action eq "threadpagetext" || $action eq "threadpagedrop" || $action eq "post" || $action eq "notify" || $action eq "boardnotify" || $action eq "sendtopic" || $action eq "modify") { $tmpaction = "home"; }
		elsif ($action eq "guestpm2") { $tmpaction = "guestpm"; }
		else { $tmpaction = $action; }
	}
	else {
		$tmpaction = "home";
	}

	$tabsep = qq~<img src="$imagesdir/tabsep211.png" border="0" alt="" style="float: left; vertical-align: middle;" />~;
	$tabfill = qq~<img src="$imagesdir/tabfill.gif" border="0" alt="" style="vertical-align: middle;" />~;

	$tab{'home'} = qq~<span |><a href="$scripturl" title = "$img_txt{'103'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'103'}$tabfill</a></span>~;
	$tab{'help'} = qq~<span |><a href="$scripturl?action=help" title = "$img_txt{'119'}" style="padding: 3px 0 4px 0; cursor:help;">$tabfill$img_txt{'119'}$tabfill</a></span>~;
	if ($maxsearchdisplay > -1) {
		$tab{'search'} = qq~<span |><a href="$scripturl?action=search" title = "$img_txt{'182'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'182'}$tabfill</a></span>~;
	}
	if (!$ML_Allowed || ($ML_Allowed == 1 && !$iamguest) || ($ML_Allowed == 2 && $staff) || ($ML_Allowed == 3 && ($iamadmin || $iamgmod))) {
		$tab{'ml'} = qq~<span |><a href="$scripturl?action=ml" title = "$img_txt{'331'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'331'}$tabfill</a></span>~;
	}
	if ($iamadmin) {
		$tab{'admin'} = qq~<span |><a href="$boardurl/AdminIndex.$yyaext" title = "$img_txt{'2'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'2'}$tabfill</a></span>~;
	}
	if ($iamgmod) {
		if (-e ("$vardir/gmodsettings.txt")) {
			require "$vardir/gmodsettings.txt";
		}
		if ($allow_gmod_admin) {
			$tab{'admin'} = qq~<span |><a href="$boardurl/AdminIndex.$yyaext" title = "$img_txt{'2'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'2'}$tabfill</a></span>~;
		}
	}
	if ($sessionvalid == 0 && !$iamguest) {
		$sesredir = "";
		unless($action eq "revalidatesession" || $action eq "revalidatesession2") {
			$sestestenv = $testenv;
			$sestestenv =~ s/\=/\~/g;
			$sestestenv =~ s/;/x3B/g;
			if($sestestenv) { $sesredir = qq~;sesredir=$sestestenv~; }
		}
		$tab{'revalidatesession'} = qq~<span |><a href="$scripturl?action=revalidatesession$sesredir" title = "$img_txt{'34a'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'34a'}$tabfill</a></span>~;
	}
	if ($iamguest) {
		$tab{'login'} = qq~<span |><a href="$scripturl?action=login" title = "$img_txt{'34'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'34'}$tabfill</a></span>~;
		if ($regtype) {
			$tab{'register'} = qq~<span |><a href="$scripturl?action=register" title = "$img_txt{'97'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'97'}$tabfill</a></span>~;
		}
		if ($PMenableGuestButton && $PM_level > 0 && $PMenableBm_level > 0) {
			$tab{'guestpm'} = qq~<span |><a href="$scripturl?action=guestpm" title = "$img_txt{'pmadmin'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'pmadmin'}$tabfill</a></span>~;
		}
	}
	else {
		$tab{'mycenter'} = qq~<span |><a href="$scripturl?action=mycenter" title = "$img_txt{'mycenter'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'mycenter'}$tabfill</a></span>~;
		$tab{'logout'} = qq~<span |><a href="$scripturl?action=logout" title = "$img_txt{'108'}" style="padding: 3px 0 4px 0;">$tabfill$img_txt{'108'}$tabfill</a></span>~;
	}

	&LoadTabmenu;
}

sub mcMenu	{
	my ($display_prof, $display_posts, $display_pm, $tabPMHighlighted, $tabProfHighlighted, $tabNotifyHighlighted);

	my ($pmclass, $profclass, $postclass);
	if ($action eq "mycenter" || $action eq "im" || $action eq "imdraft" || $action eq "imoutbox" || $action eq "imstorage" || $action eq "imsend" || $action eq "imsend2" || $action eq "imshow") {
		$pmclass = qq~ class="selected"~;
		if ($PM_level == 0 || ($PM_level == 2 && !$iamadmin && !$iamgmod && !$iammod ) || ($PM_level == 3 && !$iamadmin && !$iamgmod)) {
			$profclass = qq~ class="selected"~;
		}
	}

	if ($action eq "profileCheck" || $action eq "myviewprofile" || $action eq "myprofile" || $action eq "myprofileContacts" || $action eq "myprofileOptions" || $action eq "myprofileBuddy" || $action eq "myprofileIM" || $action eq "myprofileAdmin") {
		$profclass = qq~ class="selected"~;
	}

	if ($action eq "favorites" || $action eq "shownotify" || $action eq "myusersrecentposts") {
		$postclass = qq~ class="selected"~;
	}

	$tabsep = qq~<img src="$imagesdir/tabsep211.png" border="0" alt="" style="float: left; vertical-align: middle;" />~;
	$tabfill = qq~<img src="$imagesdir/tabfill.gif" border="0" alt="" style="vertical-align: middle;" />~;

	# pm link
	if($PM_level == 1 || ($PM_level == 2 && ($iamadmin || $iamgmod || $iammod)) || ($PM_level == 3 && ($iamadmin || $iamgmod))   )	{
		$yymcmenu .= qq~<span onclick="changeToTab('pm'); return false;"$pmclass id="menu_pm"><a href="$scripturl?action=mycenter" onclick="changeToTab('pm'); return false;">$tabfill$mc_menus{'messages'}$tabfill</a></span>$tabsep
		~;
	}
	# profile link
	$yymcmenu .= qq~<span onclick="changeToTab('prof'); return false;"$profclass id="menu_prof"><a href="$scripturl?action=myviewprofile;username=$useraccount{$username}" onclick="changeToTab('prof'); return false;">$tabfill$mc_menus{'profile'}$tabfill</a></span>
	~;

	# posts link
	$yymcmenu .= qq~$tabsep<span onclick="changeToTab('posts'); return false;"$postclass  id="menu_posts"><a href="$scripturl?action=favorites" onclick="changeToTab('posts'); return false;">$tabfill$mc_menus{'posts'}$tabfill</a></span>
	~;

	$yymcmenu .= qq~$tabsep~;
}

1;