###############################################################################
# SendTopic.pl                                                                #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$sendtopicplver = 'YaBB 2.2.1 $Revision: 1.9.2.4 $';
if ($action eq 'detailedversion') { return 1; }

if ($regcheck) {
	require "$sourcedir/Decoder.pl";
}
&LoadLanguage('SendTopic');

sub SendTopic {
	$topic = $INFO{'topic'};
	&MessageTotals("load", $topic);
	$board = ${$topic}{'board'};
	&fatal_error("no_board_send") unless ($board ne '' && $board ne '_' && $board ne ' ');
	&fatal_error("no_topic_send") unless ($topic ne '' && $topic ne '_' && $topic ne ' ');

	fopen(FILE, "$datadir/$topic.txt") || &fatal_error("cannot_open","$datadir/$topic.txt", 1);
	@messages = <FILE>;
	fclose(FILE);
	($subject) = split(/\|/, $messages[0]);

	$yymain .= qq~
<form action="$scripturl?action=sendtopic2" method="post">
<table width="70%" border="0" align="center" cellspacing="0" cellpadding="3">
  <tr>
        <td class="titlebg" colspan="2">
        <img src="$imagesdir/email.gif" alt="" border="0" />
        <span class="text1"><b>$sendtopic_txt{'707'}&nbsp; &#171; $subject &#187; &nbsp;$sendtopic_txt{'708'}</b></span></td>
      </tr><tr>
        <td width="30%" class="windowbg" align="left"><b>$sendtopic_txt{'335'}:</b></td>
        <td width="70%" class="windowbg" align="left"><input type="text" name="y_name" size="50" maxlength="50" value="${$uid.$username}{'realname'}" /></td>
      </tr><tr>
        <td width="30%" class="windowbg" align="left"><b>$sendtopic_txt{'336'}:</b></td>
        <td width="70%" class="windowbg" align="left"><input type="text" name="y_email" size="50" maxlength="50" value="${$uid.$username}{'email'}" /></td>
      </tr><tr>
        <td class="windowbg" align="center" valign="top" colspan="2">
        		<hr width="100%" size="1" class="hr" />
        </td>
      </tr><tr>
        <td width="30%" class="windowbg" align="left"><b>$sendtopic_txt{'717'}:</b></td>
        <td width="70%" class="windowbg" align="left"><input type="text" name="r_name" size="50" maxlength="50" /></td>
      </tr><tr>
        <td width="30%" class="windowbg" align="left"><b>$sendtopic_txt{'718'}:</b></td>
        <td width="70%" class="windowbg" align="left"><input type="text" name="r_email" size="50" maxlength="50" /></td>
      </tr>
~;

	if ($regcheck) {
		&validation_code;
		$yymain .= qq~
	<tr>
        <td class="windowbg" align="center" valign="top" colspan="2">
        		<hr width="100%" size="1" class="hr" />
        </td>
      </tr><tr>
        <td width="30%" class="windowbg" align="left" valign="middle"><b>$floodtxt{'1'}:</b></td>
        <td width="70%" class="windowbg" align="left" valign="middle">$showcheck<br /><span class="small">$floodtxt{'casewarning'}</span></td>
      </tr><tr>
        <td width="30%" class="windowbg" align="left"><b>$floodtxt{'3'}:</b></td>
        <td width="70%" class="windowbg" align="left"><input type="text" maxlength="30" name="verification" id="verification" size="50" /></td>
      </tr>
~;
	}
	$yymain .= qq~
	<tr>
        <td class="windowbg" align="center" valign="top" colspan="2">
        		<hr width="100%" size="1" class="hr" />
        </td>
      </tr><tr>
        <td class="windowbg" align="center" colspan="2">
		<input type="hidden" name="board" value="$board" />
		<input type="hidden" name="topic" value="$topic" />
        <input type="submit" name="Send" value="$sendtopic_txt{'339'}" class="button" />
        </td>
      </tr>
    </table>
</form>
~;
	$yytitle = "$sendtopic_txt{'707'}&nbsp; &#171; $subject &#187; &nbsp;$sendtopic_txt{'708'}";
	$yynavigation = qq~&rsaquo; $sendtopic_txt{'707'}~;
	&template;
	exit;

}

sub SendTopic2 {
	$topic = $FORM{'topic'};
	$board = $FORM{'board'};
	&fatal_error("no_board_send") unless ($board ne '' && $board ne '_' && $board ne ' ');
	&fatal_error("no_topic_send") unless ($topic ne '' && $topic ne '_' && $topic ne ' ');

	$yname  = $FORM{'y_name'};
	$rname  = $FORM{'r_name'};
	$yemail = $FORM{'y_email'};
	$remail = $FORM{'r_email'};
	$yname =~ s/\A\s+//;
	$yname =~ s/\s+\Z//;
	$yemail =~ s/\A\s+//;
	$yemail =~ s/\s+\Z//;
	$rname =~ s/\A\s+//;
	$rname =~ s/\s+\Z//;
	$remail =~ s/\A\s+//;
	$remail =~ s/\s+\Z//;

	if ($regcheck) {
		&validation_check($FORM{'verification'});
	}

	&fatal_error("no_name","$sendtopic_txt{'335'}") unless ($yname ne '' && $yname ne '_' && $yname ne ' ');
	&fatal_error("sendname_too_long","$sendtopic_txt{'335'}") if (length($yname) > 25);
	&fatal_error("no_email","$sendtopic_txt{'336'}") if ($yemail eq '');
	&fatal_error("invalid_character","$sendtopic_txt{'336'} $sendtopic_txt{'241'}") if ($yemail !~ /[\w\-\.\+]+\@[\w\-\.\+]+\.(\w{2,4}$)/);
	&fatal_error("invalid_email","$sendtopic_txt{'336'}") if (($yemail =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) || ($yemail !~ /^.+@\[?(\w|[-.])+\.[a-zA-Z]{2,4}|[0-9]{1,4}\]?$/));
	&fatal_error("no_name","$sendtopic_txt{'717'}") unless ($rname ne '' && yname ne '_' && $rname ne ' ');
	&fatal_error("sendname_too_long","$sendtopic_txt{'717'}") if (length($rname) > 25);
	&fatal_error("no_email","$sendtopic_txt{'718'}") if ($remail eq '');
	&fatal_error("invalid_character","$sendtopic_txt{'718'} $sendtopic_txt{'241'}") if ($remail !~ /[\w\-\.\+]+\@[\w\-\.\+]+\.(\w{2,4}$)/);
	&fatal_error("invalid_email","$sendtopic_txt{'718'}")                                            if (($remail =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) || ($remail !~ /^.+@\[?(\w|[-.])+\.[a-zA-Z]{2,4}|[0-9]{1,4}\]?$/));

	fopen(FILE, "$datadir/$topic.txt") || &fatal_error("cannot_open","$datadir/$topic.txt", 1);
	@messages = <FILE>;
	fclose(FILE);
	($subject) = split(/\|/, $messages[0]);
	&FromHTML($subject);
	require "$sourcedir/Mailer.pl";
	&LoadLanguage('Email');
		my $message = &template_email($sendtopicemail, {'toname' => $rname, 'subject' => $subject, 'displayname' => $yname, 'num' => $topic});
	&sendmail($remail, "$sendtopic_txt{'118'}: $subject ($sendtopic_txt{'318'} $yname)", $message, $yemail);

	$yySetLocation = qq~$scripturl?num=$topic~;
	&redirectexit;
}

1;
