###############################################################################
# Register.pl                                                                 #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$registerplver = 'YaBB 2.2.1 $Revision: 1.57.2.15 $';
if ($action eq 'detailedversion') { return 1; }

if ($regcheck) {
	require "$sourcedir/Decoder.pl";
}
require "$sourcedir/Mailer.pl";
&LoadLanguage('Register');

my $serveros = "$^O";
if ($serveros =~ m/Win/) {
	my $regstyle = qq~ style="text-transform: lowercase"~;
} else {
	my $regstyle = '';
}

sub Register {
	if ($regtype == 0 && $iamguest) { &fatal_error("registration_disabled"); }
	my ($tmpregname, $tmpregemail, $tmpregpasswrd1, $tmpregpasswrd2, $hidechecked);
	if ($FORM{'reglanguage'}) {
		$language = $FORM{'reglanguage'};
		&LoadLanguage('Main');
		&LoadLanguage('Register');
	}
	if ($FORM{'tusername'})  { $tmpregname     = $FORM{'tusername'}; }
	if ($FORM{'trealname'})  { $tmprealname     = $FORM{'trealname'}; }
	if ($FORM{'temail'})     { $tmpregemail    = $FORM{'temail'}; }
	if ($FORM{'thideemail'}) { $hidechecked    = qq~checked="checked"~; }
	if ($FORM{'tpasswrd1'})  { $tmpregpasswrd1 = $FORM{'tpasswrd1'}; }
	if ($FORM{'tpasswrd2'})  { $tmpregpasswrd2 = $FORM{'tpasswrd2'}; }
	
	## moved langopt setup to subs.pl
	if(!$langopt)	{&guestLangSel;}

	if ($regcheck) {
		&validation_code;
	}
	if (!$iamguest) { &fatal_error("no_registration_logged_in"); }
	if (-e "$vardir/email_domain_filter.txt" ) { require "$vardir/email_domain_filter.txt"; }
	if ($adomains){
		@domains = split (/\,/, $adomains);
		$aedomains = qq~<table border="0" width="100%" cellspacing="0" cellpadding="0"><tr><td><input type="text" maxlength="30" name="email" value="$tmpregemail" size="15" /></td><td><select name="domain">~;
		foreach (@domains){$aedomains .= ($_ =~ m/\@/) ? qq~<option value="$_">$_</option>~ : qq~<option value="\@$_">&#64;$_</option>~;}
		$aedomains .= qq~</select></td></tr></table>~;
	}
	else {$aedomains .= qq~<input type="text" maxlength="60" name="email" value="$tmpregemail" size="45" />~;}

	$yymain .= qq~
<div class="bordercolor" style="padding: 1px;">
<table border="0" width="100%" cellspacing="0" class="bordercolor" cellpadding="4">
  <tr class="titlebg">
    <td colspan="2">
    <img src="$imagesdir/register.gif" alt="$register_txt{'97'}" border="0" /> <span class="text1"><b>$register_txt{'97'}</b> $register_txt{'517'}</span></td>
  </tr>
  <tr>
    <td class="windowbg2" colspan="2" align="center">$register_txt{'97a'}</td>
  </tr>
~;

	if ($morelang > 1) {
		$yymain .= qq~
  <tr class="windowbg">
    <td class="windowbg" width="100%">
        <b>$register_txt{'101'}</b>
	</td>
        <td>
		<form action="$scripturl?action=register" method="post" name="sellanguage">
	        <select name="reglanguage" onchange="addsettings(); submit();">
		$langopt
		</select>
		<input type="hidden" name="tusername" id="tusername" value="" />
		<input type="hidden" name="trealname" id="trealname" value="" />
		<input type="hidden" name="temail" id="temail" value="" />
		<input type="hidden" name="tpasswrd1" id="tpasswrd1" value="" />
		<input type="hidden" name="tpasswrd2" id="tpasswrd2" value="" />
		<input type="hidden" name="thideemail" id="thideemail" value="" />
		<noscript><input type="submit" value="$maintxt{'32'}" class="button" /></noscript>
		</form>
	</td>
  </tr>
~;
	}
	$yymain .= qq~
  <tr class="windowbg">
    <td class="windowbg" width="100%">
        * <b>$register_txt{'98'}:</b>
        <br /><span class="small">$register_txt{'520'}</span>
	</td>
    <td>
		<form action="$scripturl?action=register2" method="post" name="creator">
		<input type="text" name="regusername" size="30" value="$tmpregname" maxlength="18"$regstyle />
		<input type="hidden" name="language" id="language" value="$language" />
	</td>
  </tr>
  <tr class="windowbg">
    <td class="windowbg" width="100%">
        * <b>$register_txt{'98a'}:</b>~;
	if($name_cannot_be_userid) {
		$yymain .= qq~
        <br /><span class="small">$register_txt{'521'}</span>~;
	}
	$yymain .= qq~
	</td>
    <td>
		<input type="text" name="regrealname" size="30" value="$tmprealname" maxlength="30" />
	</td>
  </tr>
  <tr class="windowbg">
    <td>* <b>$register_txt{'69'}:</b>
        <br /><span class="small">$register_txt{'679'}</span>
	</td>
	<td valign="middle">
		$aedomains
~;
	if ($allow_hide_email == 1) {
		$yymain .= qq~<br />
		<input type="checkbox" name="hideemail" value="checked"$hidechecked /> $register_txt{'721'}
		~;
	} 
	$yymain .= qq~
	</td>
  </tr>
~;
	unless ($emailpassword) {
		$yymain .= qq~
  <tr class="windowbg">
	<td>* <b>$register_txt{'81'}:</b></td>
    <td><input type="password" maxlength="30" name="passwrd1" value="$tmpregpasswrd1" size="30" /></td>
  </tr><tr class="windowbg">
    <td>* <b>$register_txt{'82'}:</b></td>
    <td><input type="password" maxlength="30" name="passwrd2" value="$tmpregpasswrd2" size="30" /></td>
  </tr>
~;
	}
  # Kirsle
  $yymain .= qq~
  <tr class="windowbg">
	<td>* <b>Bot Check:</b>
	<br /><span class="small">Type the word "RiveScript" into this box.</span>
	</td>

	<td>
		<input type="text" name="kirslers" size="30" maxlength="30" />
	</td>
  </tr>
~;

	if ($addmemgroup_enabled == 1 || $addmemgroup_enabled == 3) {
		foreach (@nopostorder) {
			chomp $_;
			($title, undef, undef, undef, undef, undef, undef, undef, undef, undef, $additional) = split(/\|/, $NoPost{$_});
			if ($additional == 1) {
				$addmemgroup .= qq~<option value="$_">$title</option>~;
			}
		}
		my $additional_explain = $register_txt{'766'};
		if ($addmemgroup_enabled == 3) { $additional_explain = $register_txt{'767'}; }

		$yymain .= qq~
	<tr class="windowbg">
		<td>
			<b>$register_txt{'765'}:</b>
			<br /><span class="small">$additional_explain</span>
		</td>
		<td>
			<select name="joinmemgroup">
			<option value=""></option>
			$addmemgroup
			</select>
		</td>
	</tr>
	~;
	}

	if ($regcheck) {
		$yymain .= qq~
  <tr class="windowbg">
    <td>* <b>$floodtxt{'1'}:</b><br /><span class="small">$floodtxt{'casewarning'}</span></td>
    <td>$showcheck</td>
  </tr><tr class="windowbg">
    <td>* <b>$floodtxt{'3'}:</b></td>
    <td><input type="text" maxlength="30" name="verification" id="verification" size="30" /></td>
  </tr>
~;
	}

	if ($regtype == 1) {
		$yymain .= qq~
  <tr class="windowbg">
    <td valign="top">* <b>$prereg_txt{'regreason'}:</b><br /><span class="small">$prereg_txt{'reason_exp'}</span><br /><br />
    <td><textarea cols="60" rows="7" name="reason" id="reason">$reason</textarea>
              <span class="small">$prereg_txt{'16'} <input value="$RegReasonSymbols" size="3" name="msgCL" class="windowbg" style="border: 0px; width: 40px; padding: 1px; font-size: 11px;" readonly="readonly" /></span>
	</td>
  </tr>
	<script type="text/javascript" language="JavaScript">
	<!--
	var supportsKeys = false;
	function tick() {
		calcCharLeft(document.forms[0]);
		if (!supportsKeys) { timerID = setTimeout("tick()",$RegReasonSymbols); }
	}
	function calcCharLeft(sig) {
		clipped = false;
		maxLength = $RegReasonSymbols;
		if (document.creator.reason.value.length > maxLength) {
			document.creator.reason.value = document.creator.reason.value.substring(0,maxLength);
			charleft = 0;
			clipped = true;
		} else {
			charleft = maxLength - document.creator.reason.value.length;
		}
		document.creator.msgCL.value = charleft;
		return clipped;
		}
		tick();
		//-->
		</script>
~;
	}
	if ($RegAgree) {
		if ($language) {
			fopen(AGREE, "$langdir/$language/agreement.txt");
		} else {
			fopen(AGREE, "$langdir/$lang/agreement.txt");
		}
		@agreement = <AGREE>;
		fclose(AGREE);
		$fullagree = join("", @agreement);
		$fullagree =~ s/\n/<br \/>/g;
		$yymain .= qq~
  <tr>
	<td width="100%" colspan="2" class="windowbg">
		&nbsp;
	</td>
  </tr>
  <tr>
	<td width="100%" colspan="2" class="titlebg">
		<img src="$imagesdir/xx.gif" alt="$register_txt{'97'}" border="0" /> <b>$register_txt{'764a'}</b>
	</td>
  </tr>
  <tr>
	<td width="100%" colspan="2" class="windowbg2">
		<span style="float: left; padding: 5px;">
		<br />$fullagree<br /><br />
		</span>
	</td>
  </tr>
  <tr>
	<td width="100%" colspan="2" class="catbg" align="center">
		<b>$register_txt{'585'}</b> <input type="radio" name="regagree" value="yes" />
		&nbsp;&nbsp;&nbsp; <b>$register_txt{'586'}</b> <input type="radio" name="regagree" value="no" />
	</td>
  </tr>
  <tr>
	<td width="100%" colspan="2" class="windowbg">
		&nbsp;
	</td>
  </tr>

~;
	}

	$yymain .= qq~
  <tr class="titlebg">
	<td width="100%" colspan="2">
	<br /><center><input type="submit" value="$register_txt{'97'}" class="button" /></center>

	<!-- KIRSLE: lets try and stop spam bots? -->
	<div style="display: none">
	<strong>Do not edit these fields.</strong><br>
	<input type="text" size="40" name="comment"><br>
	<input type="text" size="40" name="address" value="http://"><br>
	<textarea cols="40" rows="4" name="message"></textarea>
	</div>
	<!-- /KIRSLE -->
	</td>
  </tr>
</table>
</div>
</form>
~;

	$yymain .= qq~


<script type="text/javascript" language="JavaScript"> <!--
	document.creator.regusername.focus();

	function addsettings() {
		var mailpass = $emailpassword;
		var hidemail = $allow_hide_email

		document.sellanguage.tusername.value = document.creator.regusername.value;
		document.sellanguage.tusername.value = document.creator.regrealname.value;
		document.sellanguage.temail.value = document.creator.email.value;
		if(hidemail == 1) {
			if(document.creator.hideemail.checked) document.sellanguage.thideemail.value = 1;
		}
		if(mailpass != 1) {
			document.sellanguage.tpasswrd1.value = document.creator.passwrd1.value;
			document.sellanguage.tpasswrd2.value = document.creator.passwrd1.value;
		}
	}
//--> </script>
~;
	$yytitle = $register_txt{'97'};
	$yynavigation = qq~&rsaquo; $register_txt{'97'}~;
	&template;
	exit;
}

sub Register2 { 
	# KIRSLE
	if ($FORM{'comment'} eq '' && $FORM{'address'} eq 'http://' && $FORM{'message'} eq '' && $FORM{'kirslers'} =~ /^rivescript$/i) {
		# Good, they passed my test. Delete these fields.
		delete $FORM{'comment'};
		delete $FORM{'address'};
		delete $FORM{'message'};
		delete $FORM{'kirslers'};
	}
	else {
		&fatal_error("registration_disabled");
	}
	# /KIRSLE
	if (!$regtype && $iamguest) { &fatal_error("registration_disabled"); } 
	if ($RegAgree && $FORM{'regagree'} ne 'yes') { &fatal_error('no_regagree'); }
	my %member;
	while (($key, $value) = each(%FORM)) {
		$value =~ s~\A\s+~~;
		$value =~ s~\s+\Z~~;
		unless($key eq "reason") {$value =~ s~[\n\r]~~g;}
		$member{$key} = $value;
	}
	if ($member{'domain'}) {$member{'email'} = qq($member{'email'}$member{'domain'});} 
	&email_domain_check($member{'email'});
	$member{'regusername'} =~ s/\s/_/g;

	# Make sure users can't register with banned details
	&banning("$member{'regusername'}", "$member{'email'}");

	# check if there is a system hash named like this by checking existence through size
	&fatal_error("system_prohibited_id", "($member{'regusername'})") if (keys(%{ $member{'regusername'} }) > 0);
	&fatal_error("id_to_long","($member{'regusername'})") if (length($member{'regusername'}) > 25);
	&fatal_error("email_to_long","($member{'email'})") if (length($member{'email'}) > 60);
	&fatal_error("realname_to_long","($member{'regrealname'})") if (length($member{'regrealname'}) > 30);
	&fatal_error("no_username","($member{'regusername'})") if ($member{'regusername'} eq '');
	&fatal_error("id_alfa_only","($member{'regusername'})") if ($member{'regusername'} eq '_');
	&fatal_error("id_reserved","$member{'regusername'}") if ($member{'regusername'} =~ /guest/i);
	&fatal_error("invalid_character","$register_txt{'35'} $register_txt{'241r'}") if ($member{'regusername'} =~ /[^\w\+\-\.\@]/);
	&fatal_error("no_email","($member{'regusername'})") if ($member{'email'} eq "");
	&fatal_error("id_taken","($member{'regusername'})") if (-e ("$memberdir/$member{'regusername'}.vars"));
	&fatal_error("password_is_userid") if ($member{'regusername'} eq $member{'passwrd1'});
	&fatal_error("no_reg_reason") if ($member{'reason'} eq "" && $regtype == 1);
	
	&FromChars($member{'regrealname'});
	$convertstr = $member{'regrealname'};
	$convertcut = 30;
	&CountChars;
	$member{'regrealname'} = $convertstr;
	&fatal_error("name_too_long") if ($cliped);

	&fatal_error('invalid_character', "$register_txt{'38'} $register_txt{'241re'}") if ($member{'regrealname'} =~ /[^ \w\x80-\xFF\[\]#\%\+,\-\|\.:=\?\@\^]/);

	if ($name_cannot_be_userid && lc $member{'regusername'} eq lc $member{'regrealname'}) { &fatal_error('name_is_userid'); }

	if (lc $member{'regusername'} eq lc &MemberIndex("check_exist", $member{'regusername'})) { &fatal_error("id_taken","($member{'regusername'})"); }
	if (lc $member{'email'} eq lc &MemberIndex("check_exist", $member{'email'})) { &fatal_error("email_taken","($member{'email'})"); }
	if (lc $member{'regrealname'} eq lc &MemberIndex("check_exist", $member{'regrealname'})) { &fatal_error("name_taken"); }

	&ToHTML($member{'email'});
	&ToHTML($member{'regrealname'});
	&ToChars($member{'regrealname'});

	if ($regtype == 1) {
		my $reason_len = $member{'reason'};
		$reason_len =~ s/[\r\n ]//ig;
		$reason_len =~ s/&#\d{3,}?\;/X/ig;
		if (length($reason_len) > $RegReasonSymbols) {
			$member{'reason'} = substr($member{'reason'}, 0, $RegReasonSymbols) . '...';
		}
		undef $reason_len;
		&ToHTML($member{'reason'});
		$member{'reason'} =~ s~\r~~g;
		$member{'reason'} =~ s~\n~<br \/>~g;
	}
	
	if ($regcheck) {
		&validation_check($member{'verification'});
	}

	if ($emailpassword) {
		srand();
		$member{'passwrd1'} = int(rand(100));
		$member{'passwrd1'} =~ tr/0123456789/ymifxupbck/;
		$_ = int(rand(77));
		$_ =~ tr/0123456789/q8dv7w4jm3/;
		$member{'passwrd1'} .= $_;
		$_ = int(rand(89));
		$_ =~ tr/0123456789/y6uivpkcxw/;
		$member{'passwrd1'} .= $_;
		$_ = int(rand(188));
		$_ =~ tr/0123456789/poiuytrewq/;
		$member{'passwrd1'} .= $_;
		$_ = int(rand(65));
		$_ =~ tr/0123456789/lkjhgfdaut/;
		$member{'passwrd1'} .= $_;
	} else {
		&fatal_error("password_mismatch","($member{'regusername'})") if ($member{'passwrd1'} ne $member{'passwrd2'});
		&fatal_error("no_password","($member{'regusername'})") if ($member{'passwrd1'} eq '');
		&fatal_error("invalid_character","$register_txt{'36'} $register_txt{'241'}") if ($member{'passwrd1'} =~ /[^\s\w!\@#\$\%\^&\*\(\)\+\|`~\-=\\:;'",\.\/\?\[\]\{\}]/);
	}
	&fatal_error("invalid_character","$register_txt{'69'} $register_txt{'241e'}") if ($member{'email'} !~ /^[\w\-\.\+]+\@[\w\-\.\+]+\.\w{2,4}$/);
	&fatal_error("invalid_email") if (($member{'email'} =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) || ($member{'email'} !~ /\A.+@\[?(\w|[-.])+\.[a-zA-Z]{2,4}|[0-9]{1,4}\]?\Z/));
	fopen(BAN, "$vardir/ban_email.txt");
	@banned = <BAN>;
	fclose(BAN);
	foreach $curban (@banned) {
		if ($member{'email'} eq "$curban") { &fatal_error("banned","$register_txt{'678'}$register_txt{'430'}!"); }
	}

	fopen(RESERVE, "$vardir/reserve.txt") || &fatal_error("cannot_open","$vardir/reserve.txt", 1);
	@reserve = <RESERVE>;
	fclose(RESERVE);
	fopen(RESERVECFG, "$vardir/reservecfg.txt") || &fatal_error("cannot_open","$vardir/reservecfg.txt", 1);
	@reservecfg = <RESERVECFG>;
	fclose(RESERVECFG);
	for ($a = 0; $a < @reservecfg; $a++) {
		chomp $reservecfg[$a];
	}
	$matchword = $reservecfg[0] eq 'checked';
	$matchcase = $reservecfg[1] eq 'checked';
	$matchuser = $reservecfg[2] eq 'checked';
	$matchname = $reservecfg[3] eq 'checked';
	$namecheck = $matchcase eq 'checked' ? $member{'regusername'} : lc $member{'regusername'};
	$realnamecheck = $matchcase eq 'checked' ? $member{'regrealname'} : lc $member{'regrealname'};

	foreach $reserved (@reserve) {
		chomp $reserved;
		$reservecheck = $matchcase ? $reserved : lc $reserved;
		if ($matchuser) {
			if ($matchword) {
				if ($namecheck eq $reservecheck) { &fatal_error('id_reserved',"$reserved"); }
			} else {
				if ($namecheck =~ $reservecheck) { &fatal_error('id_reserved',"$reserved"); }
			}
		}
		if ($matchname) {
			if ($matchword) {
				if ($realnamecheck eq $reservecheck) { &fatal_error('name_reserved',"$reserved"); }
			} else {
				if ($realnamecheck =~ $reservecheck) { &fatal_error('name_reserved',"$reserved"); }
			}
		}
	}

	if ($default_template) { $new_template = $default_template; }
	else { $new_template = qq~Forum default~; }

	# check if user isn't already registered
	&fatal_error("id_taken") if (-e ("$memberdir/$member{'regusername'}.vars"));
	# check if user isn't already in pre-registration
	&fatal_error("already_preregged") if (-e ("$memberdir/$member{'regusername'}.pre"));
	&fatal_error("already_preregged") if (-e ("$memberdir/$member{'regusername'}.wait"));

	if ($send_welcomeim == 1 && $regtype == 3) {
		# new format msg file:
		# messageid|(from)user|(touser(s))|(ccuser(s))|(bccuser(s))|subject|date|message|(parentmid)|reply#|ip|messagestatus|flags|storefolder|attachment
		$messageid = $^T . $$;
		fopen(IM, ">$memberdir/$member{'regusername'}.msg", 1);
		print IM "$messageid|$sendname|$member{'regusername'}|||$imsubject|$date|$imtext|$messageid|0|$ENV{'REMOTE_ADDR'}|s|u||\n";
		fclose(IM);
	}
	
	if ($new_template !~ m^\A[0-9a-zA-Z\_\(\)\ \#\%\-\:\+\?\$\&\~\.\,\@]+\Z^ && $new_template ne '') { &fatal_error('invalid_template'); }
	if ($member{'language'} !~ m^\A[0-9a-zA-Z\_\(\)\ \#\%\-\:\+\?\$\&\~\.\,\@]+\Z^ && $member{'language'} ne '') { &fatal_error('invalid_language'); }

	&ToHTML($member{'hideemail'});
	&ToHTML($member{'language'});

	$member{'joinmemgroup'} = '';
	if (($addmemgroup_enabled == 1 || $addmemgroup_enabled == 3) && $FORM{'joinmemgroup'} ne '') {
		foreach (keys %NoPost) {
			my $additional = (split /\|/, $NoPost{$_})[10];
			if ($additional == 1 && $FORM{'joinmemgroup'} eq $_) { $member{'joinmemgroup'} = $_; }
		}
		&ToHTML($member{'joinmemgroup'});
	}

	$encryptopass = &encode_password($member{'passwrd1'});
	$reguser = $member{'regusername'};
	$registerdate = &timetostring($date);
	$language = $member{'language'};
	
	${$uid.$reguser}{'password'} = $encryptopass;
	${$uid.$reguser}{'realname'} = $member{'regrealname'};
	${$uid.$reguser}{'email'} = lc($member{'email'});
	${$uid.$reguser}{'postcount'} = 0;
	${$uid.$reguser}{'regreason'} = $member{'reason'};
	${$uid.$reguser}{'usertext'} = $defaultusertxt; 
	${$uid.$reguser}{'userpic'} = "blank.gif";
	${$uid.$reguser}{'regdate'} = $registerdate;
	${$uid.$reguser}{'regtime'} = $date;
	${$uid.$reguser}{'timeselect'} = $timeselected;
	${$uid.$reguser}{'timeoffset'} = $timeoffset;
	${$uid.$reguser}{'dsttimeoffset'} = $dstoffset;
	${$uid.$reguser}{'lastips'} = $user_ip;
	${$uid.$reguser}{'hidemail'} = $member{'hideemail'};
	${$uid.$reguser}{'timeformat'} = qq~MM D+ YYYY @ HH:mm:ss*~;
	${$uid.$reguser}{'template'} = $new_template;
	${$uid.$reguser}{'language'} = $language;
	${$uid.$reguser}{'pageindex'} = qq~1|1|1|1~;
	${$uid.$reguser}{'addgroups'} = $member{'joinmemgroup'};

	if ($regtype == 1 || $regtype == 2) {
		# If a pre-registration list exists load it
		if (-e "$memberdir/memberlist.inactive") {
			fopen(INACT, "$memberdir/memberlist.inactive");
			@reglist = <INACT>;
			fclose(INACT);
		}
		foreach $regline (@reglist) {
			chomp $regline;
			(undef, undef, $regmember, undef) = split(/\|/, $regline);
			if ($reguser eq $regmember) { &fatal_error("already_preregged"); last; }
		}

		# create pre-registration .pre file and write log and inactive list
		$regpassword = $member{'passwrd1'};
		$regtime     = int(time);
		if ($regcheck) {
			&validation_code;
		}
		$activationcode = substr($sessionid, 0, 20);

		&UserAccount($reguser, "preregister");
		if($do_scramble_id){$cryptuser = &cloak($reguser);} else {$cryptuser = $reguser; }
		fopen(INACT, ">$memberdir/memberlist.inactive", 1);
		foreach $curreg (@reglist) { print INACT "$curreg\n"; }
		print INACT "$regtime|$activationcode|$reguser|$regpassword\n";
		fclose(INACT);
		fopen(REGLOG, ">>$vardir/registration.log", 1);
		print REGLOG "$regtime|N|$member{'regusername'}|\n";
		fclose(REGLOG);
		my $templanguage = $language;
		$language = $member{'language'};
		&LoadLanguage('Email');
		## send an e-mail to the user that registration is pending e-mail validation within the given timespan. ##
		if ($regtype == 1 || $regtype == 2) {
			my $message = &template_email($preregemail, {'displayname' => $member{'regrealname'}, 'username' => $reguser, 'cryptusername' => $cryptuser, 'password' => $member{'passwrd1'}, 'activationcode' => $activationcode, 'preregspan' => $preregspan});
			&sendmail(${$uid.$reguser}{'email'}, "$mailreg_txt{'apr_result_activate'} $mbname", $message,'',$emailcharset);
			$language = $templanguage;
			$yymain .= qq~
				<div class="bordercolor" style="width: 650px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">
					<div class="bordercolor" style="width: 650px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">
						<table cellpadding="4" cellspacing="1" border="0" width="100%" align="center">
							<tr><td class="titlebg"><img src="$imagesdir/register.gif" alt="$prereg_txt{'1a'}" border="0" /><b>$prereg_txt{'1a'}</b></td></tr>
							<tr><td class="windowbg" align="left">$prereg_txt{'1'}</td></tr>
						</table>
					</div>
				</div>~;
			$yytitle = "$prereg_txt{'1a'}";
		}
	} else {
		&UserAccount($reguser, "register"); # AK108 - fixed some code here, looked odd before.
		&MemberIndex("add", $reguser);
		&FormatUserName($reguser);
		if($do_scramble_id){$cryptuser = &cloak($reguser);} else {$cryptuser = $reguser; }
		if ($emailpassword) {
			my $templanguage = $language;
			$language = $member{'language'};
			&LoadLanguage('Email');
			my $message = &template_email($passwordregemail, {'displayname' => $member{'regrealname'}, 'username' => $reguser, 'password' => $member{'passwrd1'}});
			&sendmail($member{'email'}, "$mailreg_txt{'apr_result_info'} $mbname", $message,'',$emailcharset);
			$language = $templanguage;
			$yymain .= qq~
<div class="bordercolor" style="width: 650px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">
		<table cellpadding="4" cellspacing="1" border="0" width="100%" align="center">
			<tr><td class="titlebg"><b>$register_txt{'97'}</b></td></tr>
			<tr><td class="windowbg" align="left">$register_txt{'703'}</td></tr>
			<tr><td class="windowbg2" align="left">$register_txt{'704'}</td></tr>
		</table>
</div>~;
		} else {
			if ($emailwelcome) {
				my $templanguage = $language;
				$language = $member{'language'};
				&LoadLanguage('Email');
				my $message = &template_email($welcomeregemail, {'displayname' => $member{'regrealname'}, 'username' => $reguser, 'password' => $member{'passwrd1'}});
				&sendmail($member{'email'}, "$mailreg_txt{'apr_result_info'} $mbname", $message,'',$emailcharset);
				$language = $templanguage;
			}
			$yymain .= qq~
			<br /><br />
			<form action="$scripturl?action=login2" method="post">
			<table border="0" width="300" cellspacing="1" class="bordercolor" align="center">
			<tr>
			<td class="titlebg">
			<img src="$imagesdir/register.gif" alt="$register_txt{'97'}" border="0" /> <span class="text1"><b>$register_txt{'97'}</b></span></td>
			</tr><tr>
			<td class="windowbg" align="center">
			<br />$register_txt{'431'}<br /><br />
			<input type="hidden" name="username" value="$member{'regusername'}" />
			<input type="hidden" name="passwrd" value="$member{'passwrd1'}" />
			<input type="hidden" name="cookielength" value="$Cookie_Length" />
			<input type="submit" value="$register_txt{'34'}" class="button" />
			</td>
			</tr>
			</table>
			</form>
			<br /><br />
			~;
		}
		$yytitle = "$register_txt{'245'}";
	}
	&template;
	exit;
}

sub activation_check {
	$changed  = 0;
	$timer    = int(time);
	$timespan = $preregspan * 3600;
	fopen(INACT, "$memberdir/memberlist.inactive");
	@actlist = <INACT>;
	fclose(INACT);

	# check if user is in pre-registration and check activation key
	foreach $regline (@actlist) {
		($regtime, undef, $regmember, undef) = split(/\|/, $regline);
		$difftime = $timer - $regtime;
		if ($difftime > $timespan) {
			$changed = 1;
			unlink "$memberdir/$regmember.pre";

			# add entry to registration log
			fopen(REGLOG, ">>$vardir/registration.log", 1);
			print REGLOG "$timer|T|$regmember|\n";
			fclose(REGLOG);
		} else {
			# update non activate user list
			# write valid registration to the list again
			push(@outlist, $regline);
		}
	}
	if ($changed) {
		# re-open inactive list for update if changed
		fopen(INACT, ">$memberdir/memberlist.inactive", 1);
		print INACT @outlist;
		fclose(INACT);
	}
}

sub user_activation {
	$changed       = 0;
	$reguser       = $_[0] || $INFO{'username'};
	$activationkey = $_[1] || $INFO{'activationkey'};
	fatal_error('wrong_id') unless $reguser;
	if (!-e "$memberdir/$reguser.pre" && -e "$memberdir/$reguser.vars") { &fatal_error("already_activated"); }
	if (!-e "$memberdir/$reguser.pre") { &fatal_error("prereg_expired"); }
	# If a pre-registration list exists load it
	if (-e "$memberdir/memberlist.inactive") {
		fopen(INACT, "$memberdir/memberlist.inactive");
		@reglist = <INACT>;
		fclose(INACT);
	}
	if (-e "$memberdir/memberlist.approve" && $regtype == 1) {
		fopen(APR, "$memberdir/memberlist.approve");
		@aprlist = <APR>;
		fclose(APR);
	}

	# check if user is in pre-registration and check activation key
	foreach $regline (@reglist) {
		($regtime, $testkey, $regmember, $regpassword) = split(/\|/, $regline);

		# update non activate user list
		if ($regmember ne $reguser) {
			push(@chnglist, $regline);
		} else {
			if ($activationkey ne $testkey) {
				push(@chnglist, $regline);
				# add entry to registration log
				my $logtime = int(time);
				fopen(REGLOG, ">>$vardir/registration.log", 1);
				print REGLOG "$logtime|E|$reguser|\n";
				fclose(REGLOG);
				&fatal_error("wrong_code");
			} else {
				if ($regtype == 2){
					$changed = 1;
					# user is in list and the keys match, so let him/her in
					rename("$memberdir/$reguser.pre", "$memberdir/$reguser.vars");
					&UserCheck($reguser, "email");
					&MemberIndex("add", $reguser);
					if ($iamadmin || $iamgmod) { $actuser = $username; } else { $actuser = $reguser; }
					# add entry to registration log
					my $logtime = int(time);
					fopen(REGLOG, ">>$vardir/registration.log", 1);
					print REGLOG "$logtime|A|$reguser|$actuser\n";
					fclose(REGLOG);
					if ($send_welcomeim == 1) {
						# new format msg file:
						# messageid|(from)user|(touser(s))|(ccuser(s))|(bccuser(s))|subject|date|message|(parentmid)|reply#|ip|messagestatus|flags|storefolder|attachment
						$messageid = $^T . $$;
						fopen(INBOX, ">$memberdir/$reguser.msg");
						print INBOX "$messageid|$sendname|$reguser|||$imsubject|$date|$imtext|$messageid|0|$ENV{'REMOTE_ADDR'}|s|u||\n";
						fclose(INBOX);
					}
					if ($emailpassword) {
						&LoadUser($reguser);
						my $templanguage = $language;
						$language = ${$uid.$reguser}{'language'};
						&LoadLanguage('Email');
						my $message = &template_email($activatedpassregemail, {'displayname' => ${$uid.$reguser}{'realname'}, 'username' => $reguser, 'password' => $regpassword});
						&sendmail(${$uid.$reguser}{'email'}, "$mailreg_txt{'apr_result_validate'} $mbname", $message,'',$emailcharset);
						$language = $templanguage;
						$yymain .= qq~<br /><table border="0" width="100%" cellspacing="1" class="bordercolor" align="center">~;
						$sharedLogin_title = $register_txt{'97'};
						$sharedLogin_text  = $register_txt{'703'};
						$yymain .= qq~</table>~;
					} else {
						if ($emailwelcome && regtype != 1) {
							&LoadUser($reguser);
							my $templanguage = $language;
							$language = ${$uid.$reguser}{'language'};
							&LoadLanguage('Email');
							my $message = &template_email($activatedwelcomeregemail, {'displayname' => ${$uid.$reguser}{'realname'}, 'username' => $reguser, 'password' => $regpassword});
							&sendmail(${$uid.$reguser}{'email'}, "$mailreg_txt{'apr_result_validate'} $mbname", $message,'',$emailcharset);
							$language = $templanguage;
						}
					}
				} elsif ($regtype == 1){
					$changed = 1;
					# user is in list and the keys match, so move him/her for admin approval
					push(@aprchnglist, $regline);
					rename("$memberdir/$reguser.pre", "$memberdir/$reguser.wait");
					# add entry to registration log
					my $logtime = int(time);
					if ($iamadmin || $iamgmod) { $actuser = $username; } else { $actuser = $reguser; }
					fopen(REGLOG, ">>$vardir/registration.log", 1);
					print REGLOG "$logtime|W|$reguser|$actuser\n";
					fclose(REGLOG);
					&LoadUser($reguser);
					my $templanguage = $language;
					$language = ${$uid.$reguser}{'language'};
					&LoadLanguage('Email');
					my $message = &template_email($approveregemail, {'username' => $reguser,'displayname' => ${$uid.$reguser}{'realname'}});
					&sendmail(${$uid.$reguser}{'email'}, "$mailreg_txt{'apr_result_wait'} $mbname", $message,'',$emailcharset);
					$language = $templanguage;
				}
			}
		}
	}
	if ($changed) {
		# if changed write new inactive list
		fopen(INACT, ">$memberdir/memberlist.inactive");
		print INACT @chnglist;
		fclose(INACT);
		## add the rest of the awaiting approvals to the list (we need this list for the email password option) ##
		if($regtype == 1) {
			foreach $aprline (@aprlist) {
				(undef, undef, $regmember, undef) = split(/\|/, $aprline);
		
				if ($regmember ne $reguser) {
					push(@aprchnglist, $aprline);
				}
			}
			# update approval user list
			fopen(APR, ">$memberdir/memberlist.approve");
			print APR @aprchnglist;
			fclose(APR);
		}
	}
	if ($regtype == 1){
			$yymain .= qq~
				<div class="bordercolor" style="width: 650px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">
					<div class="bordercolor" style="width: 650px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">
						<table cellpadding="4" cellspacing="1" border="0" width="100%" align="center">
							<tr><td class="titlebg"><img src="$imagesdir/register.gif" alt="$prereg_txt{'1b'}" border="0" /><b>$prereg_txt{'1a'}</b></td></tr>
							<tr><td class="windowbg" align="left">$prereg_txt{'13'}</td></tr>
						</table>
					</div>
				</div>~;
			$yytitle = "$prereg_txt{'1b'}";
	}elsif ($regtype == 2){
		$yymain .= qq~
		<br /><br />
		<table border="0" width="650" cellspacing="1" class="bordercolor" align="center">
		<tr>
		<td colspan="2" class="titlebg">
		<img src="$imagesdir/register.gif" alt="$prereg_txt{'1a'}" border="0" /> <span class="text1"><b>$prereg_txt{'1a'}</b></span></td>
		</tr><tr>
		<td colspan="2" class="windowbg" align="center">
		<br />$prereg_txt{'5'}~;
		$yymain .= $prereg_txt{'5a'} unless $emailpassword;
		$yymain .= qq~$prereg_txt{'5b'}<br /><br />~;
		if ($emailpassword) {
			$yymain .= qq~$register_txt{'703'}<br /> <br />~;
		}
		$yymain .= qq~
		</td>
		</tr>
		</table>
		~;

		if (!$iamadmin && !$iamgmod) {
			unless($emailpassword) {
				$yymain .= qq~<div class="bordercolor" style="width: 650px; margin-bottom: 8px; margin-left: auto; margin-right: auto;">~;
				require "$sourcedir/LogInOut.pl";
				$yymain .= &sharedLogin;
				$yymain .= qq~</div>~;
			} else {
				$yymain .= qq~<br /><br />~;
			}
		}
		$yytitle = "$prereg_txt{'5'}";
	}

	if ($iamadmin || $iamgmod) {
		$yySetLocation = qq~$adminurl?action=view_reglog~;
		&redirectexit;
	} else {
		&template;
		exit;
	}

}

1;

