###############################################################################
# Printpage.pl                                                                #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$printpageplver = 'YaBB 2.2.1 $Revision: 1.6.2.6 $';
if ($action eq 'detailedversion') { return 1; }

my $oops = qq~$maintxt{'40'}&nbsp;&nbsp;~;
$oops .= qq~$maintxt{'41'} <a href="$scripturl?action=login">$img{'login'}</a>~;
if ($regtype) { $oops .= qq~ $maintxt{'42'} <a href="$scripturl?action=register">$img{'register'}</a>!!<br />~; }

sub Print_IM {
	if    ($INFO{'caller'} == 1) { fopen(THREADS, "$memberdir/$username.msg")    || &donoopen; $boxtitle = "$maintxt{'316'}"; $type = "$maintxt{'318'}" }
	elsif ($INFO{'caller'} == 2) { fopen(THREADS, "$memberdir/$username.outbox") || &donoopen; $boxtitle = "$maintxt{'320'}"; $type = "$maintxt{'324'}"; }
	else { fopen(THREADS, "$memberdir/$username.imstore") || &donoopen; $boxtitle = "$load_imtxt{'46'}"; $type = "$maintxt{'318'}/$maintxt{'324'}"; }
	@threads = <THREADS>;
	fclose(THREADS);

	### Lets output all that info. ###
	print "Content-type: text/html\n\n";
	print qq~
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>$mbname - $maintxt{'668'}</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<script language="JavaScript" type="text/javascript">
<!--
function printPage() {
   if (window.print) {
      agree = confirm('$maintxt{773}');
      if (agree) window.print(); 
   }
}
// -->
</script>
</head>


<body onload="printPage()">

<table width="96%" align="center">
  <tr>
    <td>
    <span style="font-family: arial, sans-serif; font-size: 18px; font-weight: bold;">$mbname</span>
    <br />
    <span style="font-family: arial, sans-serif; font-size: 10px;">$scripturl</span>
    <br />
    <span style="font-family: arial, sans-serif; font-size: 14px; font-weight: bold;">$load_imtxt{'71'} $boxtitle $maintxt{'30'} $date</span>
    </td>
  </tr>
</table>

<br />

~;

	# Split the threads up so we can print them.
	foreach $thread (@threads) {
		($threadposter, $threadtitle, $threaddate, $threadpost, undef) = split(/\|/, $thread);

		&do_print;
		print qq~
		<table width="96%" align="center" cellpadding="10" style="border: 1px solid #000000;">
  <tr>
    <td><span style="font-family: arial, sans-serif; font-size: 12px;">
    $maintxt{'70'}: <b>$threadtitle</b><br />
    $type <b>$threadposter</b> $maintxt{'30'} <b>$threaddate</b>
    </span>
    <hr width="100%" size="1" />
    <span style="font-family: arial, sans-serif; font-size: 12px;">
    $threadpost
    </span></td>
    </tr>
</table>

<br />
~;
	}
	print qq~
<table width="96%" align="center">
  <tr>
    <td align="center">
	  <span style="font-family: arial, sans-serif; font-size: 10px;">
    $yycopyright
    </span>
    </td>
  </tr>
</table>

</body>
</html>~;
	exit;
}

sub Print {
	$num = $INFO{'num'};

	# Determine category
	$curcat = ${$uid.$currentboard}{'cat'};
	&MessageTotals("load", $num);

	my $ishidden;
	if (${$num}{'threadstatus'} =~ /h/i) {
		$ishidden = 1;
	}

	if ($ishidden && !$iammod && !$iamadmin && !$iamgmod) { &fatal_error("no_access"); }

	# Figure out the name of the category
	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
	($cat, $catperms) = split(/\|/, $catinfo{"$curcat"});

	($boardname, $boardperms, $boardview) = split(/\|/, $board{"$currentboard"});

	&LoadCensorList;

	# Lets open up the thread file itself
	fopen(THREADS, "$datadir/$num.txt") || &donoopen;
	@threads = <THREADS>;
	fclose(THREADS);
	$cat =~ s/\n//g;

	($messagetitle, $poster, undef, $date, undef) = split(/\|/, $threads[0]);

	$startedby = $poster;
	$startedon = timeformat($date, 1);
	&ToChars($messagetitle);
	$messagetitle =~ s/\[m.*?\]/$maintxt{'758'}/;

	### Lets output all that info. ###
	print "Content-type: text/html\n\n";
	print qq~<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>$mbname - $maintxt{'668'}</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<script language="JavaScript" type="text/javascript">
<!--
function printPage() {
   if (window.print) {
      agree = confirm('$maintxt{773}');
      if (agree) window.print(); 
   }
}
// -->
</script>
</head>

<body onload="printPage()">

<table width="96%" align="center">
  <tr>
    <td>
    <span style="font-family: arial, sans-serif; font-size: 18px; font-weight: bold;">$mbname</span>
    <br />
    <span style="font-family: arial, sans-serif; font-size: 10px;">$scripturl</span>
    <br />
    <span style="font-family: arial, sans-serif; font-size: 16px; font-weight: bold;">$cat &gt;&gt; $boardname &gt;&gt; $messagetitle</span>
    <br />
    <span style="font-family: arial, sans-serif; font-size: 10px;">$scripturl?num=$num</span>
    <br />
    <hr size="1" width="100%" />
    <span style="font-family: arial, sans-serif; font-size: 14px; font-weight: bold;">$maintxt{'195'} $startedby $maintxt{'30'} $startedon</span>
    </td>
  </tr>
</table>

<br />~;

	# Split the threads up so we can print them.
	foreach $thread (@threads) {
		($threadtitle, $threadposter, undef, $threaddate, undef, undef, undef, undef, $threadpost) = split(/\|/, $thread);

		$threadtitle =~ s/\[m.*?\]/$maintxt{'758'}/;
		&do_print;

		print qq~
<table width="96%" align="center" cellpadding="10" style="border: 1px solid #000000;">
  <tr>
    <td><span style="font-family: arial, sans-serif; font-size: 12px;">
    $maintxt{'196'}: <b>$threadtitle</b><br />
    $maintxt{'197'} <b>$threadposter</b> $maintxt{'30'} <b>$threaddate</b>
    </span>
    <hr width="100%" size="1" />
    <span style="font-family: arial, sans-serif; font-size: 12px;">
    $threadpost
    </span></td>
    </tr>
</table>

<br />~;
	}

	print qq~
<table width="96%" align="center">
  <tr>
    <td align="center">
	  <span style="font-family: arial, sans-serif; font-size: 10px;">
    $yycopyright
    </span>
    </td>
  </tr>
</table>

</body>
</html>~;
	exit;
}

sub sizefont {
	# limit minimum and maximum font pitch as CSS does not restrict it at all.
	my ($tsize, $ttext) = @_;
	if    (!$fontsizemax)         { $fontsizemax = 72; }
	if    (!$fontsizemin)         { $fontsizemin = 6; }
	if    ($tsize < $fontsizemin) { $tsize       = $fontsizemin; }
	elsif ($tsize > $fontsizemax) { $tsize       = $fontsizemax; }
	my $resized = qq~<span style="font-size:$tsize\px;">$ttext</span>~;
	return $resized;
}

{
	my %killhash = (
		';'  => '&#059;',
		'!'  => '&#33;',
		'('  => '&#40;',
		')'  => '&#41;',
		'-'  => '&#45;',
		'.'  => '&#46;',
		'/'  => '&#47;',
		':'  => '&#58;',
		'?'  => '&#63;',
		'['  => '&#91;',
		'\\' => '&#92;',
		']'  => '&#93;',
		'^'  => '&#94;');

	sub codemsg {
		my $code = $_[0];
		if ($code !~ /&\S*;/) { $code =~ s/;/&#059;/g; }
		$code =~ s~([\(\)\-\:\\\/\?\!\]\[\.\^])~$killhash{$1}~g;
		$_ = qq~<br /><b>Code:</b><br /><table cellspacing="1" width="90%"><tr><td width="100%"><table width="100%" cellpadding="2" cellspacing="0"><tr><td><font face="courier" size="1">CODE</font></td></tr></table></td></tr></table>~;
		$_ =~ s~CODE~$code~g;
		return $_;
	}
}

sub donoopen {
	print qq~
<html>
<head>
<title>$maintxt{'199'}</title>
</head>
<body>
<font size="2" face="Arial,Helvetica"><center>$maintxt{'199'}</center></font>
</body>
</html>~;
	exit;
}

sub do_print {

	$threadpost =~ s~<br />~\n~ig;
	$threadpost =~ s~\[highlight(.*?)\](.*?)\[/highlight\]~$2~isg;
	$threadpost =~ s~\[code\]\n*(.+?)\n*\[/code\]~<br /><b>Code:</b><br /><table cellspacing="1"><tr><td><table cellpadding="2" cellspacing="0"><tr><td><font face="Courier" size="1">$1</font></td></tr></table></td></tr></table>~isg;

	$threadpost =~ s~\[([^\]]{0,30})\n([^\]]{0,30})\]~\[$1$2\]~g;
	$threadpost =~ s~\[/([^\]]{0,30})\n([^\]]{0,30})\]~\[/$1$2\]~g;
	$threadpost =~ s~(\w+://[^<>\s\n\"\]\[]+)\n([^<>\s\n\"\]\[]+)~$1\n$2~g;

	$threadpost =~ s~\[b\](.*?)\[/b\]~<b>$1</b>~isg;
	$threadpost =~ s~\[i\](.*?)\[/i\]~<i>$1</i>~isg;
	$threadpost =~ s~\[u\](.*?)\[/u\]~<u>$1</u>~isg;
	$threadpost =~ s~\[s\](.*?)\[/s\]~<s>$1</s>~isg;
	$threadpost =~ s~\[move\](.*?)\[/move\]~$1~isg;

	$threadpost =~ s~\[glow(.*?)\](.*?)\[/glow\]~&elimnests($2)~eisg;
	$threadpost =~ s~\[shadow(.*?)\](.*?)\[/shadow\]~&elimnests($2)~eisg;

	$threadpost =~ s~\[shadow=(\S+?),(.+?),(.+?)\](.+?)\[/shadow\]~$4~eisg;
	$threadpost =~ s~\[glow=(\S+?),(.+?),(.+?)\](.+?)\[/glow\]~$4~eisg;

	$threadpost =~ s~\[color=([\w#]+)\](.*?)\[/color\]~$2~isg;
	$threadpost =~ s~\[black\](.*?)\[/black\]~$1~isg;
	$threadpost =~ s~\[white\](.*?)\[/white\]~$1~isg;
	$threadpost =~ s~\[red\](.*?)\[/red\]~$1~isg;
	$threadpost =~ s~\[green\](.*?)\[/green\]~$1~isg;
	$threadpost =~ s~\[blue\](.*?)\[/blue\]~$1~isg;
	
	$threadpost =~ s~\[moved\]~$maintxt{'160'}~;
	$threadpost =~ s~\[move by\]~$maintxt{'525'}~;
	$threadpost =~ s~\[split\]~$maintxt{'160c'}~;
	$threadpost =~ s~\[splithere\]~$maintxt{'160b'}~;
	$threadpost =~ s~\[spliced\]~$maintxt{'160a'}~;
	$threadpost =~ s~\[splicedhere\]~$maintxt{'160b'}~;
	$threadpost =~ s~\[splithere_end\]~$maintxt{'160d'}~;

	$threadpost =~ s~\[font=(.+?)\](.+?)\[/font\]~<span style="font-family:$1;">$2</span>~isg;
	while ($threadpost =~ s~\[size=(.+?)\](.+?)\[/size\]~&sizefont($1,$2)~eisg) { }

	$threadpost =~ s~\[quote\s+author=(.*?)\s+link=(.*?)\].*\/me\s+(.*?)\[\/quote\]~\[quote author=$1 link=$2\]<i>* $1 $3</i>\[/quote\]~isg;
	$threadpost =~ s~\[quote(.*?)\].*\/me\s+(.*?)\[\/quote\]~\[quote$1\]<i>* Me $2</i>\[/quote\]~isg;
	$threadpost =~ s~\/me\s+(.*)~* $displayname $1~ig;

	$hardspace = qq~&nbsp;~;
	$char_160  = chr(160);
	$threadpost =~ s~\[img\](?:\s|\t|\n|$hardspace|$char_160)*(https\:\/\/|ftp\:\/\/)(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~<img src="$1$2" alt="" border="0" />~isg;
	$threadpost =~ s~\[img\](?:\s|\t|\n|$hardspace|$char_160)*(http\:\/\/)*(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~<img src="http\:\/\/$2" alt="" border="0" />~isg;
	$threadpost =~ s~\[img width=(\d+) height=(\d+)\](?:\s|\t|\n|$hardspace|$char_160)*(http\:\/\/)*(.+?)(?:\s|\t|\n|$hardspace|$char_160)*\[/img\]~restrictimage($1,$2,'http://'.$4)~eisg;

	$threadpost =~ s~\[tt\](.*?)\[/tt\]~<tt>$1</tt>~isg;
	$threadpost =~ s~\[left\](.*?)\[/left\]~<div style="text-align: left;">$1</div>~isg;
	$threadpost =~ s~\[center\](.*?)\[/center\]~<center>$1</center>~isg;
	$threadpost =~ s~\[right\](.*?)\[/right\]~<div style="text-align: right;">$1</div>~isg;
	$threadpost =~ s~\[justify\](.*?)\[/justify\]~<div style="text-align: justify">$1</div>~isg;
	$threadpost =~ s~\[sub\](.*?)\[/sub\]~<sub>$1</sub>~isg;
	$threadpost =~ s~\[sup\](.*?)\[/sup\]~<sup>$1</sup>~isg;
	$threadpost =~ s~\[fixed\](.*?)\[/fixed\]~<span style="font-family: Courier New;">$1</span>~isg;

	$threadpost =~ s~\[\[~\{\{~g;
	$threadpost =~ s~\]\]~\}\}~g;
	$threadpost =~ s~\|~\&#124;~g;
	$threadpost =~ s~\[hr\]\n~<hr width="40%" align="left" size="1" class="hr" />~g;
	$threadpost =~ s~\[hr\]~<hr width="40%" align="left" size="1" class="hr" />~g;
	$threadpost =~ s~\[br\]~\n~ig;

	$threadpost =~ s~\[flash\](.*?)\[/flash\]~\[media\]$1\[/media\]~isg;	

	sub format_url {
		my ($txtfirst, $txturl) = @_;
		my $lasttxt = "";
		if ($txturl =~ m~(.*?)(\.|\.\)|\)\.|\!|\!\)|\)\!|\,|\)\,|\)|\;|\&quot\;|\&quot\;\.|\.\&quot\;|\&quot\;\,|\,\&quot\;|\&quot\;\;|\<\/)\Z~) {
			$txturl = $1;
			$lasttxt = $2;
		}
		my $realurl = $txturl;
                $txturl =~ s~(\[shighlight\]|\[\/shighlight\]|\[highlight\]|\[\/highlight\]|\[edit\]|\[\/edit\])~~ig;
		$txturl =~ s~\[~&#91;~g;
		$txturl =~ s~\]~&#93;~g;
		$txturl =~ s~\<.+?\>~~ig;
		my $formaturl = qq~$txtfirst\[url\=$txturl\]$realurl\[\/url\]$lasttxt~;
		return $formaturl;
	}
	sub format_url2 {
		my ($txturl, $txtlink) = @_;
                $txturl =~ s~(\[shighlight\]|\[\/shighlight\]|\[highlight\]|\[\/highlight\]|\[edit\]|\[\/edit\])~~ig;
		$txturl =~ s~\<.+?\>~~ig;
		my $formaturl = qq~\[url\=$txturl\]$txtlink\[\/url\]~;
		return $formaturl;
	}
	sub format_url3 {
		my $txturl = $_[0];
		my $txtlink = $txturl;
                $txturl =~ s~(\[shighlight\]|\[\/shighlight\]|\[highlight\]|\[\/highlight\]|\[edit\]|\[\/edit\])~~ig;
		$txturl =~ s~\[~&#91;~g;
		$txturl =~ s~\]~&#93;~g;
		$txturl =~ s~\<.+?\>~~ig;
		my $formaturl = qq~\[url\=$txturl\]$txtlink\[\/url\]~;
		return $formaturl;
	}

	$threadpost =~ s~\[url=\s*(.+?)\s*\]\s*(.+?)\s*\[/url\]~&format_url2($1, $2)~eisg;
	$threadpost =~ s~\[url\]\s*(\S+?)\s*\[/url\]~&format_url3($1)~eisg;

	if ($autolinkurls) {
		$threadpost =~ s~\[url\]\s*([^\[]+)\s*\[/url\]~[url]$1\[/url]~g;
		$threadpost =~ s~\[link\]\s*([^\[]+)\s*\[/link\]~[link]$1\[/link]~g;
		$threadpost =~ s~\[news\](\S+?)\[/news\]~<a href="$1">$1</a>~isg;
		$threadpost =~ s~\[gopher\](\S+?)\[/gopher\]~<a href="$1">$1</a>~isg;
		$threadpost =~ s~&quot;&gt;~">~g; #"
		$threadpost =~ s~(\[\*\])~ $1~g;
		$threadpost =~ s~(\[\/list\])~ $1~g;
		$threadpost =~ s~(\[\/td\])~ $1~g;
		$threadpost =~ s~(\[\/td\])~ $1~g;
		$threadpost =~ s~\<span style\=~\<span_style\=~g;
		$threadpost =~ s~\<div style\=~\<div_style\=~g;
		$threadpost =~ s~([^\w\"\=\[\]]|[\n\b]|\&quot\;|\[quote.*?\]|\[edit\]|\[highlight\]|\[shighlight\]|\[\*\]|\[td\]|\A)\\*(\w+?\:\/\/(?:[\w\~\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\](?:\<\S+?\>\S+?\<\/\S+?\>)]+?)\.(?:[\w\~\.\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\]\x80-\xFF]{1,})+?)~&format_url($1,$2)~eisg;
		$threadpost =~ s~([^\"\=\[\]/\:\.(\://\w+)]|[\n\b]|\&quot\;|\[quote.*?\]|\[edit\]|\[highlight\]|\[shighlight\]|\[\*\]|\[td\]|\A|\()\\*(www\.[^\.](?:[\w\~\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\](?:\<\S+?\>\S+?\<\/\S+?\>)]+?)\.(?:[\w\~\.\;\:\,\$\-\+\!\*\?/\=\&\@\#\%\(\)\[\]\x80-\xFF]{1,})+?)~&format_url($1,$2)~eisg;
		$threadpost =~ s~\<span_style\=~\<span style\=~g;
		$threadpost =~ s~\<div_style\=~\<div style\=~g;
	}

	if ($stealthurl) {
		$threadpost =~ s~\[url=\s*(\w+\://.+?)\](.+?)\s*\[/url\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1" target="_blank">$2</a>~isg;
		$threadpost =~ s~\[url=\s*(.+?)\]\s*(.+?)\s*\[/url\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://$1" target="_blank">$2</a>~isg;
		$threadpost =~ s~\[link\]\s*www\.\s*(.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://www.$1">www.$1</a>~isg;
		$threadpost =~ s~\[link=\s*(\w+\://.+?)\](.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1">$2</a>~isg;
		$threadpost =~ s~\[link=\s*(.+?)\]\s*(.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=http://$1">$2</a>~isg;
		$threadpost =~ s~\[link\]\s*(.+?)\s*\[/link\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1">$1</a>~isg;
		$threadpost =~ s~\[ftp\]\s*(.+?)\s*\[/ftp\]~<a href="$boardurl/YaBB.$yyext?action=dereferer;url=$1" target="_blank">$1</a>~isg;
	} else {
		$threadpost =~ s~\[url=\s*(\S\w+\://\S+?)\s*\](.+?)\[/url\]~<a href="$1" target="_blank">$2</a>~isg;
		$threadpost =~ s~\[url=\s*(\S+?)\](.+?)\s*\[/url\]~<a href="http://$1" target="_blank">$2</a>~isg;
		$threadpost =~ s~\[link\]\s*www\.(\S+?)\s*\[/link\]~<a href="http://www.$1">www.$1</a>~isg;
		$threadpost =~ s~\[link=\s*(\S\w+\://\S+?)\s*\](.+?)\[/link\]~<a href="$1">$2</a>~isg;
		$threadpost =~ s~\[link=\s*(\S+?)\](.+?)\s*\[/link\]~<a href="http://$1">$2</a>~isg;
		$threadpost =~ s~\[link\]\s*(\S+?)\s*\[/link\]~<a href="$1">$1</a>~isg;
		$threadpost =~ s~\[ftp\]\s*(ftp://)?(.+?)\s*\[/ftp\]~<a href="ftp://$2">$1$2</a>~isg;
	}

	$threadpost =~ s~(dereferer\;url\=http\:\/\/.*?)#(\S+?\")~$1;anch=$2~isg;

 	if ($guest_media_disallowed && $iamguest) {
		$threadpost =~ s~\<a href\=\"(.+?)</a>~[yyoops]~g;
		$threadpost =~ s~\<img src\=\"(.+?)/>~[yyoops]~g;
		$threadpost =~ s~\[media\](.*?)\[/media\]~[yyoops]~isg;	
		$threadpost =~ s~\[yyoops\]~$oops~g;
	}

	$threadpost =~ s~\[media\](.*?)\[/media\]~$1~isg;

	$threadpost =~ s~\[email\]\s*(\S+?\@\S+?)\s*\[/email\]~$1~isg;
	$threadpost =~ s~\[email=\s*(\S+?\@\S+?)\]\s*(.*?)\s*\[/email\]~$2 ($1)~isg;

	$threadpost =~ s~\[news\](.+?)\[/news\]~$1~isg;
	$threadpost =~ s~\[gopher\](.+?)\[/gopher\]~$1~isg;
	$threadpost =~ s~\[ftp\](.+?)\[/ftp\]~$1~isg;

	$threadpost =~ s~\[quote\s+author=(.*?)link=(.*?)\s+date=(.*?)\s*\]\n*(.*?)\n*\[/quote\]~<br /><i>$1 wrote</a>:</i><table cellspacing="1" width="90%"><tr><td width="100%"><table cellpadding="2" cellspacing="0" width="100%"><tr><td width="100%"><font size="1">$4</font></td></tr></table></td></tr></table>~isg;
	$threadpost =~ s~\[quote\]\n*(.+?)\n*\[/quote\]~<br /><i>Quote:</i><table cellspacing="1" width="90%"><tr><td width="100%"><table cellpadding="2" cellspacing="0" width="100%"><tr><td width="100%"><font face="Arial,Helvetica" size="1">$1</font></td></tr></table></td></tr></table>~isg;

	$threadpost =~ s~\[list\]~<ul>~isg;
	$threadpost =~ s~\[\*\]~<li>~isg;
	$threadpost =~ s~\[/list\]~</ul>~isg;

	$threadpost =~ s~\[pre\](.+?)\[/pre\]~'<pre>' . dopre($1) . '</pre>'~iseg;

	$threadpost =~ s~\[flash=(\S+?),(\S+?)\](\S+?)\[/flash\]~$3~isg;

	$threadpost =~ s~\{\{~\[~g;
	$threadpost =~ s~\}\}~\]~g;

	if ($threadpost =~ m~\[table\]~i) {
		$threadpost =~ s~\n{0,1}\[table\]\n*(.+?)\n*\[/table\]\n{0,1}~<table>$1</table>~isg;
		while ($threadpost =~ s~\<table\>(.*?)\n*\[tr\]\n*(.*?)\n*\[/tr\]\n*(.*?)\</table\>~<table>$1<tr>$2</tr>$3</table>~is) { }
		while ($threadpost =~ s~\<tr\>(.*?)\n*\[td\]\n{0,1}(.*?)\n{0,1}\[/td\]\n*(.*?)\</tr\>~<tr>$1<td>$2</td>$3</tr>~is)     { }
	}

	$threadpost =~ s~\[\&table(.*?)\]~<table$1>~g;
	$threadpost =~ s~\[/\&table\]~</table>~g;
	$threadpost =~ s~\n~<br />~ig;

	### Censor it ###
	$threadtitle = &Censor($threadtitle);
	$threadpost  = &Censor($threadpost);
	
	&ToChars($threadtitle);
	&ToChars($threadpost);

	$threaddate = timeformat($threaddate, 1);
}

1;
