###############################################################################
# Notify.pl                                                                   #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$notifyplver = 'YaBB 2.2.1 $Revision: 1.17.2.4 $';
if ($action eq 'detailedversion') { return 1; }

&LoadLanguage('Notify');

sub ManageBoardNotify {
	my $todo     = $_[0];
	my $theboard = $_[1];
	my $user     = $_[2];
	my $userlang = $_[3];
	my $notetype = $_[4];
	my $noteview = $_[5];
	if ($todo eq "load" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		## open board mail file and build hash name / detail
		if (-e "$boardsdir/$theboard.mail") {
			fopen(BOARDNOTE, "$boardsdir/$theboard.mail");
			%theboard = map /(.*)\t(.*)/, <BOARDNOTE>;
			fclose(BOARDNOTE);
		}
	}
	if ($todo eq "add") {
		$theboard{$user} = "$userlang|$notetype|$noteview";
	}
	if ($todo eq "update") {
		if (exists $theboard{$user}) {
			my ($memlang, $memtype, $memview) = split(/\|/, $theboard{$user});
			if ($userlang) { $memlang = qq~$userlang~; }
			if ($notetype) { $memtype = qq~$notetype~; }
			if ($noteview) { $memview = $noteview; }
			$theboard{$user} = "$memlang|$memtype|$memview";
		}
	}
	if ($todo eq "delete") {
		if ($user =~ /,/)	{	# been sent a list to kill, not a single
			my @oldusers = split(',', $user);
			foreach my $user (@oldusers)	{
				if (exists $theboard{$user}) {
					delete($theboard{$user});
				}
			}
		}	
		else	{	
		if (exists $theboard{$user}) {
			delete($theboard{$user});
			}
		}
	}
	if ($todo eq "save" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		fopen(BOARDNOTE, ">$boardsdir/$theboard.mail");
		print BOARDNOTE map "$_\t$theboard{$_}\n", sort { $theboard{$a} cmp $theboard{$b} } keys %theboard;
		fclose(BOARDNOTE);
		undef %theboard;
		if (!-s "$boardsdir/$theboard.mail") { unlink("$boardsdir/$theboard.mail"); }
	}
}

sub BoardNotify {
	if (!$currentboard) { &fatal_error("no_access"); }
	if ($iamguest)      { &fatal_error("members_only"); }
	my ($curuser, $curlang, $notifytype);
	$selected1 = "";
	$selected2 = "";
	$deloption = "";
	my ($boardname, undef) = split(/\|/, $board{"$currentboard"}, 2);
	&ToChars($boardname);
	&ManageBoardNotify("load", $currentboard);
	$yymain .= qq~
	<form action="$scripturl?action=boardnotify3;board=$currentboard" method="post">
	<table border="0" width="600" cellspacing="1" cellpadding="4" align="center" class="bordercolor">
		<tr>
		<td colspan="2" align="left" class="titlebg">
		<img src="$imagesdir/notify.gif" alt="" /> <span class="text1"><b>$notify_txt{'136'} - $boardname</b></span>
		</td>
		</tr><tr>
		<td class="windowbg" width="70%" align="left" valign="middle"><br />
	~;

	if (exists $theboard{$username}) {
		($memlang, $memtype, $memview) = split(/\|/, $theboard{$username});
		${ selected . $memtype } = qq~ selected="selected"~;
		$deloption = qq~<option value="3">$notify_txt{'134'}</option>~;
		$yymain .= qq~$notify_txt{'137'} &nbsp;~;
	} else {
		$yymain .= qq~$notify_txt{'126'} &nbsp;~;
	}
	$yymain .= qq~
		<br /><br />
		</td><td class="windowbg" width="30%" align="center" valign="middle">
		<select name="$currentboard">
		<option value="1"$selected1>$notify_txt{'132'}</option>
		<option value="2"$selected2>$notify_txt{'133'}</option>
		$deloption
		</select>
		</td></tr>
		<tr>
		<td colspan="2" class="catbg" align="center">
		<input type="submit" value="$notify_txt{'124'}" class="button" />
		</td>
		</tr>
	</table>
	</form>
	~;
	undef %theboard;
	$yytitle = "$notify_txt{'125'}";
	&template;
	exit;
}

sub BoardNotify2 {
	if ($iamguest) { &fatal_error("members_only"); }
	foreach $variable (keys %FORM) {
		if ($variable eq 'formsession') { next; }
		$notify_type = $FORM{"$variable"};
		if ($notify_type == 1 || $notify_type == 2) {
			&ManageBoardNotify("add", $variable, $username, ${$uid.$username}{'language'}, $notify_type, "1");
		} elsif ($notify_type == 3) {
			&ManageBoardNotify("delete", $variable, $username);
		}
	}
	if ($action eq "boardnotify3") {
		$yySetLocation = qq~$scripturl?board=$INFO{'board'}~;
	} else {
		$yySetLocation = qq~$scripturl?action=shownotify~;
	}
	&redirectexit;
}

sub ManageThreadNotify {
	my $todo      = $_[0];
	my $thethread = $_[1];
	my $user      = $_[2];
	my $userlang  = $_[3];
	my $notetype  = $_[4];
	my $noteview  = $_[5];

	if ($todo eq "load" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		##  open mail file and build hash 
		if (-e "$datadir/$thethread.mail") {
			fopen(THREADNOTE, "$datadir/$thethread.mail");
			%thethread = map /(.*)\t(.*)/, <THREADNOTE>;
			fclose(THREADNOTE);
		}
	}
	if ($todo eq "add") {
		$thethread{$user} = "$userlang|$notetype|$noteview";
	}
	if ($todo eq "update") {
		if (exists $thethread{$user}) {
			($memlang, $memtype, $memview) = split(/\|/, $thethread{$user});
			if ($userlang) { $memlang = qq~$userlang~; }
			if ($notetype) { $memtype = qq~$notetype~; }
			if ($noteview) { $memview = $noteview; }
			$thethread{$user} = "$memlang|$memtype|$memview";
		}
	}
	if ($todo eq "delete") {
		if ($user =~ /,/)	{	# been sent a list to kill, not a single
			my @oldusers = split(',', $user);
			foreach my $user (@oldusers)	{
				if (exists $thethread{$user}) {
					delete($thethread{$user});
				}
			}
		}
		else	{
			if (exists $thethread{$user}) {
				delete($thethread{$user});
			}
		}
	}
	if ($todo eq "save" || $todo eq "update" || $todo eq "delete" || $todo eq "add") {
		fopen(THREADNOTE, ">$datadir/$thethread.mail");
		print THREADNOTE map "$_\t$thethread{$_}\n", sort { $thethread{$a} cmp $thethread{$b} } keys %thethread;
		fclose(THREADNOTE);
		undef %thethread;
		if (!-s "$datadir/$thethread.mail") { unlink("$datadir/$thethread.mail"); }
	}
}

sub Notify {
	if ($iamguest) { &fatal_error("members_only"); }
	my ($thread, $line, $start, $curuser, $curlang);
	if ($INFO{'thread'} =~ m~/~) {
		($thread, $start) = split('/', $INFO{'thread'});
	} else {
		$thread = $INFO{'thread'};
		$start  = $INFO{'start'};
	}
	&ManageThreadNotify("load", "$thread");
	$yymain .= qq~
	<table border="0" width="600" cellspacing="1" cellpadding="4" align="center" class="bordercolor">
		<tr>
		<td align="left" class="titlebg">
		<img src="$imagesdir/notify.gif" alt="" /> <span class="text1"><b>$notify_txt{'118'}</b></span>
		</td>
		</tr><tr>
		<td class="windowbg" align="center"><br />
	~;
	if (exists $thethread{$username}) {
		$yymain .= qq~$notify_txt{'117'}<br /><br /><b><a href="$scripturl?action=notify3;thread=$thread/$start" style="font-weight: bold;">$notify_txt{'115'}</a> - <a href="$scripturl?num=$thread/$start" style="font-weight: bold;">$notify_txt{'116'}</a></b>~;
	} else {
		$yymain .= qq~$maintxt{'126'}<br /><br /><b><a href="$scripturl?action=notify2;thread=$thread/$start" style="font-weight: bold;">$notify_txt{'115'}</a> - <a href="$scripturl?num=$thread/$start" style="font-weight: bold;">$notify_txt{'116'}</a></b>~;
	}
	$yymain .= qq~
		</td>
		</tr>
	</table>
	~;
	undef %thethread;
	$yytitle = "$notify_txt{'125'}";
	&template;
	exit;
}

sub Notify2 {
	if ($iamguest) { &fatal_error("members_only"); }
	my ($thread, $start);
	if ($INFO{'thread'} =~ m~/~) {
		($thread, $start) = split('/', $INFO{'thread'});
	} else {
		$thread = $INFO{'thread'};
		$start  = $INFO{'start'};
	}
	&ManageThreadNotify("add", $thread, $username, ${$uid.$username}{'language'}, "1", "1");
	$yySetLocation = qq~$scripturl?num=$thread/$start~;
	&redirectexit;
}

sub Notify3 {
	if ($iamguest) { &fatal_error("members_only"); }
	my ($thread, $start);
	if ($INFO{'thread'} =~ m~/~) {
		($thread, $start) = split('/', $INFO{'thread'});
	} else {
		$thread = $INFO{'thread'};
		$start  = $INFO{'start'};
	}
	if (-e "$datadir/$thread.mail") {
		&ManageThreadNotify("delete", $thread, $username);
	}
	$yySetLocation = qq~$scripturl?num=$thread/$start~;
	&redirectexit;
}

sub Notify4 {
	if ($iamguest) { &fatal_error("members_only"); }
	my ($variable, $notype, $threadno);
	foreach $variable (keys %FORM) {
		($notype, $threadno) = split(/-/, $variable);
		if ($notype eq "thread") {
			&ManageThreadNotify("delete", $threadno, $username);
		}
	}
	&ShowNotifications;
}

sub updateLanguage {
	my $user    = $_[0];
	my $newlang = $_[1];
	my ($threadfile, $boardfile);
	foreach $boardfile (@bmaildir) {
		($myboard, undef) = split(/\./, $boardfile);
		&ManageBoardNotify("update", $myboard, $user, $newlang, "", "");
	}
	foreach $threadfile (@tmaildir) {
		($mythread, undef) = split(/\./, $threadfile);
		&ManageThreadNotify("update", $mythread, $user, $newlang, "", "");
	}
}

sub removeNotifications {
	my $user = $_[0];
	my ($boardfile, $threadfile);
	foreach $boardfile (@bmaildir) {
		($myboard, undef) = split(/\./, $boardfile);
		&ManageBoardNotify("delete", $myboard, $user);
	}
	foreach $threadfile (@tmaildir) {
		($mythread, undef) = split(/\./, $threadfile);
		&ManageThreadNotify("delete", $mythread, $user);
	}
}


sub ShowNotifications {
	## bye bye guest....
	if ($iamguest) { &fatal_error("members_only"); }
	my ($boardfile, $myboard);
	
	$yynavigation = qq~&rsaquo; <a href="$scripturl?action=mycenter" class="nav">$img_txt{'mycenter'}</a> &rsaquo; $img_txt{'418'}~;

	# Show Javascript for 'check all' notifications
	$showNotifications .= qq~
<script language="JavaScript1.2" type="text/javascript">
	<!-- Begin
		function checkAll(j) {
			for (var i = 0; i < document.threadnotify.elements.length; i++) {
				if (j == 0 ) {document.threadnotify.elements[i].checked = true;}
			}
		}
		function uncheckAll(j) {
			for (var i = 0; i < document.threadnotify.elements.length; i++) {
				if (j == 0 ) {document.threadnotify.elements[i].checked = false;}
			}
		}
	//-->
</script>
	~;
	## pull list of board and post .mail files
	&getMailFiles;

	$boardnum = 0;

	# Display Board notifications
	$showNotifications .= qq~
	<form action="$scripturl?action=boardnotify2" method="post" name="boardnotify">
	<table border="0" width="100%" align="center" cellspacing="1" cellpadding="4" class="bordercolor">
		<tr><td colspan="2" align="left" class="titlebg">
		<img src="$imagesdir/notify.gif" alt="" /> <span class="text1"><b>$notify_txt{'136'}</b></span>
		</td></tr>
	~;
	## run through boards list
	foreach $boardfile (@bmaildir) {
		## board name from file name
		($myboard, undef) = split(/\./, $boardfile);
		## load in hash of name / detail for board 
		&ManageBoardNotify("load", "$myboard");
		if (exists $theboard{$username}) {
			$boardnum++;
			## split down detail
			($curlang, $boardnotifytype, $hasviewed) = split(/\|/, $theboard{$username});
			## grab board name
			my ($boardname, undef) = split(/\|/, $board{"$myboard"}, 2);
			&ToChars($boardname);
			my ($selected1, $selected2) = "";
			if ($boardnotifytype eq "1") { # new topics
				$selected1 = qq~ selected="selected"~;
			} else { # all new posts
				$selected2 = qq~ selected="selected"~;
			}
			## output notify detail - option 3 = remove notify
			$boardblock .= qq~
			<tr><td align="left" width="65%" class="windowbg2">
			<a href="$scripturl?board=$myboard">$boardname</a>
			</td><td align="center" width="35%" class="windowbg2">
			<select name="$myboard">
				<option value="1"$selected1>$notify_txt{'132'}</option>
				<option value="2"$selected2>$notify_txt{'133'}</option>
				<option value="3">$notify_txt{'134'}</option>
			</select>
			</td></tr>
			~;
		}
		undef %theboard;
	}
	if (!$boardnum) { # no board notifies up
		$showNotifications .= qq~
		<tr><td colspan="2" align="left" class="windowbg2">
		<br />
		$notify_txt{'139'}<br /><br />
		</td></tr>
		~;
	} else { # list boards
		$showNotifications .= qq~
		<tr><td align="left" class="catbg">
		<b>$notify_txt{'135'}</b>
		</td><td align="center" class="catbg">
		<b>$notify_txt{'138'}</b>
		</td></tr>
		$boardblock
		<tr><td colspan="2" align="center" class="windowbg">
		<input type="submit" value="$notify_txt{'124'}" class="button" />&nbsp; <input type="reset" value="$notify_txt{'121'}" class="button" />
		</td></tr>
		~;
	}
	## finish off
	$showNotifications .= qq~
	</table>
	</form>
	<br /><br />
	~;
	&LoadCensorList;
	$threadnum = 0;

	$showNotifications .= qq~
	<form action="$scripturl?action=notify4" method="post" name="threadnotify">
	<table border="0" width="100%" align="center" cellspacing="1" cellpadding="4" class="bordercolor">
	<tr><td align="left" colspan="2" class="titlebg">
		<img src="$imagesdir/notify.gif" alt="" /> <span class="text1"><b>$notify_txt{'118'}</b></span>
	</td></tr>
	~;
	##  load board names
	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
	
	foreach $threadfile (@tmaildir) { # threads next
		my ($mythread, undef) = split(/\./, $threadfile);
		## load threads hash
		&ManageThreadNotify("load", "$mythread");
		if (exists $thethread{$username}) {
			$threadnum++;
			## split detail 
			my ($curlang, $isboardnotify, $hasviewed) = split(/\|/, $thethread{$username});
			## load thread file 
			fopen(FILE, "$datadir/$mythread.txt");
			my @messages = <FILE>;
			fclose(FILE);
			## split down
			my ($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mmessage) = split(/\|/, $messages[0]);
			&ToChars($msub);
			$msub =~ s/\[m.*?\]/$maintxt{'758'}/;
			## censor text !
			$msub = &Censor($msub);
			## load poster
			&LoadUser($musername);
			##  load ctb file for board data
			&MessageTotals ("load",$mythread);
			## pull out board and last post
			my $boardid = ${$mythread}{'board'};
			my $lastpostdate = ${$mythread}{'lastpostdate'};
			## format last post for output
			$lastpostdate = &timeformat($lastpostdate);
			## grab boardname from list
			## vars declared here so not hidden in nesting!
			my $boardlist = $board{$boardid};
			my ($boardname, undef, undef) = split(/\|/, $boardlist); 
			my $catname = "";
			my ($thiscatid,$catid) = "";
			## run through the categories until we hit the match for category name
			checkboardname: foreach my $catid (@categoryorder) {
				my $CatToCheck = $cat{$catid};
				my(@boardToCheck) = split(/\,/, $CatToCheck);
				foreach my $boardnames (@boardToCheck)	{
					if($boardnames eq $boardid)	{ ## found the match. grab data and jump out
						($catname,undef,undef) = split(/\|/, $catinfo{$catid});
						## extract current category, so we can link back in the page
						$thiscatid = $catid;
						last checkboardname;
					}
				}
			}
			my $catname_link = qq~<a href="$scripturl?catselect=$thiscatid">$catname</a>~;
			my $boardname_link = qq~<a href="$scripturl?board=$boardid">$boardname</a>~;
			## build view profile link, if real name exists
			if (${$uid.$musername}{'realname'}) {
				$username_link = qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$musername}">${$uid.$musername}{'realname'}</a>~;
			} elsif ($mname) {
				$username_link = $mname;
			} else {
				$username_link = $musername;
			}
			## build block for display
			$threadblock .= qq~
			<tr><td align="left" width="85%" class="windowbg2">
				<b><a href="$scripturl?num=$mythread">$msub</a></b> $notify_txt{'120'} $username_link
				<br /><span class="small">$catname_link &raquo; $boardname_link - $notify_txt{'lastpost'} $lastpostdate</span>
			</td><td align="center" width="15%" class="windowbg2">
				<input type="checkbox" name="thread-$mythread" value="1" />
			</td></tr>
			~;
		}
	}
	if (!$threadnum) { ## no threads listed
		$showNotifications .= qq~
		<tr><td colspan="2" align="left" class="windowbg2">
		<br />
		$notify_txt{'119'}<br /><br />
		</td></tr>
		~;
	} else { ## output details
		$showNotifications .= qq~
		<tr><td align="left" class="catbg">
		<b>$notify_txt{'140'}</b>
		</td><td align="center" class="catbg">
		<b>$notify_txt{'134'}</b>
		</td></tr>
		$threadblock
		<tr><td align="right" width="85%" class="catbg"><span class="small">$notify_txt{'144'}</span></td>
		<td align="center" width="15%" class="catbg"><input type="checkbox" name="checkall" value="" onclick="if (this.checked) checkAll(0); else uncheckAll(0);" /></td>
		<tr><td colspan="2" align="center" class="windowbg">
		<input type="submit" value="$notify_txt{'124'}" class="button" />&nbsp; <input type="reset" value="$notify_txt{'121'}" class="button" />
		</td></tr>
		~;
	}
	$showNotifications .= qq~
	</table>
	</form>
	~;
	## and finally, add jump menu for a route back.
	if(!$view)	{&jumpto;
		$yymain .= qq~$showNotifications$selecthtml~;
	}
	$yytitle = "$notify_txt{'124'}";
	if(!$view)	{&template;	exit;}
}

1;
