###############################################################################
# BoardIndex.pl                                                               #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$boardindexplver = 'YaBB 2.2.1 $Revision: 1.39.2.7 $';
if ($action eq 'detailedversion') { return 1; }

&LoadLanguage('BoardIndex');
require "$templatesdir/$useboard/BoardIndex.template";

sub Del_Max_IM {
	fopen(DELMAXIM, "$memberdir/$username.msg");
	@messages = <DELMAXIM>;
	fclose(DELMAXIM);

	fopen(DELMAXIM, ">$memberdir/$username.msg", 1);
	for ($a = 0; $a < @messages; $a++) {
		chomp $messages[$a];
		if ($a < $numibox) { print DELMAXIM "$messages[$a]\n"; }
	}
	fclose(DELMAXIM);
}

sub Del_Max_IMOUT {
	fopen(DELMAXIMOUT, "$memberdir/$username.outbox");
	@omessages = <DELMAXIMOUT>;
	fclose(DELMAXIMOUT);

	fopen(DELMAXIMOUT, ">$memberdir/$username.outbox", 1);
	for ($a = 0; $a < @omessages; $a++) {
		chomp $omessages[$a];
		if ($a < $numobox) { print DELMAXIMOUT "$omessages[$a]\n"; }
	}
	fclose(DELMAXIMOUT);
}

sub Del_Max_STORE {
	fopen(DELMAXIMSTORE, "$memberdir/$username.imstore");
	@smessages = <DELMAXIMSTORE>;
	fclose(DELMAXIMSTORE);

	fopen(DELMAXIMSTORE, ">$memberdir/$username.imstore", 1);
	for ($a = 0; $a < @smessages; $a++) {
		chomp $smessages[$a];
		if ($a < $numstore) { print DELMAXIMSTORE "$smessages[$a]\n"; }
	}
	fclose(DELMAXIMSTORE);
}

sub BoardIndex {
	my ($lspostid, $lspostbd, $lssub, $lsposttime, $lsposter, $lsreply, $lsdatetime, $lastthreadtime, @goodboards, @loadboards);
	my ($memcount, $latestmember) = &MembershipGet;
	chomp $latestmember;
	$totalm = 0;
	$totalt = 0;
	$lastposttime   = 0;
	$lastthreadtime = 0;
	&LoadBots;

	my $checkadded = 0;
	$users = qq~<span class="small">~;
	if (($iamadmin && $show_online_ip_admin) || ($iamgmod && $show_online_ip_gmod)) {$guestlist = qq~<span class="small">~;}
	$guests = 0;
	$numusers = 0;
	$numbots = 0;
	fopen(VARLOG, "$vardir/log.txt");
	@entries = <VARLOG>;
	fclose(VARLOG);
	foreach $curentry (@entries) {
		chomp $curentry;
		($name, $value, $last_ip, $last_host) = split(/\|/, $curentry);
		if (!$last_ip) { $last_ip = qq~</i></span><span class="error">$boardindex_txt{'no_ip'}</span><span class="small"><i>~; }
		my $is_a_bot = &Is_Bot($last_host);
		if ($is_a_bot){
			$numbots++;
			$bot_count{$is_a_bot}++;
		}
		elsif ($name) {
			if (-e ("$memberdir/$name.vars")) {
				unless (${$uid.$name}{'realname'}) { &LoadUser($name); }
				if (${$uid.$name}{'stealth'} ne 'checked') {
					&LoadMiniUser($name);
					$numusers++;
					$users .= $link{$name};
					if (($iamadmin && $show_online_ip_admin) || ($iamgmod && $show_online_ip_gmod)) {
						$users .= qq~<i> ($last_ip)</i>~;
					}
					$users .= qq~, ~;
				} elsif (${$uid.$name}{'stealth'} eq 'checked' && ($iamadmin || $iamgmod)) {
					&LoadMiniUser($name);
					$numusers++;
					$users .= qq~$link{$name}*~;
					if (($iamadmin && $show_online_ip_admin) || ($iamgmod && $show_online_ip_gmod)) {
						$users .= qq~<i> ($last_ip)</i>~;
					}
					$users .= qq~, ~;
				}
			} else {
				$guests++;
				if (($iamadmin && $show_online_ip_admin) || ($iamgmod && $show_online_ip_gmod)) {
					$guestlist .= qq~<i>$last_ip</i>, ~;
				}
			}
		}
	}
	$users =~ s~, \Z~~;
	$users .= qq~</span>~;
	if ($numusers) { $users .= qq~<br />~; }
	if ((($iamadmin && $show_online_ip_admin) || ($iamgmod && $show_online_ip_gmod)) && $guests >= 1)	{
		$guestlist =~ s~, \Z~~;
		$guestlist .= qq~</span>~;
	}
	elsif((($iamadmin && $show_online_ip_admin) || ($iamgmod && $show_online_ip_gmod)) && $guests == 0)	{
		$guestlist = qq~~;
	}
	if ($guestlist ne '') {$guestlist .= qq~<br />~;}
	## let's build the bot list now ##
	if($numbots > 0) {
		$botlist = qq~<span class="small">~;
		foreach (keys(%bot_count)){
			chomp $_;
			$botlist .= qq~$bot_name{$_} ($bot_count{$_}), ~;
		}
		$botlist =~ s~, \Z~~;
		$botlist .= qq~</span>~;
	}
	if (!$INFO{'catselect'}) {
		$yytitle = $boardindex_txt{'18'};
	} else {
		($tmpcat, $tmpmod, $tmpcol) = split(/\|/, $catinfo{ $INFO{'catselect'} });
		&ToChars($tmpcat);
		$yytitle = qq~$tmpcat~;
		$yynavigation = qq~&rsaquo; $tmpcat~;
	}

	if (!$iamguest) { &Collapse_Load; }

	# first get all the boards based on the categories found in forum.master
	foreach $catid (@categoryorder) {
		if ($INFO{'catselect'} ne $catid && $INFO{'catselect'}) { next; }
		$boardlist = $cat{$catid};
		(@bdlist) = split(/\,/, $boardlist);
		my ($catname, $catperms, $catallowcol) = split(/\|/, $catinfo{"$catid"});

		# Category Permissions Check
		my $access = &CatAccess($catperms);
		if (!$access) { next; }
		$cat_boardcnt{$catid} = 0;

		# next determine all the boards a user has access to
		foreach $curboard (@bdlist) {
			# now fill all the neccesary hashes to show all board index stuff
			chomp $curboard;
			if (!exists $board{$curboard}) {
				&gostRemove($catid, $curboard);
				next;
			}
			# hide the actual global announcement board for all normal users but admins and gmods
			if ($annboard eq $curboard && !$iamadmin && !$iamgmod) { next; }
			my ($boardname, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});
			my $access = &AccessCheck($curboard, '', $boardperms);
			if (!$iamadmin && $access ne "granted" && $boardview != 1) { next; }
			push(@goodboards, "$catid|$curboard");
			push(@loadboards, $curboard);
			$cat_boardcnt{$catid}++;
		}
	}
	&BoardTotals("load", @loadboards);
	&getlog(@goodboards);
	foreach $curboard (@loadboards) {
		chomp $curboard;
		$lastposttime = ${$uid.$curboard}{'lastposttime'};
		${$uid.$curboard}{'lastposttime'} = ${$uid.$curboard}{'lastposttime'} eq 'N/A' || !${$uid.$curboard}{'lastposttime'} ? $boardindex_txt{'470'} : ${$uid.$curboard}{'lastposttime'};
		if (${$uid.$curboard}{'lastposttime'} != 0) { $lastposttime{$curboard} = &timeformat(${$uid.$curboard}{'lastposttime'}); }
		else { $lastposttime{$curboard} = $boardindex_txt{'470'}; }
		$lastpostrealtime{$curboard} = ${$uid.$curboard}{'lastposttime'} eq 'N/A' || !${$uid.$curboard}{'lastposttime'} ? '' : ${$uid.$curboard}{'lastposttime'};
		$lsreply{$curboard} = ${$uid.$curboard}{'lastreply'} + 1;
		if (${$uid.$curboard}{'lastposter'} =~ m~\AGuest-(.*)~) {
			${$uid.$curboard}{'lastposter'} = $1 . " ($maintxt{'28'})";
			$lastposterguest{$curboard} = 1;
		}
		${$uid.$curboard}{'lastposter'} = ${$uid.$curboard}{'lastposter'} eq 'N/A' || !${$uid.$curboard}{'lastposter'} ? $boardindex_txt{'470'} : ${$uid.$curboard}{'lastposter'};
		${$uid.$curboard}{'messagecount'} = ${$uid.$curboard}{'messagecount'} || 0;
		${$uid.$curboard}{'threadcount'} = ${$uid.$curboard}{'threadcount'} || 0;
		$totalm += ${$uid.$curboard}{'messagecount'};
		$totalt += ${$uid.$curboard}{'threadcount'};

		# hide hidden threads for ordinary members and guests
		my $iammodhere = '';
		my $bdmods = ${$uid.$curboard}{'mods'};
		$bdmods =~ s/\, /\,/g;
		$bdmods =~ s/\ /\,/g;
		foreach my $curuser (split(/\,/, $bdmods)) {
			if ($username eq $curuser) { $iammodhere = 1; }
		}
		my $bdmodgroups = ${$uid.$curboard}{'modgroups'};
		$bdmodgroups =~ s/\, /\,/g;
		foreach my $curgroup (split(/\,/, $bdmodgroups)) {
			if (${$uid.$username}{'position'} eq $curgroup) { $iammodhere = 1; }
			${$uid.$username}{'addgroups'} =~ s/\, /\,/g;
			foreach my $memberaddgroups (split(/\,/, ${$uid.$username}{'addgroups'})) {
				chomp $memberaddgroups;
				if ($memberaddgroups eq $curgroup) { $iammodhere = 1; last; }
			}
		}

		if (!$iammodhere && !$iamadmin && !$iamgmod && (${$uid.$curboard}{'lasttopicstate'} eq '' || ${$uid.$curboard}{'lasttopicstate'} =~ /h/i)) {
			fopen(MNUM, "$boardsdir/$curboard.txt");
			@threadlist = <MNUM>;
			fclose(MNUM);
			${$uid.$curboard}{'lastpostid'} = '';
			${$uid.$curboard}{'lastsubject'} = '';
			${$uid.$curboard}{'lastreply'} = '';
			${$uid.$curboard}{'lastposter'} = $boardindex_txt{'470'};
			${$uid.$curboard}{'lastposttime'} = '';
			$lastposttime{$curboard} = $boardindex_txt{'470'};
			for ($i = 0; $i < @threadlist; $i++) {
				($messageid, $messagesubject, undef, undef, undef, undef, undef, undef, $messagestate) = split(/\|/, $threadlist[$i]);
				if ($messagestate !~ /h/i) {
					&MessageTotals("load",$messageid);
					${$uid.$curboard}{'lastpostid'} = $messageid;
					${$uid.$curboard}{'lastsubject'} = $messagesubject;
					${$uid.$curboard}{'lastreply'} = ${$messageid}{'replies'};
					${$uid.$curboard}{'lastposter'} = ${$messageid}{'lastposter'};
					${$uid.$curboard}{'lastposttime'} = ${$messageid}{'lastpostdate'};
					$lastposttime{$curboard} = &timeformat(${$messageid}{'lastpostdate'});
					last;
				}
			}
		}
		# determine the true last post on all the boards a user has access to
		if (${$uid.$curboard}{'lastposttime'} > $lastthreadtime && $lastposttime{$curboard} ne $boardindex_txt{'470'}) {
			$lsdatetime = $lastposttime{$curboard};
			$lsposter = ${$uid.$curboard}{'lastposter'};
			$lssub = ${$uid.$curboard}{'lastsubject'};
			$lspostid = ${$uid.$curboard}{'lastpostid'};
			$lsreply = ${$uid.$curboard}{'lastreply'};
			$lastthreadtime = ${$uid.$curboard}{'lastposttime'};
			$lspostbd = $curboard;
		}

	}

	foreach $catid (@categoryorder) {
		if ($INFO{'catselect'} ne $catid && $INFO{'catselect'}) { next; }
		my ($catname, $catperms, $catallowcol) = split(/\|/, $catinfo{"$catid"});
		&ToChars($catname);

		$cataccess = &CatAccess($catperms);
		if (!$cataccess) { next; }

		# Skip any empty categories.
		if ($cat_boardcnt{$catid} == 0) { next; }

		if (!$iamguest) {

			my $newmsg = 0;
			$newms{$catname} = '';
			$newrowicon{$catname} = '';
			$newrowstart{$catname} = '';
			$newrowend{$catname} = '';
			$collapse_link = '';

			if ($catallowcol) {
				$collapse_link = qq~<a href="$scripturl?action=collapse_cat;cat=$catid">~;
			}

			# loop through any collapsed boards to find new posts in it and change the image to match
			if (!$catcol{$catid} && $INFO{'catselect'} eq '') {

				foreach my $boardinfo (@goodboards) {
					chomp $boardinfo;
					my ($testcat);
					($testcat, $curboard) = split(/\|/, $boardinfo);
					if ($testcat ne $catid) { next; }

					# as we fill the vars based on all boards we need to skip any cat already shown before
					my $dlp = $yyuserlog{$curboard} ? $yyuserlog{$curboard} : 0;
					if ($max_log_days_old && ${$uid.$curboard}{'lastposttime'} ne $boardindex_txt{'470'} && $dlp < $lastpostrealtime{$curboard} && ($dlp > $max_log_days_old * 86400 || $dlp == 0)) {
						my (undef, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});
						if (&AccessCheck($curboard, '', $boardperms) eq "granted") { $newmsg = 1; }
					}
				}
				$newrowstart{$catname} = qq~<tr><td colspan="5" class="$new_msg_bg" height="18"><span class="$new_msg_class">~;
				$newrowend{$catname}   = qq~</span></td></tr>~;
				if ($newmsg) {
					if ($catallowcol) {
						$hash{$catname} = qq~ <img src="$imagesdir/cat_expand.gif" alt="$boardindex_exptxt{'1'}" border="0" /></a>~;
						$newrowicon{$catname} = qq~<img src="$imagesdir/on.gif" alt="$boardindex_txt{'333'}" border="0" style="margin-left: 4px; margin-right: 6px; vertical-align: middle;" />~;
						$newms{$catname} = $boardindex_exptxt{'5'};
					}
				} else {
					if ($catallowcol) {
						$hash{$catname} = qq~ <img src="$imagesdir/cat_expand.gif" alt="$boardindex_exptxt{'1'}" border="0" /></a>~;
						$newrowicon{$catname} = qq~<img src="$imagesdir/off.gif" alt="$boardindex_txt{'334'}" border="0" style="margin-left: 4px; margin-right: 6px; vertical-align: middle;" />~;
						$newms{$catname} = $boardindex_exptxt{'6'};
					}
				}
			} else {
				if ($catallowcol) {
					if ($INFO{'catselect'} ne '') { $collapse_link = ''; $hash{$catname} = ''; }
					else { $hash{$catname} = qq~<img src="$imagesdir/cat_collapse.gif" alt="$boardindex_exptxt{'2'}" border="0" /></a>~; }
				}
			}
			$catlink = qq~$collapse_link $hash{$catname} <a href="$scripturl?catselect=$catid" title="$boardindex_txt{'797'} $catname">$catname</a>~;
		} else {
			$catlink = qq~<a href="$scripturl?catselect=$catid">$catname</a>~;
		}
		$templatecat = $catheader;
		$templatecat =~ s/({|<)yabb catlink(}|>)/$catlink/g;
		$templatecat =~ s/({|<)yabb newmsg start(}|>)/$newrowstart{$catname}/g;
		$templatecat =~ s/({|<)yabb newmsg icon(}|>)/$newrowicon{$catname}/g;
		$templatecat =~ s/({|<)yabb newmsg(}|>)/$newms{$catname}/g;
		$templatecat =~ s/({|<)yabb newmsg end(}|>)/$newrowend{$catname}/g;
		$tmptemplateblock .= $templatecat;

		## loop through any non collapsed boards to show the board index ##
		if ($catcol{$catid} || $INFO{'catselect'} ne '' || $iamguest) {
			foreach my $boardinfo (@goodboards) {
				chomp $boardinfo;
				my ($testcat);
				($testcat, $curboard) = split(/\|/, $boardinfo);
				if ($testcat ne $catid) { next; }
				# as we fill the vars based on all boards we need to skip any cat already shown before
				if (${$uid.$curboard}{'ann'} == 1) { ${$uid.$curboard}{'pic'} = 'ann.gif'; }
				if (${$uid.$curboard}{'rbin'} == 1) { ${$uid.$curboard}{'pic'} = 'recycle.gif'; }
				($boardname, $boardperms, $boardview) = split(/\|/, $board{$curboard});
				&ToChars($boardname);
				$INFO{'zeropost'} = 0;
				$zero = '';
				$bdpic = ${$uid.$curboard}{'pic'};
				$bddescr = ${$uid.$curboard}{'description'};
				&ToChars($bddescr);
				$iammod = '';
				my $bdmods = ${$uid.$curboard}{'mods'};
				$bdmods =~ s/\, /\,/g;
				$bdmods =~ s/\ /\,/g;
				%moderators = ();
				foreach my $curuser (split(/\,/, $bdmods)) {
					if ($username eq $curuser) { $iammod = 1; }
					&LoadUser($curuser);
					$moderators{$curuser} = ${$uid.$curuser}{'realname'};
				}
				$showmods = '';
				if (scalar keys %moderators == 1) { $showmods = qq~$boardindex_txt{'298'}: ~; }
				elsif (scalar keys %moderators != 0) { $showmods = qq~$boardindex_txt{'63'}: ~; }
				while ($tmpa = each(%moderators)) {
					&FormatUserName($tmpa);
					$showmods .= qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$tmpa}">$moderators{$tmpa}</a>, ~;
				}
				$showmods =~ s/, \Z//;

				&LoadUser($username);
				my $bdmodgroups = ${$uid.$curboard}{'modgroups'};
				$bdmodgroups =~ s/\, /\,/g;
				%moderatorgroups = ();
				foreach my $curgroup (split(/\,/, $bdmodgroups)) {
					if (${$uid.$username}{'position'} eq $curgroup) { $iammod = 1; }
					${$uid.$username}{'addgroups'} =~ s/\, /\,/g;
					foreach my $memberaddgroups (split(/\,/, ${$uid.$username}{'addgroups'})) {
						chomp $memberaddgroups;
						if ($memberaddgroups eq $curgroup) { $iammod = 1; last; }
					}
					($thismodgrp, undef) = split(/\|/, $NoPost{$curgroup}, 2);
					$moderatorgroups{$curgroup} = $thismodgrp;
				}

				$showmodgroups = '';
				if (scalar keys %moderatorgroups == 1) { $showmodgroups = qq~$boardindex_txt{'298a'}: ~; }
				elsif (scalar keys %moderatorgroups != 0) { $showmodgroups = qq~$boardindex_txt{'63a'}: ~; }
				while ($tmpa = each(%moderatorgroups)) {
					$showmodgroups .= qq~$moderatorgroups{$tmpa}, ~;
				}
				$showmodgroups =~ s/, \Z//;
				if ($showmodgroups eq "" && $showmods eq "") { $showmodgroups = qq~<br />~; }
				if ($showmodgroups ne "" && $showmods ne "") { $showmods .= qq~<br />~; }

				my $dlp = $yyuserlog{$curboard} ? $yyuserlog{$curboard} : 0;
				if ($iamguest) {
					$new = '';
				}
				elsif ($max_log_days_old && ${$uid.$curboard}{'lastposttime'} ne $boardindex_txt{'470'} && !$iamguest && $dlp < $lastpostrealtime{$curboard} && ($dlp > $max_log_days_old * 86400 || $dlp == 0)) {
					my (undef, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});
					if (&AccessCheck($curboard, '', $boardperms) eq "granted") {
						$new = qq~<img src="$imagesdir/on.gif" alt="$boardindex_txt{'333'}" border="0" style="vertical-align: middle;" />~;
					} else {
						$new = qq~<img src="$imagesdir/off.gif" alt="$boardindex_txt{'334'}" border="0" style="vertical-align: middle;" />~;
					}
				} else {
					$new = qq~<img src="$imagesdir/off.gif" alt="$boardindex_txt{'334'}" border="0" style="vertical-align: middle;" />~;
				}
				if (!$bdpic) { $bdpic = 'boards.gif'; }

				$lastposter = ${$uid.$curboard}{'lastposter'};
				$lastposter =~ s~\AGuest-(.*)~$1 ($maintxt{'28'})~i;

				unless ($lastposterguest{$curboard} || ${$uid.$curboard}{'lastposter'} eq $boardindex_txt{'470'}) {
					&LoadUser($lastposter);
					$registrationdate = ${$uid.$lastposter}{'regtime'};
					$messagedate = ${$uid.$curboard}{'lastposttime'};
					if ((${$uid.$lastposter}{'regdate'} && $messagedate > $registrationdate) || ${$uid.$lastposter}{'position'} eq "Administrator" || ${$uid.$lastposter}{'position'} eq "Global Moderator") {
						$lastposter = qq~<a href="$scripturl?action=viewprofile;username=$useraccount{$lastposter}">${$uid.$lastposter}{'realname'}</a>~;
					} else {
						$lastposter .= qq~ - $boardindex_txt{'470a'}~;
					}
				}
				${$uid.$curboard}{'lastposter'} ||= $boardindex_txt{'470'};
				${$uid.$curboard}{'lastposttime'} ||= $boardindex_txt{'470'};

				if ($bdpic =~ /\//i) { $bdpic = qq~ <img src="$bdpic" alt="$boardname" border="0" align="middle" /> ~; }
				elsif ($bdpic) { $bdpic = qq~ <img src="$imagesdir/$bdpic" alt="$boardname" border="0" /> ~; }

				my $templateblock = $boardblock;

				if (!$topiccut) { $topiccut = 15; }
				my $lasttopictxt = ${$uid.$curboard}{'lastsubject'};
				$lasttopictxt =~ s/\[m.*?\]/$maintxt{'758'}/;

				# Censor the subject
				&LoadCensorList;
				$lasttopictxt = &Censor($lasttopictxt);
				$fulltopictext = $lasttopictxt;

				$convertstr = $lasttopictxt;
				$convertcut = $topiccut;
				&CountChars;
				my $lasttopictxt = $convertstr;
				&ToChars($lasttopictxt);
				&ToChars($fulltopictext);

				if ($cliped) { $lasttopictxt .= "..."; }

				if (${$uid.$curboard}{'lastreply'} ne "") {
					$lastpostlink = qq~<a href="$scripturl?num=${$uid.$curboard}{'lastpostid'}/${$uid.$curboard}{'lastreply'}#${$uid.$curboard}{'lastreply'}">$img{'lastpost'}</a> $lastposttime{$curboard}~;
				} else {
					$lastpostlink = qq~$img{'lastpost'} $boardindex_txt{'470'}~;
				}

				my $boardanchor = $curboard;
				if($boardanchor =~ m~\A[^az]~i) {$boardanchor =~ s~(.*?)~b$1~;}
				my $lasttopiclink = qq~<a href="$scripturl?num=${$uid.$curboard}{'lastpostid'}/${$uid.$curboard}{'lastreply'}#${$uid.$curboard}{'lastreply'}" title="$fulltopictext">$lasttopictxt</a>~;
				if (${$uid.$curboard}{'threadcount'} < 0)  { ${$uid.$curboard}{'threadcount'}  = 0; }
				if (${$uid.$curboard}{'messagecount'} < 0) { ${$uid.$curboard}{'messagecount'} = 0; }
				$templateblock =~ s/({|<)yabb boardanchor(}|>)/$boardanchor/g;
				$templateblock =~ s/({|<)yabb boardurl(}|>)/$scripturl\?board\=$curboard/g;
				$templateblock =~ s/({|<)yabb new(}|>)/$new/g;
				$templateblock =~ s/({|<)yabb boardpic(}|>)/$bdpic/g;
				$templateblock =~ s/({|<)yabb boardname(}|>)/$boardname/g;
				$templateblock =~ s/({|<)yabb boarddesc(}|>)/$bddescr/g;
				$templateblock =~ s/({|<)yabb moderators(}|>)/$showmods$showmodgroups/g;
				$templateblock =~ s/({|<)yabb threadcount(}|>)/${$uid.$curboard}{'threadcount'}/g;
				$templateblock =~ s/({|<)yabb messagecount(}|>)/${$uid.$curboard}{'messagecount'}/g;
				$templateblock =~ s/({|<)yabb lastpostlink(}|>)/$lastpostlink/g;
				$templateblock =~ s/({|<)yabb lastposter(}|>)/$lastposter/g;
				$templateblock =~ s/({|<)yabb lasttopiclink(}|>)/$lasttopiclink/g;
				$tmptemplateblock .= $templateblock;
			}
		}
		$tmptemplateblock .= $catfooter;
		++$catcount;
	}

	if (!$iamguest) {
		if (${$uid.$username}{'im_imspop'} eq 'on') {
			$yymain .= qq~<script language="javascript" type="text/javascript"> function viewIM() { window.open("$scripturl?action=im"); } </script>~;
			$yymain .= qq~<script language="javascript" type="text/javascript"> function viewIMOUT() { window.open("$scripturl?action=imoutbox"); } </script>~;
			$yymain .= qq~<script language="javascript" type="text/javascript"> function viewIMSTORE() { window.open("$scripturl?action=imstorage"); } </script>~;
		} else {
			$yymain .= qq~<script language="javascript" type="text/javascript"> function viewIM() { location.href = ("$scripturl?action=im"); } </script>~;
			$yymain .= qq~<script language="javascript" type="text/javascript"> function viewIMOUT() { location.href = ("$scripturl?action=imoutbox"); } </script>~;
			$yymain .= qq~<script language="javascript" type="text/javascript"> function viewIMSTORE() { location.href = ("$scripturl?action=imstorage"); } </script>~;
		}
		my $imsweredeleted = 0;
		if (${$username}{'PMmnum'} > $numibox && $numibox && $enable_imlimit) {
			$yymain .= qq~<script language="javascript" type="text/javascript"> if (confirm('$boardindex_imtxt{'11'} ${$username}{'PMmnum'} $boardindex_imtxt{'12'} $boardindex_txt{'316'}, $boardindex_imtxt{'16'} $numibox $boardindex_imtxt{'18'} $boardindex_imtxt{'19'}')) { viewIM(); } else { cancel(); } </script>~;
			&Del_Max_IM;
			$imsweredeleted = 1;
			${$username}{'PMmnum'} = $numibox - 1;
		}
		if (${$username}{'PMmoutnum'} > $numobox && $numobox && $enable_imlimit) {
			$yymain .= qq~<script language="javascript" type="text/javascript"> if (confirm('$boardindex_imtxt{'11'} ${$username}{'PMmoutnum'} $boardindex_imtxt{'12'} $boardindex_txt{'320'}! $boardindex_imtxt{'16'} $numobox $boardindex_imtxt{'18'} $boardindex_imtxt{'19'}')) { viewIMOUT(); } else { cancel(); } </script>~;
			&Del_Max_IMOUT;
			$imsweredeleted = 1;
			${$username}{'PMmoutnum'} = $numobox - 1;
		}
		if (${$username}{'PMstorenum'} > $numstore && $numstore && $enable_imlimit) {
			$yymain .= qq~<script language="javascript" type="text/javascript"> if (confirm('$boardindex_imtxt{'11'} ${$username}{'PMstorenum'} $boardindex_imtxt{'12'} $boardindex_imtxt{'46'}! $boardindex_imtxt{'16'} $numstore $boardindex_imtxt{'18'} $boardindex_imtxt{'19'}')) { viewIMSTORE(); } else { cancel(); } </script>~;
			&Del_Max_STORE;
			$imsweredeleted = 1;
			${$username}{'PMstorenum'} = $numstore - 1;
		}
		if ($imsweredeleted) {
			unlink("$memberdir/$username.ims");
			&LoadIMs();
		}

		$ims = '';
		if ($PM_level == 1 || ($PM_level == 2 && ($iamadmin || $iamgmod || $iammod)) || ($PM_level == 3 && ($iamadmin || $iamgmod))){
			$ims = qq~$boardindex_txt{'795'} <a href="$scripturl?action=im"><b>${$username}{'PMmnum'}</b></a> $boardindex_txt{'796'}~;
			if (${$username}{'PMmnum'} > 0) {
				if (${$username}{'PMimnewcount'} == 1) {
					$ims .= qq~ $boardindex_imtxt{'24'} <a href="$scripturl?action=im"><b>${$username}{'PMimnewcount'}</b></a> $boardindex_imtxt{'25'}.~;
				} else {
					$ims .= qq~ $boardindex_imtxt{'24'} <a href="$scripturl?action=im"><b>${$username}{'PMimnewcount'}</b></a> $boardindex_imtxt{'26'}.~;
				}
			} else {
				$ims .= qq~.~;
			}
		}

		if ($INFO{'catselect'} eq '') {
			if ($colbutton) {
				$collapselink = qq~$menusep<a href="$scripturl?action=collapse_all;status=0">$img{'collapse'}</a>~;
			}
			if (${$uid.$username}{'cathide'}) {
				$expandlink = qq~$menusep<a href="$scripturl?action=collapse_all;status=1">$img{'expand'}</a>~;
			}
			$markalllink = qq~$menusep<a href="$scripturl?action=markallasread">$img{'markallread'}</a>~;

		} else {
			$markalllink  = qq~$menusep<a href="$scripturl?action=markallasread;cat=$INFO{'catselect'}">$img{'markallread'}</a>~;
			$collapselink = '';
			$expandlink   = '';
		}
	}

	if ($totalt < 0) { $totalt = 0; }
	if ($totalm < 0) { $totalm = 0; }

	$guestson = qq~<span class="small">$boardindex_txt{'141'}: <b>$guests</b></span>~;
	$userson = qq~<span class="small">$boardindex_txt{'142'}: <b>$numusers</b></span>~;
	$botson = qq~<span class="small">$boardindex_txt{'143'}: <b>$numbots</b></span>~;

	$totalusers = $numusers + $numbots + $guests;

	if (!-e ("$vardir/mostlog.txt")) {
		fopen(MOSTUSERS, ">$vardir/mostlog.txt");
		print MOSTUSERS "$numusers|$date\n";
		print MOSTUSERS "$guests|$date\n";
		print MOSTUSERS "$totalusers|$date\n";
		print MOSTUSERS "$numbots|$date\n";
		fclose(MOSTUSERS);
	}
	fopen(MOSTUSERS, "$vardir/mostlog.txt");
	@mostentries = <MOSTUSERS>;
	fclose(MOSTUSERS);
	($mostmemb, $datememb) = split(/\|/, $mostentries[0]);
	($mostguest, $dateguest) = split(/\|/, $mostentries[1]);
	($mostusers, $dateusers) = split(/\|/, $mostentries[2]);
	($mostbots, $datebots) = split(/\|/, $mostentries[3]);
	chomp ($datememb, $dateguest, $dateusers, $datebots);
	if ($numusers > $mostmemb || $guests > $mostguest || $numbots > $mostbots || $totalusers > $mostusers) {
		fopen(MOSTUSERS, ">$vardir/mostlog.txt");
		if ($numusers > $mostmemb) { $mostmemb = $numusers; $datememb = $date; }
		if ($guests > $mostguest) { $mostguest = $guests; $dateguest = $date; }
		if ($totalusers > $mostusers) { $mostusers = $totalusers; $dateusers = $date; }
		if ($numbots > $mostbots) { $mostbots  = $numbots; $datebots = $date; }
		print MOSTUSERS "$mostmemb|$datememb\n";
		print MOSTUSERS "$mostguest|$dateguest\n";
		print MOSTUSERS "$mostusers|$dateusers\n";
		print MOSTUSERS "$mostbots|$datebots\n";
		fclose(MOSTUSERS);
	}
	$themostmembdate = &timeformat($datememb);
	$themostguestdate = &timeformat($dateguest);
	$themostuserdate = &timeformat($dateusers);
	$themostbotsdate = &timeformat($datebots);

	my $shared_login;
	if ($iamguest) {
		require "$sourcedir/LogInOut.pl";
		$sharedLogin_title = '';
		$shared_login = &sharedLogin;
	}

	my %tmpcolors;
	$tmpcnt = 0;
	$grpcolors = '';
	($title, undef, undef, $color, $noshow) = split(/\|/, $Group{'Administrator'}, 5);
	if ($color && $noshow != 1) {
		$tmpcnt++;
		$tmpcolors{$tmpcnt} = qq~<div class="small" style="float: left; width: 49%;"><span style="color: $color;"><b>lllll</b></span> $title</div>~;
	}
	($title, undef, undef, $color, $noshow) = split(/\|/, $Group{'Global Moderator'}, 5);
	if ($color && $noshow != 1) {
		$tmpcnt++;
		$tmpcolors{$tmpcnt} = qq~<div class="small" style="float: left; width: 49%;"><span style="color: $color;"><b>lllll</b></span> $title</div>~;
	}
	foreach $nopostamount (@nopostorder) {
		chomp $nopostamount;
		($title, undef, undef, $color, $noshow) = split(/\|/, $NoPost{$nopostamount}, 5);
		if ($color && $noshow != 1) {
			$tmpcnt++;
			$tmpcolors{$tmpcnt} = qq~<div class="small" style="float: left; width: 49%;"><span style="color: $color;"><b>lllll</b></span> $title</div>~;
		}
	}
	foreach $postamount (sort { $b <=> $a } keys %Post) {
		($title, undef, undef, $color, $noshow) = split(/\|/, $Post{$postamount}, 5);
		if ($color && $noshow != 1) {
			$tmpcnt++;
			$tmpcolors{$tmpcnt} = qq~<div class="small" style="float: left; width: 49%;"><span style="color: $color;"><b>lllll</b></span> $title</div>~;
		}
	}
	$rows = int(($tmpcnt / 2) + 0.5);
	$col1 = 1;
	for(1..$rows) {
		$col2 = $rows + $col1;
		if($tmpcolors{$col1}) { $grpcolors .= qq~$tmpcolors{$col1}~; }
		if($tmpcolors{$col2}) { $grpcolors .= qq~$tmpcolors{$col2}~; }
		$col1++;
	}
	undef %tmpcolors;

	# Template it
	my ($rss_link, $rss_text);
	if (!$rss_disabled) {
		$rss_link = qq~<a href="$scripturl?action=RSSrecent"><img src="$imagesdir/rss.png" border="0" alt="$main_txt{'rssfeed'}" style="vertical-align: middle;" /></a>~;
		$rss_link = qq~<a href="$scripturl?action=RSSrecent;catselect=$INFO{'catselect'}"><img src="$imagesdir/rss.png" border="0" alt="$main_txt{'rssfeed'}" style="vertical-align: middle;" /></a>~ if $INFO{'catselect'};
		$rss_text = qq~<a href="$scripturl?action=RSSrecent">$boardindex_txt{'792'}</a>~;
		$rss_text = qq~<a href="$scripturl?action=RSSrecent;catselect=$INFO{'catselect'}">$boardindex_txt{'792'}</a>~ if $INFO{'catselect'};
	}
	$yyrssfeed = $rss_text;
	$yyrss = $rss_link;
	$boardindex_template =~ s/({|<)yabb rssfeed(}|>)/$rss_text/g;
	$boardindex_template =~ s/({|<)yabb rss(}|>)/$rss_link/g;

	$boardindex_template =~ s/({|<)yabb navigation(}|>)/&nbsp;/g;
	$boardindex_template =~ s/({|<)yabb selecthtml(}|>)//g;
	$boardindex_template =~ s/({|<)yabb catsblock(}|>)/$tmptemplateblock/g;

	$boardhandellist     =~ s/({|<)yabb collapse(}|>)/$collapselink/g;
	$boardhandellist     =~ s/({|<)yabb expand(}|>)/$expandlink/g;
	$boardhandellist     =~ s/({|<)yabb markallread(}|>)/$markalllink/g;
	$boardhandellist     =~ s/\Q$menusep//i;

	$boardindex_template =~ s/({|<)yabb boardhandellist(}|>)/$boardhandellist/g;
	$boardindex_template =~ s/({|<)yabb totaltopics(}|>)/$totalt/g;
	$boardindex_template =~ s/({|<)yabb totalmessages(}|>)/$totalm/g;

	&LoadCensorList;

	if ($Show_RecentBar) {
		$lssub = &Censor($lssub);
		$lssub =~ s/\[m.*?\]/$maintxt{'758'}/;
		&ToChars($lssub);
		$tmlsdatetime    = qq~($lsdatetime).<br />~;
		$lastpostlink    = qq~$boardindex_txt{'236'} <b><a href="$scripturl?num=$lspostid/$lsreply#$lsreply"><b>$lssub</b></a></b>~;
		$recentpostslink = qq~$boardindex_txt{'791'} <a href="$scripturl?action=recent;display=10">$boardindex_txt{'792'}</a> $boardindex_txt{'793'}~;
		$boardindex_template =~ s/({|<)yabb lastpostlink(}|>)/$lastpostlink/g;
		$boardindex_template =~ s/({|<)yabb recentposts(}|>)/$recentpostslink/g;
		$boardindex_template =~ s/({|<)yabb lastpostdate(}|>)/$tmlsdatetime/g;
	} else {
		$boardindex_template =~ s/({|<)yabb lastpostlink(}|>)//g;
		$boardindex_template =~ s/({|<)yabb recentposts(}|>)//g;
		$boardindex_template =~ s/({|<)yabb lastpostdate(}|>)//g;
	}
	$membercountlink = qq~<a href="$scripturl?action=ml"><b>$memcount</b></a>~;
	$boardindex_template =~ s/({|<)yabb membercount(}|>)/$membercountlink/g;
	if ($showlatestmember) {
		&LoadUser($latestmember);
		$latestmemberlink = qq~$boardindex_txt{'201'} <a href="$scripturl?action=viewprofile;username=$useraccount{$latestmember}"><b>${$uid.$latestmember}{'realname'}</b></a>.<br />~;
		$boardindex_template =~ s/({|<)yabb latestmember(}|>)/$latestmemberlink/g;
	} else {
		$boardindex_template =~ s/({|<)yabb latestmember(}|>)//g;
	}
	$boardindex_template =~ s/({|<)yabb ims(}|>)/$ims/g;
	$boardindex_template =~ s/({|<)yabb guests(}|>)/$guestson/g;
	$boardindex_template =~ s/({|<)yabb users(}|>)/$userson/g;
	$boardindex_template =~ s/({|<)yabb bots(}|>)/$botson/g;
	$boardindex_template =~ s/({|<)yabb onlineusers(}|>)/$users/g;
	$boardindex_template =~ s/({|<)yabb onlineguests(}|>)/$guestlist/g;
	$boardindex_template =~ s/({|<)yabb onlinebots(}|>)/$botlist/g;
	$boardindex_template =~ s/({|<)yabb mostmembers(}|>)/$mostmemb/g;
	$boardindex_template =~ s/({|<)yabb mostguests(}|>)/$mostguest/g;
	$boardindex_template =~ s/({|<)yabb mostbots(}|>)/$mostbots/g;
	$boardindex_template =~ s/({|<)yabb mostusers(}|>)/$mostusers/g;
	$boardindex_template =~ s/({|<)yabb mostmembersdate(}|>)/$themostmembdate/g;
	$boardindex_template =~ s/({|<)yabb mostguestsdate(}|>)/$themostguestdate/g;
	$boardindex_template =~ s/({|<)yabb mostbotsdate(}|>)/$themostbotsdate/g;
	$boardindex_template =~ s/({|<)yabb mostusersdate(}|>)/$themostuserdate/g;
	$boardindex_template =~ s/({|<)yabb groupcolors(}|>)/$grpcolors/g;
	$boardindex_template =~ s/({|<)yabb sharedlogin(}|>)/$shared_login/g;

	$yymain .= $boardindex_template;

	if (${$username}{'PMimnewcount'} > 0) {
		if (${$username}{'PMimnewcount'} > 1) { $en = 's'; $en2 = $boardindex_imtxt{'47'}; }
		else { $en = ''; $en2 = $boardindex_imtxt{'48'}; }

		chomp(${$uid.$username}{'im_imspop'});
		chomp(${$uid.$username}{'im_popup'});

		if (${$uid.$username}{'im_popup'} eq 'on') {
			if (${$uid.$username}{'im_imspop'} eq 'on') {
				$yymain .= qq~
	<script language="JavaScript" type="text/javascript">
	function rimpu() { window.open("$scripturl?action=im"); }
	function cancel () { }
	</script>~;
			} else {
				$yymain .= qq~
	<script language="JavaScript" type="text/javascript">
	function rimpu() { location.href = ("$scripturl?action=im"); }
	function cancel () { }
	</script>~;
			}

			$yymain .= qq~
	<script language="JavaScript" type="text/javascript">
	<!-- BEGIN
		if (confirm("$boardindex_imtxt{'14'} ${$username}{'PMimnewcount'}$boardindex_imtxt{'15'}?")) { rimpu(); } else { cancel(); }
	// END -->
	</script>
		~;
		}
	}

	if ($BCnewMessage) {
		chomp(${$uid.$username}{'im_popup'});
		if (${$uid.$username}{'im_imspop'} eq 'on') {
			$yymain .= qq~
	<script language="JavaScript" type="text/javascript">
	function rimpuBC() { window.open("$scripturl?action=im;focus=bmess"); }
	function cancelBC () { }
	</script>~;
			} else {
				$yymain .= qq~
	<script language="JavaScript" type="text/javascript">
	function rimpuBC() { location.href = ("$scripturl?action=im;focus=bmess"); }
	function cancelBC () { }
	</script>~;
			}

			$yymain .= qq~
	<script language="JavaScript" type="text/javascript">
	<!-- BEGIN
		if (confirm("$boardindex_imtxt{'50'}$boardindex_imtxt{'51'}?")) { rimpuBC(); } else { cancelBC(); }
	// END -->
	</script>
		~;
	}

	# Make browsers aware of our RSS
	if (!$rss_disabled) {
		if ($INFO{'catselect'}) { # Handle categories properly
			$yyinlinestyle .= qq~<link rel="alternate" type="application/rss+xml" title="$boardindex_txt{'792'}" href="$scripturl?action=RSSrecent;catselect=$INFO{'catselect'}" />~;
		} else {
			$yyinlinestyle .= qq~<link rel="alternate" type="application/rss+xml" title="$boardindex_txt{'792'}" href="$scripturl?action=RSSrecent" />~;
		}
	}

	&template;
	exit;
}

sub Collapse_Write {
	my @userhide;

	# rewrite the category hash for the user
	foreach my $key (@categoryorder) {
		my ($catname, $catperms, $catallowcol) = split(/\|/, $catinfo{$key});
		$access = &CatAccess($catperms);
		if ($catcol{$key} == 0 && $access) { push(@userhide, $key); }
	}
	${$uid.$username}{'cathide'} = join(",", @userhide);
	&UserAccount($username, "update");
	if (-e "$memberdir/$username.cat") { unlink "$memberdir/$username.cat"; }
}

sub Collapse_Cat {
	if ($iamguest) { &fatal_error("collapse_no_member"); }
	my $changecat = $INFO{'cat'};
	unless ($colloaded) { &Collapse_Load; }

	if ($catcol{$changecat} eq 1) {
		$catcol{$changecat} = 0;
	} else {
		$catcol{$changecat} = 1;
	}
	&Collapse_Write;
	$yySetLocation = $scripturl;
	&redirectexit;
}

sub Collapse_All {
	my ($state, @catstatus);
	$state = $INFO{'status'};

	if ($iamguest) { &fatal_error("collapse_no_member"); }
	if ($state != 1 && $state != 0) { &fatal_error("collapse_invalid_state"); }

	foreach my $key (@categoryorder) {
		my ($catname, $catperms, $catallowcol) = split(/\|/, $catinfo{$key});
		if ($catallowcol eq '1') {
			$catcol{$key} = $state;
		} else {
			$catcol{$key} = 1;
		}
	}
	&Collapse_Write;

	$yySetLocation = $scripturl;
	&redirectexit;
}

sub MarkAllRead {
	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }

	my @cats = ();
	if($INFO{'cat'}) {@cats = ($INFO{'cat'});}
	else {@cats = @categoryorder;}

	# Load the whole log
	fopen(GETLOG, "$memberdir/$username.log");
	my @logentries = <GETLOG>;
	fclose(GETLOG);
	%yyuserlog = map { if($_) {split(/\|/); ($_[0], $_[1] || $_[2])} } @logentries;

	foreach my $catid (@cats) {
		# Security check
		my $catperms = (split /\|/, $catinfo{$catid})[1];
		next unless &CatAccess($catperms);

		foreach my $board (split(/\,/, $cat{$catid})) {
			# Security check
			my $boardperms = (split /\|/, $board{$board})[1];
			next if &AccessCheck($board, '', $boardperms) ne 'granted';
			# Mark it
			$yyuserlog{"$board--mark"} = CORE::time;
			$yyuserlog{$board} = CORE::time;
		}
	}
	
	# Write it out
	&dumplog();

	$yySetLocation = $scripturl;
	&redirectexit;
}

sub gostRemove {
	$thecat    = $_[0];
	$gostboard = $_[1];
	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
	(@gbdlist) = split(/\,/, $cat{$thecat});
	$tmp_master = '';
	foreach $item (@gbdlist) {
		if ($item ne $gostboard) {
			$tmp_master .= qq~$item,~;
		}
	}
	$tmp_master =~ s/,\Z//;
	$cat{$thecat} = $tmp_master;
	&Write_ForumMaster;
}

1;

