###############################################################################
#AdvancedTabs.pl					                                              	    #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$advancedtabsplver = 'YaBB 2.2.1 $Revision: 1.1.2.10 $';
if ($action eq 'detailedversion') { return 1; }

LoadLanguage("TabMenu");

$tab_lang = $language ? $language : $lang;
if(!-e "$langdir/$tab_lang/tabtext.txt") {
	if(-e "$langdir/English/tabtext.txt") {
		fopen(TABTXT, "$langdir/English/tabtext.txt");
		%tabtxt = map /(.*)\t(.*)/, <TABTXT>;
		fclose(TABTXT);
		fopen(TABTXT, ">$langdir/$tab_lang/tabtext.txt");
		print TABTXT map "$_\t$tabtxt{$_}\n", keys %tabtxt;
		fclose(TABTXT);
	}
}
elsif(fopen(TABTXT, "$langdir/$tab_lang/tabtext.txt")) {
	%tabtxt = map /(.*)\t(.*)/, <TABTXT>;
	fclose(TABTXT);
}

if (-e "$vardir/taborder.txt") {
	fopen(TABFILE, "$vardir/taborder.txt");
	@tabs = <TABFILE>;
	fclose(TABFILE);
}
else {
	@tabs = qw (home help search ml admin revalidatesession login register guestpm mycenter logout);
	fopen(TABFILE, ">$vardir/taborder.txt",1) || &fatal_error('cannot_open', "$vardir/Menuorder.txt", 1);
	for (my $cnt = 0; $cnt < @tabs; $cnt++) {
		print TABFILE "$tabs[$cnt]\n";
	}
	fclose(TABFILE);
}

if (-e "$vardir/tabs_ext.def") {
	fopen(EXTTAB, "$vardir/tabs_ext.def");
	%exttabs = map /(.*)\t(.*)/, <EXTTAB>;
	fclose(EXTTAB);
}

sub LoadTabmenu {
	if (-e "$vardir/tabs_ext.def") {
		while (($tab_key, $tab_value) = each(%exttabs)) {
			my($tmptab_url, $isaction, $username_req, $tab_access, $tab_newwin) = split(/\|/, $tab_value);
			if(!$tab_access || ($tab_access < 2 && !$iamguest) || ($tab_access < 3 && $iamgmod) || $iamadmin) {
				if($tmptab_url == 1) { $tab_url = qq~$scripturl~; }
				elsif($tmptab_url == 2) { $tab_url = qq~$boardurl/AdminIndex.$yyaext~; }
				else { $tab_url = qq~$tmptab_url~; }
				if($isaction) { $tab_url .= qq~?action=$tab_key~; }
				if($username_req) { $tab_url .= qq~;username=$useraccount{$username}~; }
				my $newwin = "";
				if($tab_newwin) { $newwin = qq~ target="_blank"~; }
				$tab{$tab_key} = qq~<span |><a href="$tab_url"$newwin title = "$tabtxt{$tab_key}" style="padding: 3px 0 4px 0;">$tabfill $tabtxt{$tab_key} $tabfill</a></span>~;
			}
		}
	}


	for ($i = 0; $i < @tabs; $i++) {
		chomp $tabs[$i];
		if($tab{$tabs[$i]}) {
			my ($first, $last) = split(/\|/, $tab{$tabs[$i]});
			my $selected = "";
			if($tabs[$i] eq $tmpaction && $last) { $selected = qq~ class="selected"~; }
			$yytabmenu .= qq~$first$selected$last$tabsep~;
		}
	}

	if ($iamadmin) {
		my($seladdtab, $seledittab);
		if($action eq "addtab") { $seladdtab = qq~ class="selected"~; }
		elsif($action eq "edittab") { $seledittab = qq~ class="selected"~; }
		$yytabadd = qq~<div style="float: right; width: 100px; height: 21px; text-align: right;">~;
		$yytabadd .= qq~$tabsep<span $seladdtab><a href="$scripturl?action=addtab" title = "$tabmenu_txt{'newtab'}" style="padding: 2px 0;">$tabfill<img src="$imagesdir/tabadd.gif" height="23" width="20" border="0" alt="$tabmenu_txt{'newtab'}" />$tabfill</a></span>$tabsep~;
		$yytabadd .= qq~<span $seledittab><a href="$scripturl?action=edittab" title = "$tabmenu_txt{'edittab'}" style="padding: 2px 0;">$tabfill<img src="$imagesdir/tabedit.gif" height="23" width="20" border="0" alt="$tabmenu_txt{'edittab'}" />$tabfill</a></span>$tabsep~;
		$yytabadd .= qq~</div>~;
	}
	else {
		$yytabadd = qq~&nbsp;~;
	}
}

sub AddNewTab {

	$tabsep = qq~<img src="$imagesdir/tabsep211.png" border="0" alt="" style="float: left; vertical-align: middle;" />~;
	$tabfill = qq~<img src="$imagesdir/tabfill.gif" border="0" alt="" style="vertical-align: middle;" />~;

	&GetTabtext;

	$edittabs = qq~<option value="thefront">$tabmenu_txt{'tabfront'}</option>~;
	for ($i = 0; $i < @tabs; $i++) {
		chomp $tabs[$i];
		if($texttab{$tabs[$i]}) {
			$edittabs .= qq~<option value="$tabs[$i]">$texttab{$tabs[$i]}</option>~;
		}
	}
	undef %edittab;

$yyaddtab = "";
$yyaddtab = qq~
	<br />

	<script language="JavaScript1.2" type="text/javascript">
	<!--
	function submittab() {
		if (window.submitted) return false;
		window.submitted = true;
		return true;
	}
	
	function checkTab(theForm) {
		var isError = 0;
		var tabError = "$tabmenu_txt{'taberr'}\\n";
	
		if (theForm.tabtext.value == "") { tabError += "\\n- $tabmenu_txt{'texterr'}"; if(isError == 0) isError = 1; }
		if (theForm.taburl.value == "") { tabError += "\\n- $tabmenu_txt{'urlerr'}"; if(isError == 0) isError = 2; }
		if(isError >= 1) {
			alert(tabError);
			if(isError == 1) theForm.tabtext.focus();
			else if(isError == 2) theForm.taburl.focus();
			else if(isError == 3) theForm.tabtext.focus();
			return false;
		}
		return true
	}
	
	//-->
	</script>

	<form action="$scripturl?action=addtab2" method="post" name="addtabtext" style="font-size: 11px; display: inline;" onsubmit="if(!checkTab(this)) {return false} else {return submittab()}">
	<table width="100%" cellpadding="0" cellspacing="0" border="0">
	<tr>
		<td class="tabmenuleft" width="40">&nbsp;</td>
		<td class="tabmenu" align="right" valign="middle" style="text-align: left; vertical-align: middle;">
			<span class="selected" style="cursor: auto; vertical-align: middle; padding-top: 1px; white-space: nowrap;">$tabfill$tabmenu_txt{'tabtext'} <input type="text" name="tabtext" id="tabtext" value="" size="10" class="small" style="vertical-align: middle;" /></span>
			<span class="selected" style="cursor: auto; vertical-align: middle; padding-top: 1px; white-space: nowrap;">$tabfill$tabmenu_txt{'taburl'} <input type="text" name="taburl" id="taburl" value="" size="25" class="small" style="vertical-align: middle;" /></span>

			<span class="selected" style="cursor: auto; vertical-align: middle; padding-top: 1px; white-space: nowrap;">$tabfill$tabmenu_txt{'tabwin'} <input type="checkbox" name="tabwin" id="tabwin" style="border: 0; padding: 0; margin: 0; background-color: transparent; vertical-align: middle;" /></span>

			<span class="selected" style="cursor: auto; vertical-align: middle; padding-top: 1px; white-space: nowrap;">$tabfill$tabmenu_txt{'tabview'}
				<select name="showto" class="small" style="vertical-align: middle;">
       					<option value="0" selected="selected">$tabmenu_txt{'viewall'}</option>
       					<option value="1">$tabmenu_txt{'viewmem'}</option>
       					<option value="2">$tabmenu_txt{'viewgm'}</option>
       					<option value="3">$tabmenu_txt{'viewadm'}</option>
				</select>
			</span>
			<span class="selected" style="cursor: auto; vertical-align: middle; padding-top: 1px; white-space: nowrap;">$tabfill$tabmenu_txt{'tabinsert'}
				<select name="addafter" class="small" style="vertical-align: middle;">
					$edittabs
				</select>
			</span>
			<span class="selected" style="cursor: auto; vertical-align: middle; padding-top: 1px; white-space: nowrap;">$tabfill<input type="submit" value="$tabmenu_txt{'addtab'}" class="small" style="vertical-align: middle;" />$tabfill</span>$tabsep
		</td>
	</tr>
	</table>
	</form>
~;
}

sub AddNewTab2 {

if($iamadmin) {
	$tabtext = $FORM{'tabtext'};
	my $taburl = $FORM{'taburl'};
	my $tabwin = $FORM{'tabwin'} ? 1 : 0;
	my $tabview = $FORM{'showto'};
	my $tabafter = $FORM{'addafter'};
	my $tmpusernamereq = 0;

	if ($taburl !~ /^\http:\/\//) { $taburl = qq~http://$taburl~; }

	if($taburl =~ m/action\=(.*?)(\;|\Z)/i) {
		$tabaction = $1;
		$tmpisaction = 1;
	}
	else {
		$tabaction = lc $tabtext;
		$tabaction =~ s/ /\_/g;
		$tmpisaction = 0;
	}

	if(exists $exttabs{$tabaction}) { &fatal_error('tabext'); }

	if($taburl =~ m/username\=/i) {
		$tmpusernamereq = 1;
	}
	if($taburl =~ /$boardurl\/YaBB\.$yyaext/i && $taburl =~ /action\=/i) { $taburl = 1; }
	elsif($taburl =~ /$boardurl\/AdminIndex\.$yyaext/i && $taburl =~ /action\=/i) { $taburl = 2; }
	$exttabs{$tabaction} = qq~$taburl|$tmpisaction|$tmpusernamereq|$tabview|$tabwin~;
	fopen(EXTTAB, ">$vardir/tabs_ext.def");
	print EXTTAB map "$_\t$exttabs{$_}\n", keys %exttabs;
	fclose(EXTTAB);
	undef %exttabs;

	&ToHTML($tabtext);

	opendir(DIR, "$langdir");
	@languages = readdir(DIR);
	closedir(DIR);

	foreach $lngdir (@languages) {
		if($lngdir eq "." || $lngdir eq ".." || !-d "$langdir/$lngdir") { next; }
		elsif(!-e "$langdir/$lngdir/tabtext.txt") {
			$tabtxt{$tabaction} = $tabtext;
			fopen(TABTXT, ">$langdir/$lngdir/tabtext.txt");
			print TABTXT map "$_\t$tabtxt{$_}\n", keys %tabtxt;
			fclose(TABTXT);
		}
		else {
			fopen(TABTXT, "$langdir/$lngdir/tabtext.txt");
			%tabtxt = map /(.*)\t(.*)/, <TABTXT>;
			fclose(TABTXT);
			$tabtxt{$tabaction} = $tabtext;
			fopen(TABTXT, ">$langdir/$lngdir/tabtext.txt");
			print TABTXT map "$_\t$tabtxt{$_}\n", keys %tabtxt;
			fclose(TABTXT);
		}
	}

	fopen(TABORDER, ">$vardir/taborder.txt");
	if($tabafter eq "thefront") {
		print TABORDER "$tabaction\n";
	}
	for ($i = 0; $i < @tabs; $i++) {
		chomp $tabs[$i];
		print TABORDER "$tabs[$i]\n";
		if($tabs[$i] eq $tabafter) {
			print TABORDER "$tabaction\n";
		}
	}
	fclose(TABORDER);
}

$yySetLocation = $scripturl;
&redirectexit;
}

sub EditTab {
	my $isexttabs = 0;
	$tabsep = qq~<img src="$imagesdir/tabsep211.png" border="0" alt="" style="float: left; vertical-align: middle;" />~;
	$tabfill = qq~<img src="$imagesdir/tabfill.gif" border="0" alt="" style="vertical-align: middle;" />~;
	$tabsave = qq~<img src="$imagesdir/tabsave.gif" border="0" alt="$tabmenu_txt{'savetab'}" style="vertical-align: middle;" />~;
	$tabdel = qq~<img src="$imagesdir/tabdelete.gif" border="0" alt="$tabmenu_txt{'tabdel'}" style="vertical-align: middle;" />~;
	$tabstyle = qq~style="font-size: 11px; white-space: nowrap; cursor: auto;"~;

	$edittab{'home'} = qq~<span $tabstyle>$tabfill$img_txt{'103'}$tabfill</span>~;
	$edittab{'help'} = qq~<span $tabstyle>$tabfill$img_txt{'119'}$tabfill</span>~;
	$edittab{'search'} = qq~<span $tabstyle>$tabfill$img_txt{'182'}$tabfill</span>~;
	$edittab{'ml'} = qq~<span $tabstyle>$tabfill$img_txt{'331'}$tabfill</span>~;
	$edittab{'admin'} = qq~<span $tabstyle>$tabfill$img_txt{'2'}$tabfill</span>~;
	$edittab{'revalidatesession'} = qq~<span $tabstyle>$tabfill$img_txt{'34a'}$tabfill</span>~;
	$edittab{'login'} = qq~<span $tabstyle>$tabfill$img_txt{'34'}$tabfill</span>~;
	$edittab{'register'} = qq~<span $tabstyle>$tabfill$img_txt{'97'}$tabfill</span>~;
	$edittab{'guestpm'} = qq~<span $tabstyle>$tabfill$img_txt{'pmadmin'}$tabfill</span>~;
	$edittab{'mycenter'} = qq~<span $tabstyle>$tabfill$img_txt{'mycenter'}$tabfill</span>~;
	$edittab{'logout'} = qq~<span $tabstyle>$tabfill$img_txt{'108'}$tabfill</span>~;

	if (-e "$vardir/tabs_ext.def") {
		while (($tab_key, $tab_value) = each(%exttabs)) {
			$enc_key = $tab_key;
			$enc_key =~ s~\&~%26~g;
			$isexttabs++;
			my($tmptab_url, $isaction, $username_req, $tab_access) = split(/\|/, $tab_value);
			if(!$tab_access || ($tab_access < 2 && !$iamguest) || ($tab_access < 3 && $iamgmod) || $iamadmin) {
				if($tmptab_url == 1) { $tab_url = qq~$scripturl~; }
				elsif($tmptab_url == 2) { $tab_url = qq~$boardurl/AdminIndex.$yyaext~; }
				else { $tab_url = qq~$tmptab_url~; }
				if($isaction) { $tab_url .= qq~?action=$tab_key~; }
				if($username_req) { $tab_url .= qq~;username=$useraccount{$username}~; }
				$inputlength = length($tabtxt{$tab_key});
				$edittab{$tab_key} = qq~<form action="$scripturl?action=edittab2;savetab=$enc_key" method="post" name="$tab_key$isexttabs" style="display: inline; white-space: nowrap;">~;
				$edittab{$tab_key} .= qq~<span $tabstyle>$tabfill~;
				$edittab{$tab_key} .= qq~<input type="text" name="$tab_key" id="$tab_key" value="$tabtxt{$tab_key}" size="$inputlength" class="small" style="font-size: 11px; border: 0; margin: 0; padding: 0; background-color: transparent; vertical-align: middle;" />$tabfill~;
				$edittab{$tab_key} .= qq~<input type="image" src="$imagesdir/tabsave.gif" alt="$tabmenu_txt{'savetab'}" style="background-color: transparent; border:0; vertical-align: middle;" />~;
				$edittab{$tab_key} .= qq~ <a href="$scripturl?action=deletetab;deltab=$enc_key">$tabdel</a>~;
				$edittab{$tab_key} .= qq~$tabfill</span>~;
				$edittab{$tab_key} .= qq~</form>~;
			}
		}
	}

	&GetTabtext;

	$selsize = 0;
	for ($i = 0; $i < @tabs; $i++) {
		chomp $tabs[$i];
		if($edittab{$tabs[$i]}) {
			if ($tabs[$i] eq $INFO{"thetab"}) {
				$edittabs .= qq~<option value="$tabs[$i]" selected="selected">$texttab{$tabs[$i]}</option>~;
			} else {
				$edittabs .= qq~<option value="$tabs[$i]">$texttab{$tabs[$i]}</option>~;
			}
			$edittabmenu .= qq~$edittab{$tabs[$i]}$tabsep~;
			$selsize++;
		}
	}
	if($selsize > 11) { $selsize = 11; }
$yyaddtab = "";
$yyaddtab = qq~
	<br />
	<table width="100%" cellpadding="0" cellspacing="0" border="0">
	<tr>
		<td class="tabmenuleft" width="40" style="text-align: left; vertical-align: top;">&nbsp;</td>
		<td class="tabmenu" style="text-align: left; vertical-align: top;">
			$edittabmenu
		</td>
		<td class="tabmenuright" width="45" style="text-align: left; vertical-align: top;">&nbsp;</td>
		<td class="rightbox" width="160" align="center" valign="top" rowspan="4">
			<div style="float: left; width: 100%; font-weight: bold; text-align: center; margin: 5px 0; display: inline;">$tabmenu_txt{'reordertab'}</div>
			<form action="$scripturl?action=reordertab" method="post" name="tabsorder" style="display: inline; white-space: nowrap;">
			<select name="ordertabs" class="small" size="$selsize" style="width: 130px;">
				$edittabs
			</select><br />
			<input type="submit" value="$tabmenu_txt{'tableft'}" name="moveleft" style="font-size: 11px; width: 65px;" /><input type="submit" value="$tabmenu_txt{'tabright'}" name="moveright" style="font-size: 11px; width: 65px;" />
			</form>
		</td>

	</tr>
	<tr>
		<td colspan="3">&nbsp;</td>
	</tr>
	<tr>
		<td width="40">&nbsp;</td>
		<td class="windowbg" style="text-align: left;">
			<div class="small" style="float: left; width: 98%; padding: 4px;">
				$tabmenu_txt{'edittext1'} $tabsave$tabmenu_txt{'edittext2'}$tabdel$tabmenu_txt{'edittext3'}<br />
				$tabmenu_txt{'reordertext'}
			</div>

		</td>
		<td width="45">&nbsp;</td>
	</tr>
	<tr>
		<td colspan="3" style="font-size: 50px; text-align: left; vertical-align: top;">&nbsp;</td>
	</tr>
	</table>
~;
}

sub EditTab2 {

if($iamadmin) {
	$tosave = $INFO{'savetab'};
	$tosave =~ s~%26~&~g;
	$tosavetxt = $FORM{$tosave};
	&ToHTML($tosavetxt);
	$tabtxt{$tosave} = $tosavetxt;
	fopen(TABTXT, ">$langdir/$tab_lang/tabtext.txt");
	print TABTXT map "$_\t$tabtxt{$_}\n", keys %tabtxt;
	fclose(TABTXT);
}

$yySetLocation = $scripturl;
&redirectexit;
}

sub ReorderTab {

if($iamadmin) {
	$moveitem = $FORM{'ordertabs'};

	if($moveitem) {
		if ($FORM{'moveleft'}) {
			for ($i = 0; $i < @tabs; $i++) {
				chomp $tabs[$i];
				if ($tabs[$i] eq $moveitem && $i > 0) {
					$j = $i - 1;
					$tabs[$i] = $tabs[$j];
					$tabs[$j] = $moveitem;
					last;
				}
			}
		} elsif ($FORM{'moveright'}) {
			for ($i = 0; $i < @tabs; $i++) {
				chomp $tabs[$i];
				if ($tabs[$i] eq $moveitem && $i < $#tabs) {
					$j = $i + 1;
					$tabs[$i] = $tabs[$j];
					$tabs[$j] = $moveitem;
					last;
				}
			}
		}
	}

	fopen(TABORDER, ">$vardir/taborder.txt");
	for ($i = 0; $i < @tabs; $i++) {
		chomp $tabs[$i];
		print TABORDER "$tabs[$i]\n";
	}
	fclose(TABORDER);

}

$yySetLocation = qq~$scripturl?action=edittab;thetab=$moveitem~;
&redirectexit;
}


sub DeleteTab {

if($iamadmin) {
	$todelete = $INFO{'deltab'};
	$todelete =~ s~%26~&~g;
	if (-e "$vardir/tabs_ext.def") {
		delete($exttabs{$todelete});
		fopen(EXTTAB, ">$vardir/tabs_ext.def");
		print EXTTAB map "$_\t$exttabs{$_}\n", keys %exttabs;
		fclose(EXTTAB);
		undef %exttabs;
		if (!-s "$vardir/tabs_ext.def") { unlink("$vardir/tabs_ext.def"); }

		opendir(DIR, "$langdir");
		@languages = readdir(DIR);
		closedir(DIR);
	
		foreach $lngdir (@languages) {
			if($lngdir eq "." || $lngdir eq ".." || !-d "$langdir/$lngdir" || !-e "$langdir/$lngdir/tabtext.txt") { next; }
			else {
				fopen(TABTXT, "$langdir/$lngdir/tabtext.txt");
				%tabtxt = map /(.*)\t(.*)/, <TABTXT>;
				fclose(TABTXT);
				delete($tabtxt{$todelete});
				fopen(TABTXT, ">$langdir/$lngdir/tabtext.txt");
				print TABTXT map "$_\t$tabtxt{$_}\n", keys %tabtxt;
				fclose(TABTXT);
			}
			if (!-s "$langdir/$lngdir/tabtext.txt") { unlink("$langdir/$lngdir/tabtext.txt"); }
		}

		fopen(TABORDER, ">$vardir/taborder.txt");
		for ($i = 0; $i < @tabs; $i++) {
			chomp $tabs[$i];
			unless($tabs[$i] eq $todelete) {
				print TABORDER "$tabs[$i]\n";
			}
		}
		fclose(TABORDER);
	}
}

$yySetLocation = qq~$scripturl~;
&redirectexit;
}


sub GetTabtext {
	$texttab{'home'} = qq~$img_txt{'103'}~;
	$texttab{'help'} = qq~$img_txt{'119'}~;
	$texttab{'search'} = qq~$img_txt{'182'}~;
	$texttab{'ml'} = qq~$img_txt{'331'}~;
	$texttab{'admin'} = qq~$img_txt{'2'}~;
	$texttab{'revalidatesession'} = qq~$img_txt{'34a'}~;
	$texttab{'login'} = qq~$img_txt{'34'}~;
	$texttab{'register'} = qq~$img_txt{'97'}~;
	$texttab{'guestpm'} = qq~$img_txt{'pmadmin'}~;
	$texttab{'mycenter'} = qq~$img_txt{'mycenter'}~;
	$texttab{'logout'} = qq~$img_txt{'108'}~;

	if (-e "$vardir/tabs_ext.def") {
		while (($tab_key, $tab_value) = each(%exttabs)) {
			$texttab{$tab_key} = qq~$tabtxt{$tab_key}~;
		}
	}
}

1;