###############################################################################
# Settings_Security.pl                                                        #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$settings_securityplver = 'YaBB 2.2.1 $Revision: 1.14.2.3 $';
if ($action eq 'detailedversion') { return 1; }

&LoadLanguage('Sessions');

if ($regcheck) {
	require "$sourcedir/Decoder.pl";
	&validation_code;
}

# List of settings
@settings = (
{
	name  => $settings_txt{'generalsec'},
	id    => 'flood',
	items => [
		{
			description => qq~$dereftxt{'2'}<br /><span class="small">$dereftxt{'4'}</span>~,
			input_html => qq~<input type="checkbox" name="stealthurl" value="1"${ischecked($stealthurl)} />~,
			name => 'stealthurl',
			validate => 'boolean',
		},
		{
			description => qq~$session_txt{'1'}<br /><span class="small">$session_txt{'2'}</span>~,
			input_html => qq~<input type="checkbox" name="sessions" value="1"${ischecked($sessions)} />~,
			name => 'sessions',
			validate => 'boolean',
		},
		{
			description => qq~$admin_txt{'110'}<br /><span class="small">$admin_txt{'111'}</span>~,
			input_html => qq~<input type="checkbox" name="do_scramble_id" value="1"${ischecked($do_scramble_id)} />~,
			name => 'do_scramble_id',
			validate => 'boolean',
		},
		{
			description => $reftxt{'8'},
			input_html => qq~<input type="checkbox" name="referersecurity" value="1"${ischecked($referersecurity)} />~,
			name => 'referersecurity',
			validate => 'boolean',
		},
		{
			description => $admin_txt{'show_ip_admin'},
			input_html => qq~<input type="checkbox" name="show_online_ip_admin" value="1"${ischecked($show_online_ip_admin)} />~,
			name => 'show_online_ip_admin',
			validate => 'boolean',
		},
		{
			description => $admin_txt{'show_ip_gmod'},
			input_html => qq~<input type="checkbox" name="show_online_ip_gmod" value="1"${ischecked($show_online_ip_gmod)} />~,
			name => 'show_online_ip_gmod',
			validate => 'boolean',
		},
	],
},
{
	name  => $settings_txt{'validimage'},
	id    => 'validimage',
	items => [
		{
			description => $floodtxt{'2'},
			input_html => qq~<input type="checkbox" name="regcheck" value="1"${ischecked($regcheck)} />~,
			name => 'regcheck',
			validate => 'boolean',
		},
		{
			description => $floodtxt{'3'},
			input_html => qq~<input type="checkbox" name="gpvalid_en" value="1"${ischecked($gpvalid_en)} />~,
			name => 'gpvalid_en',
			validate => 'boolean',
		},
		{
			description => $floodtxt{'9'},
			input_html => qq~<input type="checkbox" name="translayer" value="1"${ischecked($translayer)} />~,
			name => 'translayer',
			validate => 'boolean',
		},
		{
			description => $floodtxt{'7'},
			input_html => qq~<input type="text" name="codemaxchars" size="5" value="$codemaxchars" />~,
			name => 'codemaxchars',
			validate => 'number',
		},
		{
			description => $floodtxt{'style'},
			input_html => qq~<select name="captchastyle" size="1"> 
			<option value="L"${isselected($captchastyle eq "L")}>$floodtxt{'lower'}</option> 
			<option value="U"${isselected($captchastyle eq "U")}>$floodtxt{'upper'}</option> 
			<option value="A"${isselected($captchastyle eq "A")}>$floodtxt{'all'}</option> 
			</select>~,
			name => 'captchastyle',
			validate => 'text',
		},
		{
			description => $floodtxt{'masterkey'},
			input_html => qq~<input type="text" name="masterkey" maxlength="24" size="50" value="$masterkey" />~,
			name => 'masterkey',
			validate => 'text',
		},
		{
			description => $floodtxt{'f'},
			input_html => qq~#<input type="text" name="rgb_foreground" maxlength="6" size="6" value="$rgb_foreground" />~,
			name => 'rgb_foreground',
			validate => 'text',
		},
		{
			description => $floodtxt{'s'},
			input_html => qq~#<input type="text" name="rgb_shade" maxlength="6" size="6" value="$rgb_shade" />~,
			name => 'rgb_shade',
			validate => 'text',
		},
		{
			description => $floodtxt{'b'},
			input_html => qq~#<input type="text" name="rgb_background" maxlength="6" size="6" value="$rgb_background" />~,
			name => 'rgb_background',
			validate => 'text',
		},
		{
			description => $floodtxt{'rnd'},
			input_html => qq~<select name="randomizer" size="1"> <option value="0"${isselected($randomizer == 0)}>$floodtxt{'rm0'}</option> <option value="1"${isselected($randomizer == 1)}>$floodtxt{'rm1'}</option> <option value="2"${isselected($randomizer == 2)}>$floodtxt{'rm2'}</option> <option value="3"${isselected($randomizer == 3)}>$floodtxt{'rm3'}</option> </select>~,
			name => 'randomizer',
			validate => 'number',
		},
		{
			description => $floodtxt{'dis'},
			input_html => qq~<select name="distortion" size="1"> 
			<option value="0"${isselected($distortion == 0)}>0</option> 
			<option value="1"${isselected($distortion == 1)}>1</option> 
			<option value="2"${isselected($distortion == 2)}>2</option> 
			<option value="3"${isselected($distortion == 3)}>3</option> 
			<option value="4"${isselected($distortion == 4)}>4</option> 
			<option value="5"${isselected($distortion == 5)}>5</option> 
			<option value="6"${isselected($distortion == 6)}>6</option> 
			<option value="7"${isselected($distortion == 7)}>7</option> 
			<option value="8"${isselected($distortion == 8)}>8</option> 
			<option value="9"${isselected($distortion == 9)}>9</option> 
			</select>~,
			name => 'distortion',
			validate => 'number',
		},
		{
			description => $floodtxt{'vpreview'},
			input_html => qq~<div class="windowbg" style="padding: 5px;">$showcheck</div>~,
		},
	],
},
);

# Routine to save them
sub SaveSettings {
	# secsettings.txt stuff
	&SaveSettingsTo('secsettings.txt', @_);
}

1;