###############################################################################
# Settings_Maintenance.pl                                                     #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$settings_maintenanceplver = 'YaBB 2.2.1 $Revision: 1.3.2.2 $';
if ($action eq 'detailedversion') { return 1; }

$maintenance = 1 if -e "$vardir/maintenance.lock";

# List of settings
@settings = (
# Begin tab
{
	name  => $admin_txt{'67'}, # Tab name
	id    => 'settings', # Javascript ID
	items => [
		{
			header => $admin_txt{'67'},
		},
		{
			description => $admin_txt{'348'},
			input_html => qq~<input type="checkbox" name="maintenance" value="1" ${ischecked($maintenance)}/>~,
			name => 'maintenance',
			validate => 'boolean',
		},
		{
			description => $admin_txt{'348Text'},
			input_html => qq~<textarea cols="30" rows="5" name="maintenancetext" style="width: 98%">$maintenancetext</textarea>~,
			name => 'maintenancetext',
			validate => 'fulltext,null',
		},
	],
});

# Routine to save them
sub SaveSettings {
	my %settings = @_;

	unless($settings{'maintenance'}) {
		unlink "$vardir/maintenance.lock" || &admin_fatal_error('cannot_open_dir', "$vardir/maintenance.lock");
	} else {
		fopen (MAINT, ">$vardir/maintenance.lock") || &admin_fatal_error('cannot_open_dir', "$vardir/maintenance.lock");
		print MAINT qq~Remove this file if your board is in maintenance for no reason\n~;
		fclose (MAINT);
	}
	
	SaveSettingsTo('Settings.pl', %settings);
}

1;