###############################################################################
# RemoveOldTopics.pl                                                          #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$removeoldtopicsplver = 'YaBB 2.2.1 $Revision: 1.9.2.2 $';
if ($action eq 'detailedversion') { return 1; }

sub RemoveOldThreads {
	&is_admin_or_gmod;
	$date1;
	my (@threads, $num, $status, $keep_sticky, %attachfile, $totremovedcount, $boardremovedcount );
	$date2 = $date;
	my $refdate = $date2-int($FORM{'maxdays'});
	if ($FORM{'maxdays'} !~ /\A[0-9]+\Z/) { &admin_fatal_error("only_numbers_allowed"); }

	$yytitle = "$removemess_txt{'120'} $FORM{'maxdays'}";
	fopen(FILE, ">$vardir/oldestmes.txt");
	print FILE "$FORM{'maxdays'}";
	fclose(FILE);

	require "$boardsdir/forum.master";
	$yymain .= qq~$removemess_txt{'1'} $FORM{'maxdays'} $removemess_txt{'2'} <br />~;
	foreach $catid (@categoryorder) {
		my $boardlist = $cat{$catid};
		my (@bdlist) = split(/\,/, $boardlist);

		foreach my $curboard (@bdlist) {
			my $boarddata = $board{$curboard};
			my ($boardname, $undef, $undef) = split(/\|/, $boarddata); 
			$boardremovedcount = 0;
			if ($FORM{ $curboard . 'check' } == 1) {
				$yymain .= qq~<br />$removemess_txt{'3'} <b>$boardname</b>  ~;
				fopen(BOARDFILE, "$boardsdir/$curboard.txt");
				@threads = <BOARDFILE>;
				fclose(BOARDFILE);
				my $totthreads = @threads;
				$yymain .= qq~ ($totthreads $removemess_txt{'6'}) <br />~;
				$keep_sticky = $FORM{'keep_them'} == 1 ? 1 : 0;
				
				fopen(BOARDFILE, ">$boardsdir/$curboard.txt", 1);
				for ($a = 0; $a < @threads; $a++) {
					($num, $undef, $undef, $undef, $date1, $undef, $undef, $undef, $status) = split(/\|/, $threads[$a]);

					# Check if original thread was sticky
					if ($keep_sticky && $status =~ /s/i) {
						print BOARDFILE $threads[$a];
						$yymain .= "$num : $removemess_txt{'4'} <br />";
					} else {
						&calcdifference();
						if ($result <= $FORM{'maxdays'}) {

							# If the message is not too old
							print BOARDFILE $threads[$a];
							$yymain .= "$num = $result $removemess_txt{'122'}<br />";
						} else {
							$yymain .= "$num = $result $removemess_txt{'122'} ($removemess_txt{'123'})<br />";
							&RemoveThreadFiles($num);
							$boardremovedcount ++;
							# now storing, quick rewrite boardfile!, after delete attached file
							$attachfile{$num} = 1;
						}
					}
				}
			}
			fclose(BOARDFILE);
			&BoardCountTotals($curboard);
			&BoardSetLastInfo($currentboard);
			$totremovedcount = $totremovedcount + $boardremovedcount;
		}
	}
	$yymain .= qq~<br />$removemess_txt{'5'} $totremovedcount $removemess_txt{'6'}~;
	# remove attachments on old topics if present
	fopen(AMP, "+<$vardir/attachments.txt", 1) || &admin_fatal_error("cannot_open","$vardir/attachments.txt", 1);
	seek AMP, 0, 0;
	my @buffer = <AMP>;
	truncate AMP, 0;
	for ($a = 0; $a < @buffer; $a++) {
		my ($anum, undef, undef, undef, undef, undef, undef, $amfn) = split(/\|/, $buffer[$a]);
		chomp $amfn;
		if (exists($attachfile{$anum})) {
			$buffer[$a] = "";
			unlink("$uploaddir/$amfn");
		}
	}
	seek AMP, 0, 0;
	print AMP @buffer;
	fclose(AMP);
	undef %attachfile;
	$action_area = "removeoldthreads";
	&AdminTemplate;
	exit;
}

1;
