###############################################################################
# NewSettings.pl                                                              #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$newsettingsplver = 'YaBB 2.2.1 $Revision: 1.62.2.7 $';
if ($action eq 'detailedversion') { return 1; }

# Figure out what tabset to use, depending on the page= parameter.
my %settings_dispatch = (
	news => "$admindir/Settings_News.pl",
	main => "$admindir/Settings_Main.pl",
	advanced => "$admindir/Settings_Advanced.pl",
	security => "$admindir/Settings_Security.pl",
	antispam => "$admindir/Settings_Antispam.pl",
	maintenance => "$admindir/Settings_Maintenance.pl",

	### BOARDMOD SETTINGS ANCHOR ###
	### ADD BEFORE THESE LINES   ###
);

my $page = $INFO{'page'};
require $settings_dispatch{$page};

sub settings {
	&is_admin_or_gmod;

	my @requireorder; # an array for the correct order of the requirements
	my %requirements; # an hash that says "Y is required by X"

	$yymain .= qq~
   <a name="top"></a>
   <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
         <b>$admin_txt{'222'}</b>
       </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
        $admin_txt{'347'}
       </td>
     </tr>
  </table>
  </div>
  <br />
  <form action="$adminurl?action=newsettings2;page=$page" onsubmit="undisableAll(this);" method="post">
  <ul id="navlist">
~;
	my $i = 0;
	foreach my $tab (@settings) {
		$tab->{'name'} =~ s/ /&nbsp;/g;
		# The &nbsp;'s are for Konqueror, and also to add a little more padding.
		$yymain .= qq~    <li id="button_$tab->{'id'}" onclick="changeToTab('$tab->{'id'}'); return false;">&nbsp;<a href="#tab_$tab->{'id'}">$tab->{'name'}</a>&nbsp;</li>
~;
	}
	$yymain .= q~  </ul>~;

	foreach my $tab (@settings) {
		$yymain .= qq~
  <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
    <table width="100%" cellspacing="1" cellpadding="4" class="section" id="tab_$tab->{'id'}">
     <tr>
       <td style="text-align: left;" class="titlebg" colspan="2">
         <a name="tab_$tab->{'id'}"></a><img src="$imagesdir/preferences.gif" alt="" border="0" /> <b>$tab->{'name'}</b>
         <span style="float: right;" class="js_remove_me"><a href="#top"><b>$settings_txt{'top'}</b></a></span>
       </td>
     </tr>~;

		foreach my $item (@{$tab->{'items'}}) {
			if($item->{'header'}) {
				$yymain .= qq~
     <tr>
       <td style="text-align: left;" class="catbg" colspan="2">
         <span class="small">$item->{'header'}</span>
       </td>
     </tr>~;
			}
			elsif($item->{'two_rows'} && $item->{'input_html'}) {
				$yymain .= qq~
     <tr style="text-align: left;">
       <td style="width: 50%;" class="windowbg2" colspan="2">
         $item->{'description'}
       </td>
     </tr>
     <tr style="text-align: left;">
       <td style="width: 50%;" class="windowbg2" colspan="2">
         $item->{'input_html'}
       </td>
     </tr>~;
			}
			elsif($item->{'input_html'}) {
				$yymain .= qq~
     <tr style="text-align: left;">
       <td style="width: 50%;" class="windowbg2" valign="top">
         $item->{'description'}
       </td>
       <td style="width: 50%;" class="windowbg2" valign="top">
         $item->{'input_html'}
       </td>
     </tr>~;
			}

			# Handle settings that require other settings
			if($item->{'depends_on'} && $item->{'name'}) {
				foreach my $require (@{$item->{'depends_on'}}) {
					# This is somewhat messy, but it works well.
					# We strip off the possible options: inverse, equal, and not equal
					# Then we attach those to this current option in the detailed string for requirements
					# While this data does not really belong with the value, it transfers nicely.
					# We then remove it and reuse it later.
					my($inverse, $realname, $remainder) = $require =~ m/(\!?)(\w+)(.*)/;
					push(@requireorder, $realname) unless $requirements{$realname};
					push(@{$requirements{$realname}}, $inverse . $item->{'name'} . $remainder);
				}
			}
		}

		$yymain .= qq~
   </table>
  </div>~;
	}

	# The old method isn't quite good enough.
	# So we build a hash with the Javascript logic needed to determine if this item should be enabled.
	# When in doubt, generate some code :)
	my %requirejs;

	my $dependicies = '';
	my $onloadevents;
	foreach my $ritem (@requireorder) {
		$dependicies .= qq~
	function handleDependent_$ritem() {
		var isChecked = document.getElementsByName("$ritem")[0].checked;
		var itemValue = document.getElementsByName("$ritem")[0].value;
~;
		foreach my $require (@{$requirements{$ritem}}) {
			# Is false
			if($require =~ s/^\!//) {
				$requirejs{$require} .= qq~!document.getElementsByName("$ritem")[0].checked && ~;
			}
			# Is equal to
			elsif($require =~ s/\=\=(.+)$//) {
				$requirejs{$require} .= qq~document.getElementsByName("$ritem")[0].value == '$1' && ~;
			}
			# Is not equal to
			elsif($require =~ s/\!\=(.+)$//) {
				$requirejs{$require} .= qq~document.getElementsByName("$ritem")[0].value != '$1' && ~;
			}
			# Is true
			else {
				$requirejs{$require} .= qq~document.getElementsByName("$ritem")[0].checked && ~;
			}
			$dependicies .= qq~		checkDependent("$require");
~;
		}
		$dependicies .= qq~	};
	document.getElementsByName("$ritem")[0].onclick = handleDependent_$ritem;
~;
		$onloadevents .= qq~handleDependent_$ritem(); ~;
	}

	# Hidden "feature": jump directly to a tab by default via the URL bar.
	$INFO{'tab'} =~ s/\W//g;
	$default_tab = $INFO{'tab'} || $settings[0]->{'id'};
	$yymain .= qq~
  <div class="bordercolor" style="padding: 0px; width: 99%; margin-top: 1em; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2">
         <img src="$imagesdir/preferences.gif" alt="" border="0" /> <b>$admin_txt{'10'}</b>
       </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="center" class="catbg" colspan="2">
         <input class="button" type="submit" value="$admin_txt{'10'}" />
       </td>
     </tr>
   </table>
  </div>
  </form>
  <script type="text/javascript">
  <!--
	function getElementsByClass(searchClass,node,tag) {
		var classElements = new Array();
		if ( node == null )
			node = document;
		if ( tag == null )
			tag = '*';
		var els = node.getElementsByTagName(tag);
		var elsLen = els.length;
		var pattern = new RegExp('(^|\\s)'+searchClass+'(\\s|\$)');
		for (i = 0, j = 0; i < elsLen; i++) {
			if ( pattern.test(els[i].className) ) {
				classElements[j] = els[i];
				j++;
			}
		}
		return classElements;
	}
	function changeToTab(tab) {
		var elements = getElementsByClass('section');
		var i;
		for(i = 0; i < elements.length; i++) {
			if(elements[i].id == 'tab_' + tab) {
				elements[i].style.display = '';
			}
			else {
				elements[i].style.display = 'none';
			}
		}
		var elm = getElementsByClass('curtab')[0];
		if(elm) {
			elm.className = '';
		}
		document.getElementById('button_' + tab).className = 'curtab';
	}
	var removables = getElementsByClass('js_remove_me');
	var i;
	for(i = 0; i < removables.length; i++) {
		removables[i].innerHTML = '';
	}
	changeToTab('$default_tab'); // Focus default tab
	function checkDependent(eid) {
		var elm = document.getElementsByName(eid)[0];
		~;

		# Loop through each item that depends on something else
		foreach my $name (keys(%requirejs)) {
			my $logic = $requirejs{$name};
			$logic    =~ s/ && $//;
			$yymain .= qq~if(eid == "$name" && $logic) {
			elm.disabled = false;
		}
		else {
			if(eid == "$name") {
				elm.disabled = true;
			}
		}
		~;
		}

	$yymain.= qq~
	}
$dependicies
	window.onload = function(){ $onloadevents};
	function undisableAll(node) {
		var elements = document.getElementsByTagName("input");
		for(var i = 0; i < elements.length; i++) {
			elements[i].disabled = false;
		}
		var elements = document.getElementsByTagName("textarea");
		for(var i = 0; i < elements.length; i++) {
			elements[i].disabled = false;
		}
		var elements = document.getElementsByTagName("select");
		for(var i = 0; i < elements.length; i++) {
			elements[i].disabled = false;
		}
	}
  // -->
  </script>~;

	$action_area = "newsettings;page=$page";
	&AdminTemplate;
}

sub ischecked {
	# Return a ref so we can be used like ${ischecked($var)} inside a string
	return \' checked="checked"' if $_[0];
	return \'';
}

sub isselected {
	# Return a ref so we can be used like ${isselected($var)} inside a string
	return \' selected="selected"' if $_[0];
	return \'';
}

# Regexes. Will be used like this: $var =~ /^(?:$regexes{'a'}|$regexes{'b'}|$regexes{'c'})$/ || die;
my %regexes = (
boolean     => '.*', # anything. True is not 0 and defined, false is 0/undefined
number      => '\d+', # just numbers
fullnumber  => '(?:\+|\-|)[\d\.]+', # optional sign, plus numbers and decimal
hexadecimal => '#?[0-9a-fA-F]+', # optional "#" (for hex color codes), plus hex characters
alpha       => '[a-zA-Z]+', # Letters
text        => '[^\n\r]+', # Anything but newlines
fulltext    => '(?s).+', # Anything, including newlines
null        => '', # Use this if something can be false, in addition to the normal valid characters (not needed for boolean)
);

# Preserve the traditional "2" name as well as the nicer SaveSettings.
sub settings2 {
	&is_admin_or_gmod;

	# Load/Verify the settings
	foreach my $tab (@settings) {
		foreach my $item (@{$tab->{'items'}}) {
			# Get the value
			my $name = $item->{'name'} || next; # Skip non-items
			$settings{$name} = $FORM{$name};
			$settings{$name} = '' unless defined $settings{$name};

			$settings{$name} =~ s/^\s+//;
			$settings{$name} =~ s/\s+$//;

			# Validate it
			if($item->{'validate'}) {
				# Handle numbers/nulls better (empty string is 0)
				if ($item->{'validate'} =~ /null/ && $item->{'validate'} =~ /number|fullnumber/) { $settings{$name} ||= 0; }
				# Handle text/nulls better (empty string is empty string :)
				if ($item->{'validate'} =~ /null/ && $item->{'validate'} =~ /text|fulltext/) { $settings{$name} ||= ''; }
				# Piece together the patterns. It only needs to validate 1 pattern, but the pattern must be the whole string.
				my $pattern = '^(?:' . join('|', @regexes{split(/,/, $item->{'validate'})}) . ')$';
				&admin_fatal_error('invalid_value', qq~$name ($item->{'description'})~) unless $settings{$name} =~ /$pattern/;

				# Set numeric options to 0 if they are null
				if($item->{'validate'} eq 'boolean') {
					$settings{$name} ||= 0;
					$settings{$name} = 1 if $settings{$name};
				}
			}
		}
	}

	# Save them, as according to this type of settings
	# This subroutine resides in the file that is loaded in the hash at the top of the file.
	&SaveSettings(%settings);

	# Redirect.
	$yySetLocation = "$adminurl?action=newsettings;page=$page";
	&redirectexit;
}

# Subroutine for saving to Settings.pl and advsettings.txt
sub SaveSettingsTo {
	my $file     = shift;
	my %settings = @_;

	# This is why we should use hashes for options to begin with.
	foreach my $key (keys(%settings)) {
		$$key = delete($settings{$key});
		# Sanitize the input using \Q...\E later.
	}
	
	if ($codemaxchars > 15) { $codemaxchars = 15; }

	my $setfile;
	if($file eq 'Settings.pl') {
		# Since these are normally in a hash, fix that here
		$fadertext       ||= $color{'fadertext'};
		$faderbackground ||= $color{'faderbg'};

		$setfile = << "EOF";
###############################################################################
# Settings.pl                                                                 #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2 Release                                            #
# Packaged:       June 28, 2007                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2007 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

########## Board Info ##########
# Note: these settings must be properly changed for YaBB to work

\$maintenance = $maintenance;				# Set to 1 to enable Maintenance mode
\$maintenancetext = "\Q$maintenancetext\E";		# User-defined text for Maintenance mode (leave blank for default text)

\$guestaccess = $guestaccess;				# Set to 0 to disallow guests from doing anything but login or register

\$mbname = "\Q$mbname\E";				# The name of your YaBB forum
\$forumstart = "\Q$forumstart\E";			# The start date of your YaBB Forum
\$Cookie_Length = $Cookie_Length;			# Default minutes to set login cookies to stay for
\$cookieusername = "\Q$cookieusername\E";		# Name of the username cookie
\$cookiepassword = "\Q$cookiepassword\E";		# Name of the password cookie
\$cookiesession_name = "\Q$cookiesession_name\E";	# Name of the Session cookie

\$regtype = $regtype;					# 0 = registration closed (only admin can register), 1 = pre registration with admin approval, 
							# 2 = pre registration and email activation, 3 = open registration
\$RegAgree = $RegAgree;					# Set to 1 to display the registration agreement when registering
\$RegReasonSymbols = $RegReasonSymbols;			# Maximum allowed symbols in User reason(s) for registering
\$preregspan = $preregspan;				# Time span in hours for users to account activation before cleanup
\$emailpassword = $emailpassword;			# 0 - instant registration. 1 - password emailed to new members
\$emailnewpass = $emailnewpass;				# Set to 1 to email a new password to members if they change their email address
\$emailwelcome = $emailwelcome;				# Set to 1 to email a welcome message to users even when you have mail password turned off
\$name_cannot_be_userid = $name_cannot_be_userid;	# Set to 1 to require users to have different usernames and display names

\$lang = "\Q$lang\E";					# Default Forum Language
\$default_template = "\Q$default_template\E";		# Default Forum Template

\$mailprog = "\Q$mailprog\E";				# Location of your sendmail program
\$smtp_server = "\Q$smtp_server\E";			# Address of your SMTP-Server
\$smtp_auth_required = $smtp_auth_required;		# Set to 1 if the SMTP server requires Authorisation
\$authuser = "\Q$authuser\E";				# Username for SMTP authorisation
\$authpass = "\Q$authpass\E";				# Password for SMTP authorisation
\$webmaster_email = "\Q$webmaster_email\E";		# Your email address. (eg: \$webmaster_email = q^admin\@host.com^;)
\$mailtype = $mailtype;					# Mail program to use: 0 = sendmail, 1 = SMTP, 2 = Net::SMTP

########## Layout ##########

\$MenuType = $MenuType;					# 1 for text menu or anything else for images menu
\$profilebutton = $profilebutton;			# 1 to show view profile button under post, or 0 for blank
\$allow_hide_email = $allow_hide_email;			# Allow users to hide their email from public. Set 0 to disable
\$buddyListEnabled = $buddyListEnabled;			# Enable Buddy List
\$addmemgroup_enabled = $addmemgroup_enabled;		#Enable Users choose additional MemberGroups
\$showlatestmember = $showlatestmember;			# Set to 1 to display "Welcome Newest Member" on the Board Index
\$shownewsfader = $shownewsfader;			# 1 to allow or 0 to disallow NewsFader javascript
\$Show_RecentBar = $Show_RecentBar;			# Set to 1 to display the Recent Post on Board Index
\$showmodify = $showmodify;				# Set to 1 to display "Last modified: Realname - Date" under each message
\$ShowBDescrip = $ShowBDescrip;				# Set to 1 to display board descriptions on the topic (message) index for each board
\$showuserpic = $showuserpic;				# Set to 1 to display each member's picture in the message view (by the ICQ.. etc.)
\$showusertext = $showusertext;				# Set to 1 to display each member's personal text in the message view (by the ICQ.. etc.)
\$showtopicviewers = $showtopicviewers;			# Set to 1 to display members viewing a topic
\$showtopicrepliers = $showtopicrepliers;		# Set to 1 to display members replying to a topic
\$showgenderimage = $showgenderimage;			# Set to 1 to display each member's gender in the message view (by the ICQ.. etc.)
\$showyabbcbutt = $showyabbcbutt;			# Set to 1 to display the yabbc buttons on Posting and IM Send Pages
\$nestedquotes = $nestedquotes;				# Set to 1 to allow quotes within quotes (0 will filter out quotes within a quoted message)
\$parseflash = $parseflash;				# Set to 1 to parse the flash tag
\$enableclicklog = $enableclicklog;			# Set to 1 to track stats in Clicklog (this may slow your board down)

########## Feature Settings ##########

\$enable_ubbc = $enable_ubbc;				# Set to 1 if you want to enable UBBC (Uniform Bulletin Board Code)
\$enable_news = $enable_news;				# Set to 1 to turn news on, or 0 to set news off
\$allowpics = $allowpics;				# set to 1 to allow members to choose avatars in their profile
\$enable_guestposting = $enable_guestposting;		# Set to 0 if do not allow 1 is allow.
\$guest_media_disallowed = $guest_media_disallowed;	# disallow browsing guests to see media files or have clickable auto linked urls in messages.
\$enable_guestlanguage = $enable_guestlanguage;		# allow browsing guests to select their language  - requires more than one language pack! - Set to 0 if do not allow 1 is allow.

\$enable_notification = $enable_notification;		# Allow e-mail notification
\$autolinkurls = $autolinkurls;				# Set to 1 to turn URLs into links, or 0 for no auto-linking.

\$timeselected = $timeselected;				# Select your preferred output Format of Time and Date
\$timecorrection = $timecorrection;			# Set time correction for server time in seconds
\$timeoffset = $timeoffset;				# Time Offset to GMT/UTC (0 for GMT/UTC)
\$dstoffset = $dstoffset;				# Time Offset (for daylight savings time, 0 to disable DST)
\$TopAmmount = $TopAmmount;				# No. of top posters to display on the top members list
\$maxdisplay = $maxdisplay;				# Maximum of topics to display
\$maxfavs = $maxfavs;					# Maximum of favorite topics to save in a profile
\$maxrecentdisplay = $maxrecentdisplay;			# Maximum of topics to display on recent posts by a user (-1 to disable)
\$maxsearchdisplay = $maxsearchdisplay;			# Maximum of messages to display in a search query  (-1 to disable search)
\$maxmessagedisplay = $maxmessagedisplay;		# Maximum of messages to display
\$showpageall = $showpageall;		# Disable or Enable show All on page selectors
\$set_subjectMaxLength = $set_subjectMaxLength;		# Maximum Allowed Characters in a Posts Subject
\$MaxMessLen = $MaxMessLen;  				# Maximum Allowed Characters in a Posts
\$speedpostdetection = $speedpostdetection;  		# Set to 1 to detect speedposters and delay their spam actions
\$spd_detention_time = $spd_detention_time;  		# Time in seconds before a speedposting ban is lifted again
\$min_post_speed = $min_post_speed;  			# Minimum time in seconds between entering a post form and submitting a post
\$minlinkpost = $minlinkpost; 	 			# Minimum amount of posts a member needs to post links and images
\$post_speed_count = $post_speed_count;  		# Maximum amount of abuses befor a user gets banned
\$fontsizemin = $fontsizemin;  				# Minimum Allowed Font height in pixels
\$fontsizemax = $fontsizemax;  				# Maximum Allowed Font height in pixels
\$MaxSigLen = $MaxSigLen;				# Maximum Allowed Characters in Signatures
\$ClickLogTime = $ClickLogTime;				# Time in minutes to log every click to your forum (longer time means larger log file size)
\$max_log_days_old = $max_log_days_old;			# If an entry in the user's log is older than ... days remove it
							# Set to 0 if you want it disabled

\$maxsteps = $maxsteps;					# Number of steps to take to change from start color to endcolor
\$stepdelay = $stepdelay;				# Time in miliseconds of a single step
\$fadelinks = $fadelinks;				# Fade links as well as text?

\$color{'fadertext'}  = "\Q$fadertext\E";		# Color of text in the NewsFader (news color)
\$color{'faderbg'}  = "\Q$faderbackground\E";		# Color of background in the NewsFader (news color)
\$defaultusertxt = "\Q$defaultusertxt\E";		# The dafault usertext visible in users posts
\$timeout = $timeout;					# Minimum time between 2 postings from the same IP
\$HotTopic = $HotTopic;					# Number of posts needed in a topic for it to be classed as "Hot"
\$VeryHotTopic = $VeryHotTopic;				# Number of posts needed in a topic for it to be classed as "Very Hot"

\$barmaxdepend = $barmaxdepend;				# Set to 1 to let bar-max-length depend on top poster or 0 to depend on a number of your choise
\$barmaxnumb = $barmaxnumb;				# Select number of post for max. bar-length in memberlist
\$defaultml = "\Q$defaultml\E";

\$ML_Allowed = $ML_Allowed;				# allow browse MemberList

########## MemberPic Settings ##########

\$userpic_width = $userpic_width;			# Set pixel size to which the selfselected userpics are resized, 0 disables this limit
\$userpic_height = $userpic_height;			# Set pixel size to which the selfselected userpics are resized, 0 disables this limit

########## File Settings ##########

\$enable_freespace_check = $enable_freespace_check;	# Enable the free disk space check on every pageview?
\$gzcomp = $gzcomp;					# GZip compression: 0 = No Compression, 1 = External gzip, 2 = Zlib::Compress
\$gzforce = $gzforce;					# Don't try to check whether browser supports GZip
\$cachebehaviour = $cachebehaviour;			# Browser Cache Control: 0 = No Cache must revalidate, 1 = Allow Caching
\$use_flock = $use_flock;				# Set to 0 if your server doesn't support file locking,
							# 1 for Unix/Linux and WinNT, and 2 for Windows 95/98/ME

\$faketruncation = $faketruncation;			# Enable this option only if YaBB fails with the error:
							# "truncate() function not supported on this platform."
							# 0 to disable, 1 to enable.

\$debug = $debug;					# If set to 1 debug info is added to the template
							# tags are <yabb fileactions> and <yabb filenames>
1;
EOF
	}
	elsif($file eq 'advsettings.txt') {
			$setfile = << "EOF";
###############################################################################
# AdvSettings.txt                                                             #
###############################################################################

########## RSS Settings ##########

\$rss_disabled = $rss_disabled;		# Set to 1 to disable the RSS feed
\$rss_limit = $rss_limit;		# Maximum number of topics in the feed
\$rss_message  = $rss_message;		# Message to display in the feed
					# 0: None
					# 1: Latest Post
					# 2: Original Post in the topic
\$showauthor = $showauthor;		# Show author name
\$showdate = $showdate;		# Show post date

########## In-Thread Multi Delete ##########

\$mdadmin = $mdadmin;
\$mdglobal = $mdglobal;
\$mdmod = $mdmod;
\$adminbin = $adminbin;					# Skip recycle bin step for admins and delete directly

########## Moderation Update ##########

\$adminview = $adminview;				# Multi-admin settings for Administrators: 0=none, 1=icons 2=single checkbox 3=multiple checkboxes
\$gmodview = $gmodview;					# Multi-admin settings for Global Moderators: 0=none, 1=icons 2=single checkbox 3=multiple checkboxes
\$modview = $modview;					# Multi-admin settings for Moderators: 0=none, 1=icons 2=single checkbox 3=multiple checkboxes

########## Advanced Memberview Plus ###########

\$showallgroups = $showallgroups;
\$OnlineLogTime = $OnlineLogTime;

######### Polls ###########

\$numpolloptions = $numpolloptions;  			# Number of poll options
\$maxpq = $maxpq;  					# Maximum Allowed Characters in a Poll Qestion?
\$maxpo = $maxpo;  					# Maximum Allowed Characters in a Poll Option?
\$maxpc = $maxpc;  					# Maximum Allowed Characters in a Poll Comment?
\$useraddpoll = $useraddpoll;  				# Allow users to add polls to existing threads? (1 = yes)
\$ubbcpolls = $ubbcpolls;  				# Allow UBBC tags and smilies in polls? (1 = yes)

########## My Center and Private Messaging Features ############

\$PM_level = $PM_level;					# minimum user level for private messaging: 0 = off, 1 = members, 2 = mods, 3 = gmod
\$PMenableGuestButton = $PMenableGuestButton;		# enable 'pm to admin' for guests? 1=yes  0=no. Appears on the general menu instead of 'my center'
\$PMenableAlertButton = $PMenableAlertButton;		# enable 'alert moderator' button on thread view? 1=yes 0=no. Acts as a broadcast message to mods etc.
\$PMAlertButtonGuests = $PMAlertButtonGuests;		# enable 'alert moderator' button for Guests
\$enable_PMsearch = $enable_PMsearch;			#enable/max returns for PM search - 0 = off / 10 - 50 range for results

\$send_welcomeim = $send_welcomeim;			# enable auto-welcome message from forum to new member.  1=yes  0=no
\$sendname = "\Q$sendname\E";				# username 'from' for welcome message. Defaults to fa.
\$imsubject = "\Q$imsubject\E";				# title of welcome message.
\$imtext = "\Q$imtext\E";				# message sent to new member

\$numposts = $numposts;					# Number of posts required to send Instant Messages
\$imspam = $imspam;					# Percent of Users a user is a allowed to send a message at once

\$enable_imlimit = $enable_imlimit;			# Set to 1 to enable limitation of incoming and outgoing im messages
\$numibox = $numibox;					# Number of maximum Messages in the IM-Inbox
\$numobox = $numobox;					# Number of maximum Messages in the IM-Outbox
\$numstore = $numstore;					# Number of maximum Messages in the Storage box
\$numdraft = $numdraft;					# Number of maximum Messages in the draft box

\$PMenable_cc = $PMenable_cc;				# enable cc for PM posting 1 yes  0 no
\$PMenable_bcc = $PMenable_bcc;				# enable bcc for PM posting 1 yes  0 no
\$PMenableBm_level = $PMenableBm_level;			# minimum level to send? 0 = off, 1 = mods, 2 = gmod, 3 = admin

\$enable_storefolders = $enable_storefolders;		# enable additonal store folders - in/out are default for all    0=no > 1 = number, max 25

\$enable_YaBBBut = $enable_YaBBBut;			# enable YABBC Buttons on post page?  1=yes  0=no
\$enable_PMcontrols = $enable_PMcontrols;		# enable extended controls for members?  1=yes  0=no  if off, use the following instead
\$enable_PMprev = $enable_PMprev;			# enable preview button
\$enable_PMActprev = $enable_PMActprev;			# enable active preview
\$enable_PMviewMess = $enable_PMviewMess;		# enable message body suppress in list view

\$enable_PMpostAlert = $enable_PMpostAlert;		# enable PM post alerts instead of emails
\$enable_PMautoAway = $enable_PMautoAway;		# enable PM 'away' auto reply for inbox.
\$enable_MCaway = $enable_MCaway;			# enable 'away' indicator 0=Off 1=Staff to Staff 2=Staff to all 3=Members
\$MaxAwayLen = $MaxAwayLen; 				# maximum allowed characters in Away message
\$enable_MCstatusStealth = $enable_MCstatusStealth;	# enable 'stealth' mode for fa/gmods. Allows status label to stay at offline/away for all members viewing.

######### Topic Summary Cutter #############

\$cutamount = $cutamount;				# Number of posts to list in topic summary
\$tsreverse = $tsreverse;				# Reverse Topic Summaries (most recent becomes first)

############## Time Lock ###################

\$tlnomodflag = $tlnomodflag;				# Set to 1 limit time users may modify posts
\$tlnomodtime = $tlnomodtime;				# Time limit on modifying posts (days)
\$tlnodelflag = $tlnodelflag;				# Set to 1 limit time users may delete posts
\$tlnodeltime = $tlnodeltime;				# Time limit on deleting posts (days)
\$tllastmodflag = $tllastmodflag;			# Set to 1 allow users to modify posts up to the specified time limit w/o showing "last Edit" message
\$tllastmodtime = $tllastmodtime;			# Time limit to modify posts w/o triggering "last Edit" message (in minutes)

############## Permalinks ###################

\$accept_permalink = $accept_permalink;			# Set to 1 to have the board accept permalink alike environment strings
\$symlink = "\Q$symlink\E";				# The part defined in .htaccess redirection rules that is between domainname and permalink
\$perm_spacer = "\Q$perm_spacer\E";			# The character used in the permalink output file that replaces the space.
\$perm_domain = "\Q$perm_domain\E";			# The full domainname (no http://) where the .haccess redirect is set on.

########## bypass post for locked thread
\$bypass_lock_perm = "\Q$bypass_lock_perm\E";		# set level of permission - fa / fa+gmod / fa+gmod+mod; '' if disabled


########## File Attachment Settings ##########

\$limit = $limit;  					# Set to the maximum number of kilobytes an attachment can be. Set to 0 to disable the file size check.
\$dirlimit = $dirlimit;  				# Set to the maximum number of kilobytes the attachment directory can hold. Set to 0 to disable the directory size check.
\$overwrite = $overwrite;				# Set to 0 to auto rename attachments if they exist, 1 to overwrite them or 2 to generate an error if the file exists already.
\@ext = qw(@ext);  					# The allowed file extensions for file attachements. Variable should be set in the form of "jpg bmp gif" and so on.
\$checkext = $checkext;  				# Set to 1 to enable file extension checking, set to 0 to allow all file types to be uploaded
\$amdisplaypics = $amdisplaypics;  			# Set to 1 to display attached pictures in posts, set to 0 to only show a link to them.
\$allowattach = $allowattach;				# Set to 1 to allow file attaching, set to 0 to disable file attaching.
\$allowguestattach = $allowguestattach;			# Set to 1 to allow guests to upload attachments, 0 to disable guest attachment uploading.

############# Error Logger #################

\$elmax  = $elmax;					# Max number of log entries before rotation
\$elenable = $elenable;					# allow for error logging
\$elrotate = $elrotate;					# Allow for log rotation

1;
EOF
	}
	elsif($file eq 'secsettings.txt') {
		if (length $masterkey < 8 || length $masterkey > 24) {
			&LoadLanguage('Error');
			&fatal_error("invalid_key");
		}
		$setfile = <<"EOF";
###############################################################################
# SecSettings.txt                                                             #
###############################################################################

\$regcheck = $regcheck;					# Set to 1 if you want to enable automatic flood protection enabled
\$gpvalid_en = $gpvalid_en;				# Set to 1 if you want to enable validation code on guest posting
\$codemaxchars = $codemaxchars;				# Set max length of validation code (15 is max)
\$captchastyle = "\Q$captchastyle\E";			# Set L = lowercase only, U = uppercase only, A = both upper and lowercase letters
\$rgb_foreground = "\Q$rgb_foreground\E";		# Set hex RGB value for validation image foreground color
\$rgb_shade = "\Q$rgb_shade\E";				# Set hex RGB value for validation image shade color
\$rgb_background = "\Q$rgb_background\E";		# Set hex RGB value for validation image background color
\$translayer = $translayer;				# Set to 1 background for validation image should be transparent
\$randomizer = $randomizer;				# Set 0 to 3 to create background random noise based on foreground or shade color or both
\$distortion = $distortion;				# Set 1 to distort the captcha image even more
\$stealthurl = $stealthurl;				# Set to 1 to mask referer url to hosts if a hyperlink is clicked.
\$do_scramble_id = $do_scramble_id;			# Set to 1 scambles all visible links containing user ID's
\$referersecurity = $referersecurity;			# Set to 1 to activate referer security checking.
\$sessions = $sessions;					# Set to 1 to activate session id protection.
\$show_online_ip_admin = $show_online_ip_admin;		# Set to 1 to show online IP's to admins.
\$show_online_ip_gmod = $show_online_ip_gmod;		# Set to 1 to show online IP's to global moderators.
\$masterkey = "\Q$masterkey\E";				# Seed for encryption of captcha's

1;
EOF
	}
	else {
		# This should only be seen by developers.
		# If you get this, then you've typoed $file
		# or tried to write to one that isn't implemented here.
		die "I don't know how to write to this file.";
	}
	WriteSettingsTo("$vardir/$file", $setfile);
}

# Subroutine for writing the common format of settings file
sub WriteSettingsTo {
	my($file, $setfile) = @_;
	# Fix a certain type of syntax error
	$setfile =~ s~\=\s+\;~= '';~g;

	# Make it look nicely aligned.
	my $filler  = ' ' x 70;
	$setfile =~ s~(.+\;)\s+(\#.+$)~$1 . substr( $filler, 0, (70-(length $1)) ) . $2 ~gem;
	$setfile =~ s~(.{64,}\;)\s+(\#.+$)~$1 . "\n   " . $2~gem;
	$setfile =~ s~^\s\s\s+(\#.+$)~substr( $filler, 0, 70 ) . $1~gem;
	
	# Write it out
	fopen(SETTINGS, ">$file") || &fatal_error('cannot_open', $file, 1);
	print SETTINGS $setfile;
	fclose(SETTINGS);
}

1;
