###############################################################################
# Attachments.pl							                                                #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$attachmentsplver = 'YaBB 2.2.1 $Revision: 1.13.2.4 $';
if ($action eq 'detailedversion') { return 1; }

sub Attachments {
	&is_admin_or_gmod;

	fopen(AMS, "$vardir/attachments.txt");
	my @attachments = <AMS>;
	fclose(AMS);
	my $totalattachnum = @attachments;

	foreach $line (@attachments) {
		chomp $line;
		my $fsize= (split /\|/, $line)[5];
		$attachment_space += $fsize;
	}
	if (!$attachment_space) { $attachment_space = 0; }
	if ($dirlimit != 0) {
		my $spaceleft = ($dirlimit - $attachment_space);
		$remaining_space = "$spaceleft KB";
	} else {
		$remaining_space = "$fatxt{'23'}";
	}
	fopen(FILE, "$vardir/oldestattach.txt");
	$maxdaysattach = <FILE>;
	fclose(FILE);
	fopen(FILE, "$vardir/maxattachsize.txt");
	$maxsizeattach = <FILE>;
	fclose(FILE);
	$yymain .= qq~
<table border="0" width="70%" cellspacing="1" cellpadding="3" class="bordercolor" align="center">
<tr>
<td class="titlebg">
<img src="$imagesdir/xx.gif" alt="" />
<b>$fatxt{'24'}</b></td>
</tr><tr>
<td class="windowbg"><br /><span class="small">$fatxt{'25'}</span><br /><br /></td>
</tr><tr>
<td width="460" class="catbg"><b>$fatxt{'26'}</b></td>
</tr><tr>
<td class="windowbg" height="21">
<b>$fatxt{'27'}</b><br /></td>
</tr><tr>
<td class="windowbg2">
<table border="0" cellpadding="3" cellspacing="0"><tr>
<td><span class="small"><b>$fatxt{'28'}</b></span></td>
<td><span class="small">$totalattachnum</span></td>
</tr><tr>
<td><span class="small"><b>$fatxt{'29'}</b></span></td>
<td><span class="small">$attachment_space KB</span><br /></td>
</tr><tr>
<td><span class="small"><b>$fatxt{'30'}</b></span></td>
<td><span class="small">$remaining_space</span></td>
</tr>
</table><br />
</td>
</tr><tr>
<td class="windowbg" height="21">
<b>$fatxt{'31'}</b><br /></td>
</tr><tr>
<td class="windowbg2">
<table border="0" cellpadding="3" cellspacing="0">
<tr>
<form action="$adminurl?action=removeoldattachments" method="post">
<td><span class="small">$fatxt{'32'}</span></td>
<td><span class="small"><input type="text" name="maxdaysattach" size="2" value="$maxdaysattach" /> $fatxt{'58'}&nbsp;</span></td>
<td><input type="submit" value="$admin_txt{'32'}" class="button" /></td>
</form>
</tr><tr>
<form action="$adminurl?action=removebigattachments" method="post">
<td><span class="small">$fatxt{'33'}</span></td>
<td><span class="small"><input type="text" name="maxsizeattach" size="2" value="$maxsizeattach" /> KB&nbsp;</span></td>
<td><input type="submit" value="$admin_txt{'32'}" class="button" /></td>
</form>
</tr><tr>
<td colspan="3"><span class="small" style="font-weight: bold;"><a href="$adminurl?action=manageattachments2">$fatxt{'31a'}</a></span> | <span class="small" style="font-weight: bold;"><a href="$adminurl?action=rebuildattach">$fatxt{'63'}</a></span></td>
</tr>
</table>
</td>
</tr>
</table>
~;
	$yytitle = "$fatxt{'36'}";
	$action_area = "manageattachments";
	&AdminTemplate;
	exit;
}

sub RemoveOldAttachments {
	&is_admin_or_gmod;
	fopen(FILE, ">$vardir/oldestattach.txt");
	print FILE "$FORM{'maxdaysattach'}";
	fclose(FILE);
	$date2 = $date;
	fopen(FILE, "$vardir/attachments.txt");
	@attachments = <FILE>;
	fclose(FILE);

	if (1 > @attachments) {
		$yymain .= qq~<center><b><i>$fatxt{'48'}</i></b></center>~;
	} else {
		fopen(FILE, ">$vardir/attachments.txt");
		for ($a = 0; $a < @attachments; $a++) {
			my (undef, undef, undef, undef, undef, undef, $tmpdate, $fn) = split(/\|/, $attachments[$a]);
			chomp $fn;
			$date1 = $tmpdate;
			&calcdifference;
			if ($result <= $FORM{'maxdaysattach'}) {
				# If the attachment is not too old
				print FILE $attachments[$a];
				$yymain .= qq~ $fn = $result $admin_txt{'122'}<br /> ~;
			} else {
				$yymain .= qq~ $fn = $result $admin_txt{'122'} ($admin_txt{'123'})<br /> ~;
				if (-e ("$uploaddir/$fn")) {
					unlink("$uploaddir/$fn");
				}
			}
		}
	}
	fclose(FILE);
	$yytitle     = "$fatxt{'34'} $FORM{'maxdaysattach'}";
	$action_area = "removeoldattachments";
	&AdminTemplate;
	exit;
}

sub RemoveBigAttachments {
	&is_admin_or_gmod;
	fopen(FILE, ">$vardir/maxattachsize.txt");
	print FILE "$FORM{'maxsizeattach'}";
	fclose(FILE);
	fopen(FILE, "$vardir/attachments.txt");
	@attachments = <FILE>;
	fclose(FILE);
	fopen(FILE, ">$vardir/attachments.txt");

	if (1 > @attachments) {
		$yymain .= qq~<center><b><i>$fatxt{'48'}</i></b></center>~;
	} else {
		for ($a = 0; $a < @attachments; $a++) {
			my (undef, undef, undef, undef, undef, $size, undef, $fn) = split(/\|/, $attachments[$a]);
			chomp $fn;
			if ($size <= $FORM{'maxsizeattach'}) {
				# If the attachment is not too big
				print FILE $attachments[$a];
				$yymain .= qq~ $fn = $size KB<br /> ~;
			} else {
				$yymain .= qq~ $fn = $size KB ($admin_txt{'123'})<br /> ~;
				if (-e ("$uploaddir/$fn")) {
					unlink("$uploaddir/$fn");
				}
			}
		}
	}
	fclose(FILE);
	$yytitle = "$fatxt{'35'} $FORM{'maxsizeattach'} KB";
	$action_area = "removebigattachments";
	&AdminTemplate;
	exit;
}

sub Attachments2 {
	&is_admin_or_gmod;

	fopen(AML, "$vardir/attachments.txt");
	my @attachments = <AML>;
	$delnum = 1;
	fclose(AML);
	$attachcount = @attachments;

	my $action = $INFO{'action'};
	my $newstart = $INFO{'newstart'} || 0;

	if (1 > @attachments) {
		$viewattachments .= qq~<tr><td class="windowbg2" colspan="6"><center><b><i>$fatxt{'48'}</i></b></center></td></tr>~;
	} else {

		$viewattachments .= qq~

		<script language="JavaScript1.2" type="text/javascript">
		<!--
			function checkAll() {
  				for (var i = 0; i < document.del_attachments.elements.length; i++) {
					document.del_attachments.elements[i].checked = true;
	  			}
			}
			function uncheckAll() {
  				for (var i = 0; i < document.del_attachments.elements.length; i++) {
					document.del_attachments.elements[i].checked = false;
	  			}
			}
		//-->
		</script>

		<form name="del_attachments" action="$adminurl?action=deleteattachment" method="post" style="display: inline;">
		~;

		$postdisplaynum = 8;
		$max = $attachcount;
		$newstart = (int($newstart / 25)) * 25;
		$tmpa = 1;
		if ($newstart >= (($postdisplaynum - 1) * 25)) { $startpage = $newstart - (($postdisplaynum - 1) * 25); $tmpa = int( $startpage / 25 ) + 1; }
		if ($max >= $newstart + ($postdisplaynum * 25)) { $endpage = $newstart + ($postdisplaynum * 25); } else { $endpage = $max }
		if ($startpage > 0) { $pageindex = qq~<a href="$adminurl?action=$action;newstart=0" style="font-weight: normal;">1</a>&nbsp;...&nbsp;~; }
		if ($startpage == 25) { $pageindex = qq~<a href="$adminurl?action=$action;newstart=0" style="font-weight: normal;">1</a>&nbsp;~;}
		for ($counter = $startpage; $counter < $endpage; $counter += 25) {
			$pageindex .= $newstart == $counter ? qq~<b>$tmpa</b>&nbsp;~ : qq~<a href="$adminurl?action=$action;newstart=$counter" style="font-weight: normal;">$tmpa</a>&nbsp;~;
			$tmpa++;
		}
		$lastpn = int($attachcount / 25) + 1;
		$lastptn = ($lastpn - 1) * 25;
		if ($endpage < $max - (25) ) { $pageindexadd = qq~...&nbsp;~; }
		if ($endpage != $max) { $pageindexadd .= qq~<a href="$adminurl?action=$action;newstart=$lastptn">$lastpn</a>~; }
		$pageindex .= $pageindexadd;

		$pageindex = qq~
		<tr>
			<td class="windowbg" colspan="6"><span class="small" style="float: left;">$fatxt{'64'}: $pageindex</span></td>
		</tr>
		~;
		
		$numbegin = ($newstart + 1);
		$numend = ($newstart + 25);
		if ($numend > $attachcount) { $numend  = $attachcount; }
		if ($attachcount == 0) { $numshow = ''; }
		else { $numshow = qq~($numbegin - $numend)~; }

		@attach = splice(@attachments, $newstart, 25);
		undef @attachments;

		foreach $row (@attach) {
			chomp $row;
			my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/, $row);
			$amdate = &timeformat($amdate);
			if (length($amthreadsub) > 20) { $amthreadsub = substr($amthreadsub, 0, 20) . "..."; }
			$viewattachments .= qq~
		<tr>
		<td class="windowbg2" align="left" valign="middle"><a href="$uploadurl/$amfn" target="blank"> $amfn</a></td>
		<td class="windowbg2" align="left" valign="middle"> $amkb KB</td>
		<td class="windowbg2" align="left" valign="middle"> $amposter</td>
		<td class="windowbg2" align="left" valign="middle"> $amdate</td>
		<td class="windowbg2" align="left" valign="middle"><a href="$scripturl?num=$amthreadid/$amreplies#$amreplies" target="blank"> $amthreadsub</a></td>
		<td class="windowbg2" align="center" valign="middle"><input type="checkbox" name="delattach$delnum" value="$amfn" /></td>
		</tr>\n~;
			$delnum++;
		}

		$viewattachments .= qq~
		$pageindex
		<tr>
		<td class="catbg" colspan="5" align="right">
		<input type="hidden" name="delnum" value="$delnum" />
		<input type="hidden" name="newstart" value="$newstart" />
		<input type="submit" value="$admin_txt{'32'}" class="button" /><span class="small">&nbsp; $amv_txt{'38'} &nbsp;</span>
		</td>
		<td class="catbg" align="center">
		<input type="checkbox" name="checkall" value="" onclick="if (this.checked) checkAll(); else uncheckAll();" />
		</td>
		</tr>
		</form>
		~;
	}

	$yymain .= qq~
<table border="0" cellspacing="1" cellpadding="3" class="bordercolor" align="center" width="90%">
<tr>
<td class="titlebg" colspan="6">
<img src="$imagesdir/xx.gif" alt="" border="0" />&nbsp;<b>$fatxt{'39'}</b>
</td>
</tr><tr>
<td class="windowbg" colspan="6">
<br />
<span class="small">$fatxt{'38'}</span>
<br /><br />
</td>
</tr>
<tr>
<td class="titlebg" colspan="6" align="center" width="100%"><b>$fatxt{'55'}</b></td>
</tr>
<tr>
<td class="titlebg" colspan="6" align="left" width="100%">
<span class="small">$fatxt{'28'} $attachcount $numshow</span>
</td>
</tr>
$pageindex
<tr>
<td class="catbg" align="center"><b>$fatxt{'40'}</b></td>
<td class="catbg" align="center"><b>$fatxt{'41'}</b></td>
<td class="catbg" align="center"><b>$fatxt{'42'}</b></td>
<td class="catbg" align="center"><b>$fatxt{'43'}</b></td>
<td class="catbg" align="center"><b>$fatxt{'44'}</b></td>
<td class="catbg" align="center"><b>$fatxt{'45'}</b></td>
</tr>
$viewattachments
</table>
~;
	$yytitle = "$fatxt{'37'}";
	$action_area = "manageattachments";
	&AdminTemplate;
	exit;
}

sub DeleteAttachments {
	&is_admin_or_gmod;
	my $delnumb = $FORM{"delnum"};
	fopen(AML, "$vardir/attachments.txt");
	my @attachments = <AML>;
	fclose(AML);
	fopen(AML, ">$vardir/attachments.txt");
	foreach $file (@attachments) {
		chomp $file;
		$att_found = 0;
		my ($amthreadid, $amreplies, $amthreadsub, $amposter, $amcurrentboard, $amkb, $amdate, $amfn) = split(/\|/, $file);
		for ($i = 1; $i < $delnumb; $i++) {
			my $attachment = $FORM{"delattach$i"};
			if (exists $FORM{"delattach$i"}) {
				if ($amfn eq $attachment) { $att_found = 1; }
			}
		}
		if ($att_found) {
			unlink("$uploaddir/$amfn");
		} else {
			print AML qq~$amthreadid|$amreplies|$amthreadsub|$amposter|$amcurrentboard|$amkb|$amdate|$amfn\n~;
		}
	}
	fclose(AML);
	$yySetLocation = qq~$adminurl?action=manageattachments2;newstart=$FORM{'newstart'}~;
	&redirectexit;
}

sub FullRebuildAttachents {

	&is_admin_or_gmod();
	
	&automaintenance('on');
	$action_area = 'manageattachments';
	$yytitle = "$fatxt{'37'}";

	$maxtime = 10;

	$topicnum = $INFO{'topicnum'};
	$board = $INFO{'boardnum'};

	unless(defined $INFO{'boardnum'}) {

		$yySetLocation = qq~$adminurl?action=rebuildattach;topicnum=0;boardnum=0~;
		&redirectexit();

	} else {
	
		my $begin_time = CORE::time;
		# Get the board list from the forum.master file
		require "$boardsdir/forum.master";
		@boardlist = sort keys(%board);

		# Find the current board:
		my $curboard = $boardlist[$board];
	
		# Get the topic list.
		fopen(BOARD, "$boardsdir/$curboard.txt");
		my @topiclist = <BOARD>;
		fclose(BOARD);
	
		# Just get the topic numbers
		foreach my $item (@topiclist) {
			my @temp = split(/\|/, $item, 2);
			$item = $temp[0];
		}

		for (my $i = $topicnum; $i < scalar @topiclist; $i++) {
			@newattachments = ();

			my %curtopic;
			fopen(TOPIC, "$datadir/$topiclist[$i].txt");
			my @topic = <TOPIC>;
			fclose(TOPIC);
			my $mreplies = 0;
			foreach my $line (@topic) {
				my ($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $postmessage, $ns, $mlm, $mlmb, $mfn) = split(/[\|]/, $line);
				chomp $mfn;
				if ($mfn ne '' && (-e ("$uploaddir/$mfn"))) {
					my $testtmpsize = int(((-s "$uploaddir/$mfn") / 1024) + 1);
					my $newattach = qq~$topiclist[$i]|$mreplies|$msub|$mname|$curboard|$testtmpsize|$mdate|$mfn\n~;
					push (@newattachments, $newattach);
				}
				$mreplies++;
			}
		
			fopen(AML, ">>$vardir/newattachments.txt");
			print AML @newattachments;
			fclose(AML);

			if (time > $begin_time + $maxtime) {
				$laststep = $i;
				last;
			}

		}

		# Prepare to continue...
		if ($laststep) { $topicnum = $laststep + 1; }
		else { $board++; $topicnum = 0; }

		$numleft = scalar @boardlist - $board;
		if ($numleft == 0) {
		
			fopen(AML, "<$vardir/newattachments.txt");
			my @attachments = <AML>;
			fclose(AML);

			@attachments = sort {(split /\|/,$a)[6] <=> (split /\|/,$b)[6]} @attachments;

			fopen (NEWFILE, ">$vardir/attachments.txt");
			seek NEWFILE, 0, 0;
			truncate NEWFILE, 0;
			print NEWFILE @attachments;
			fclose (NEWFILE);
			unlink "$vardir/newattachments.txt";		
		
			&automaintenance("off");
			$yySetLocation = qq~$adminurl?action=remghostattach~;
			&redirectexit;
		}

		# Continue
		$yymain .= qq~
			<div id="attachcontinued">
			<br />
			$rebuild_txt{'1'}
			$rebuild_txt{'5'} $numleft<br />
			$rebuild_txt{'2'} <a href="$adminurl?action=rebuildattach;topicnum=$topicnum;boardnum=$board" onclick="rebAttach();">$rebuild_txt{'3'}</a>
			</div>
			<script type="text/javascript" language="JavaScript">
			<!--
			var convtext = "$rebuild_txt{'4'}";
			function rebAttach() {
				document.getElementById("attachcontinued").innerHTML = convtext;
			}

		function attachtick() {
			rebAttach();
			location.href="$adminurl?action=rebuildattach;topicnum=$topicnum;boardnum=$board";
		}

		setTimeout("attachtick()",3000)
		// -->
		</script>
	~;
	&AdminTemplate();
	}

}


sub RemoveGhostAttach {
	&is_admin_or_gmod;

	$yymain .= qq~<b>$fatxt{'62'}</b><br /><br />~;

	fopen(AMS, "$vardir/attachments.txt");
	my @attachments = <AMS>;
	fclose(AMS);

	opendir(DIR, $uploaddir);
	my @filesDIR = readdir(DIR);
	close(DIR);
	
	$yymain .= qq~$fatxt{'61'}: ~;
	
	foreach my $fileinDIR (@filesDIR) {
		chomp $fileinDIR;
		if ($fileinDIR ne '.' && $fileinDIR ne '..') {
			$filefound = 0;
			foreach my $attach (@attachments) {
				chomp $attach;
				my $attachFILE = (split /\|/, $attach)[7];
				if ($attachFILE eq $fileinDIR) { $filefound = 1; last; }
			}
			if ($filefound == 0) { 
				unlink "$uploaddir/$fileinDIR" || &admin_fatal_error('cannot_open', "$uploaddir/$fileinDIR");
				$yymain .= qq~<br />$fatxt{'61b'} - $fileinDIR~;
			}
		}
	}
	
	$yymain .= qq~$fatxt{'61a'}~;

	$yytitle = $fatxt{'61'};
	$action_area = 'manageattachments';
	&AdminTemplate;
	exit;

}


1;
