###############################################################################
# AdminEdit.pl                                                                #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2.1                                                  #
# Packaged:       March 5, 2008                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2008 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

$admineditplver = 'YaBB 2.2.1 $Revision: 1.36.2.4 $';
if ($action eq 'detailedversion') { return 1; }

use File::Find;
&LoadLanguage('Register');

sub GmodSettings {
	&is_admin;

	&LoadLanguage('GModPriveleges');

	if (!-e ("$vardir/gmodsettings.txt")) { &GmodSettings2; }

	require "$vardir/gmodsettings.txt";

	if ($gmod_newfile eq '') { &GmodSettings2; }

	fopen(MODACCESS, "$vardir/gmodsettings.txt");
	@scriptlines = <MODACCESS>;
	fclose(MODACCESS);

	$startread = 0;
	$counter   = 0;
	foreach $scriptline (@scriptlines) {
		chomp $scriptline;
		if (substr($scriptline, 0, 1) eq "'") {
			$scriptline =~ s/newsettings\;page\=//;
			$scriptline =~ /\"(.*?)\"/;
			$allow = $1;
			$scriptline =~ /\'(.*?)\'/;
			$actionfound = $1;
			push(@actfound, $actionfound);
			push(@allowed,  $allow);
			$counter++;
		}
	}
	$column  = int($counter / 2);
	$counter = 0;
	$a       = 0;
	foreach $actfound (@actfound) {
		$checked = '';
		if ($allowed[$a] eq 'on') { $checked = ' checked="checked"'; }
		$dismenu .= qq~<input type="checkbox" name="$actfound"$checked />&nbsp;<img src="$imagesdir/question.gif" align="middle" alt="$reftxt{'1a'} $gmodprivexpl_txt{$actfound}" title="$reftxt{'1a'} $gmodprivexpl_txt{$actfound}" border="0" /> $actfound<br />\n~;
		$counter++;
		$a++;
		if ($counter > $column + 1) {
			$dismenu .= qq~</td><td align="left" class="windowbg2" valign="top" width="50%">~;
			$counter = 0;
		}
	}

	if ($allow_gmod_admin) { $gmod_selected_a = ' checked="checked"'; }
	if ($allow_gmod_profile) { 
		$gmod_selected_p = ' checked="checked"';
		if ($allow_gmod_aprofile) { $gmod_selected_ap = ' checked="checked"'; }
	} else {
		$gmod_selected_ap = ' disabled="disabled"';
	}

	$yymain .= qq~
<form action="$adminurl?action=gmodsettings2" method="post" enctype="application/x-www-form-urlencoded">
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2">
<img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$gmod_settings{'1'}</b>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2" colspan="2"><br />
<input type="checkbox" name="allow_gmod_admin"$gmod_selected_a /> $gmod_settings{'2'}<br />
<input type="checkbox" id="allow_gmod_profile" name="allow_gmod_profile"$gmod_selected_p onclick="depend(this.checked);" /> $gmod_settings{'3'}<br />
<input type="checkbox" id="allow_gmod_aprofile" name="allow_gmod_aprofile"$gmod_selected_ap /> $gmod_settings{'3a'}<br />
<br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="catbg" colspan="2">
		<span class="small">$gmod_settings{'4'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2" valign="top" width="50%">
		$dismenu
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg" colspan="2">
		<input type="submit" value="$reftxt{'4'}" class="button" />
	   </td>
     </tr>
   </table>
 </div>
</form>

<script type="text/javascript">
<!--
function depend(value) {
      if (value) {
		document.getElementById('allow_gmod_aprofile').disabled = false;
      } else {
      	document.getElementById('allow_gmod_aprofile').checked = false;
		document.getElementById('allow_gmod_aprofile').disabled = true;
      }
}
//-->
</script>

~;
	$yytitle     = "$gmod_settings{'1'}";
	$action_area = "gmodaccess";
	&AdminTemplate;
	exit;
}

sub EditBots {
	&is_admin_or_gmod;
	my ($line);
	$yymain .= qq~
<form action="$adminurl?action=editbots2" method="post" enctype="application/x-www-form-urlencoded">
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
<img src="$imagesdir/xx.gif" alt="" border="0" /><b>$admin_txt{'18'}</b>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
	<span class="small">
	$admin_txt{'19'}
	</span><br /><br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="windowbg2"><br />
	<textarea cols="70" rows="35" name="bots" style="width:98%">
~;
	fopen(BOTS, "$vardir/bots.hosts");
	while ($line = <BOTS>) { chomp $line; $yymain .= qq~$line\n~; }
	fclose(BOTS);
	$yymain .= qq~</textarea>
	<br /><br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="submit" value="$admin_txt{'10'}" class="button" />
	   </td>
     </tr>
   </table>
 </div>
</form>
~;
	$yytitle     = "$admin_txt{'18'}";
	$action_area = "editbots";
	&AdminTemplate;
	exit;
}

sub EditBots2 {
	&is_admin_or_gmod;
	$FORM{'bots'} =~ tr/\r//d;
	fopen(BOTS, ">$vardir/bots.hosts", 1);
	chomp $FORM{'bots'};
	print BOTS "$FORM{'bots'}";
	fclose(BOTS);
	$yySetLocation = qq~$adminurl~;
	&redirectexit;
}

sub SetCensor {
	&is_admin_or_gmod;
	my ($censorlanguage, $line);
	if ($FORM{'censorlanguage'}) { $censorlanguage = $FORM{'censorlanguage'} }
	else { $censorlanguage = $lang; }
	opendir(LNGDIR, $langdir);
	my @lfilesanddirs = readdir(LNGDIR);
	close(LNGDIR);

	foreach my $fld (sort {lc($a) cmp lc($b)} @lfilesanddirs) {
		if (-d "$langdir/$fld" && $fld =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^ && -e "$langdir/$fld/Main.lng") {
			if ($censorlanguage eq $fld) { $drawnldirs .= qq~<option value="$fld" selected="selected">$fld</option>~; }
			else { $drawnldirs .= qq~<option value="$fld">$fld</option>~; }
		}
	}

	my (@censored, $i);
	fopen(CENSOR, "$langdir/$censorlanguage/censor.txt");
	@censored = <CENSOR>;
	fclose(CENSOR);
	foreach $i (@censored) {
		$i =~ tr/\r//d;
		$i =~ tr/\n//d;
	}
	$yymain .= qq~
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
		 <img src="$imagesdir/ban.gif" alt="" border="0" /><span class="legend"><b>$admin_txt{'135'}</b></span>
       </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="windowbg2">
	<form action="$adminurl?action=setcensor" method="post" enctype="application/x-www-form-urlencoded">
	$templs{'7'}
	<select name="censorlanguage" id="censorlanguage" size="1">
		$drawnldirs
	</select>
	<input type="submit" value="$admin_txt{'462'}" class="button" />
	</form>
       </td>
     </tr>
   </table>
 </div>
 <br />
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <!-- Split for XHTML Validation purposes -->
   <form action="$adminurl?action=setcensor2" method="post" enctype="application/x-www-form-urlencoded">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
         $admin_txt{'136'}<br /><br />
       </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="windowbg2"><br />
	<input type="hidden" name="censorlanguage" value="$censorlanguage" />
	<textarea rows="35" cols="15" name="censored" style="width:90%">~;
	foreach $i (@censored) {
		unless ($i && $i =~ m/.+[\=~].+/) { next; }
		$yymain .= "$i\n";
	}
	$yymain .= qq~</textarea>
        <br /><br />
      </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg">
<input type="submit" value="$admin_txt{'10'} $censorlanguage" class="button" />
       </td>
     </tr>
   </table>
   </form>
 </div>
~;
	$yytitle     = "$admin_txt{'135'}";
	$action_area = "setcensor";
	&AdminTemplate;
	exit;
}

sub SetCensor2 {
	&is_admin_or_gmod;
	$FORM{'censored'} =~ tr/\r//d;
	$FORM{'censored'} =~ s~\A[\s\n]+~~;
	$FORM{'censored'} =~ s~[\s\n]+\Z~~;
	$FORM{'censored'} =~ s~\n\s*\n~\n~g;
	if ($FORM{'censorlanguage'}) { $censorlanguage = $FORM{'censorlanguage'}; }
	else { $censorlanguage = $lang; }
	my @lines = split(/\n/, $FORM{'censored'});
	fopen(CENSOR, ">$langdir/$censorlanguage/censor.txt", 1);

	foreach my $i (@lines) {
		$i =~ tr/\n//d;
		unless ($i && $i =~ m/.+[\=~].+/) { next; }
		print CENSOR "$i\n";
	}
	fclose(CENSOR);
	$yySetLocation = qq~$adminurl~;
	&redirectexit;
}

sub SetReserve {
	my (@reserved, @reservecfg, $i);
	&is_admin_or_gmod;
	fopen(RESERVE, "$vardir/reserve.txt");
	@reserved = <RESERVE>;
	fclose(RESERVE);
	fopen(RESERVECFG, "$vardir/reservecfg.txt");
	@reservecfg = <RESERVECFG>;
	fclose(RESERVECFG);
	for (my $i = 0; $i < @reservecfg; $i++) {
		chomp $reservecfg[$i];
		if($reservecfg[$i]) { $reservecheck[$i] = qq~ checked="checked"~; }
	}
	$yymain .= qq~
<form action="$adminurl?action=setreserve2" method="post" enctype="application/x-www-form-urlencoded">
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
<img src="$imagesdir/profile.gif" alt="" border="0" /><b>$admin_txt{'341'}</b>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		 $admin_txt{'699'}<br /><br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		 $admin_txt{'342'}<br /><br />
		 	<center>
	<textarea cols="40" rows="35" name="reserved" style="width:95%">
~;
	foreach $i (@reserved) {
		chomp $i;
		$i =~ s~\t~~g;
		if ($i !~ m~\A[\S|\s]*[\n\r]*\Z~) { next; }
		$yymain .= "$i\n";
	}
	$yymain .= qq~</textarea>
	</center>
<br /><br />
	<input type="checkbox" name="matchword" value="checked"$reservecheck[0] />
	$admin_txt{'726'}<br />
	<input type="checkbox" name="matchcase" value="checked"$reservecheck[1] />
	$admin_txt{'727'}<br />
	<input type="checkbox" name="matchuser" value="checked"$reservecheck[2] />
	$admin_txt{'728'}<br />
	<input type="checkbox" name="matchname" value="checked"$reservecheck[3] />
	$admin_txt{'729'}<br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="submit" value="$admin_txt{'10'}" class="button" />
	   </td>
     </tr>
   </table>
 </div>
</form>
~;
	$yytitle     = "$admin_txt{'341'}";
	$action_area = "setreserve";
	&AdminTemplate;
	exit;
}

sub SetReserve2 {
	&is_admin_or_gmod;
	$FORM{'reserved'} =~ tr/\r//d;
	$FORM{'reserved'} =~ s~\A[\s\n]+~~;
	$FORM{'reserved'} =~ s~[\s\n]+\Z~~;
	$FORM{'reserved'} =~ s~\n\s*\n~\n~g;
	fopen(RESERVE, ">$vardir/reserve.txt", 1);
	my $matchword = $FORM{'matchword'} eq 'checked' ? 'checked' : '';
	my $matchcase = $FORM{'matchcase'} eq 'checked' ? 'checked' : '';
	my $matchuser = $FORM{'matchuser'} eq 'checked' ? 'checked' : '';
	my $matchname = $FORM{'matchname'} eq 'checked' ? 'checked' : '';
	print RESERVE $FORM{'reserved'};
	fclose(RESERVE);
	fopen(RESERVECFG, "+>$vardir/reservecfg.txt");
	print RESERVECFG "$matchword\n";
	print RESERVECFG "$matchcase\n";
	print RESERVECFG "$matchuser\n";
	print RESERVECFG "$matchname\n";
	fclose(RESERVECFG);
	$yySetLocation = qq~$adminurl~;
	&redirectexit;
}

sub ModifyAgreement {
	&is_admin_or_gmod;
	my ($agreementlanguage, $line);
	if ($FORM{'agreementlanguage'}) {
		$agreementlanguage = $FORM{'agreementlanguage'};
	} else {
		$agreementlanguage = $lang;
	}
	opendir(LNGDIR, $langdir);
	my @lfilesanddirs = readdir(LNGDIR);
	close(LNGDIR);

	foreach my $fld (sort {lc($a) cmp lc($b)} @lfilesanddirs) {
		if (-d "$langdir/$fld" && $fld =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^ && -e "$langdir/$fld/Main.lng") {
			if ($agreementlanguage eq $fld) { $drawnldirs .= qq~<option value="$fld" selected="selected">$fld</option>~; }
			else { $drawnldirs .= qq~<option value="$fld">$fld</option>~; }
		}
	}

	my ($fullagreement, $line);
	fopen(AGREE, "$langdir/$agreementlanguage/agreement.txt");
	while ($line = <AGREE>) {
		$line =~ tr/[\r\n]//d;
		&FromHTML($line);
		$fullagreement .= qq~$line\n~;
	}
	fclose(AGREE);
	$yymain .= qq~

 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
<img src="$imagesdir/xx.gif" alt="" border="0" /><b>$admin_txt{'764'}</b>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		$admin_txt{'765'}<br /><br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
	<form action="$adminurl?action=modagreement" method="post" enctype="application/x-www-form-urlencoded">
	$templs{'8'}
	<select name="agreementlanguage" id="agreementlanguage" size="1">
		$drawnldirs
	</select>
	<input type="submit" value="$admin_txt{'462'}" class="button" />
	</form>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="windowbg2"><br />
	<form action="$adminurl?action=modagreement2" method="post" enctype="application/x-www-form-urlencoded">
	<input type="hidden" name="agreementlanguage" value="$agreementlanguage" />
	<textarea rows="35" cols="95" name="agreement" style="width:95%">$fullagreement</textarea><br /><br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="submit" value="$admin_txt{'10'} $agreementlanguage" class="button" />
	   </td>
     </tr>
	</form>
   </table>
 </div>
~;
	$yytitle     = "$admin_txt{'764'}";
	$action_area = "modagreement";
	&AdminTemplate;
	exit;
}

sub ModifyAgreement2 {
	&is_admin_or_gmod;
	if ($FORM{'agreementlanguage'}) { $agreementlanguage = $FORM{'agreementlanguage'}; }
	else { $agreementlanguage = $lang; }
	$FORM{'agreement'} =~ tr/\r//d;
	$FORM{'agreement'} =~ s~\A\n~~;
	$FORM{'agreement'} =~ s~\n\Z~~;
	fopen(AGREE, ">$langdir/$agreementlanguage/agreement.txt");
	print AGREE $FORM{'agreement'};
	fclose(AGREE);
	$yySetLocation = qq~$adminurl~;
	&redirectexit;
}

# Gets our current absolute path. Needed for error messages.
sub GetDirPath {
	eval 'use Cwd; $cwd = cwd();';
	unless ($cwd) { $cwd = `pwd`; chomp $cwd; }
	unless ($cwd) { $cwd = $0 || $ENV{'PWD'} || $ENV{'CWD'} || ($ENV{'DOCUMENT_ROOT'} . '/' . $ENV{'SCRIPT_NAME'} || $ENV{'PATH_INFO'}); }
	$cwd =~ tr~\\~/~;
	$cwd =~ s~\A(.+)/\Z~$1~;
	$cwd =~ s~\A(.+)/YaBB\.\w+\Z~$1~i;
	return $cwd;
}

sub is_exe {
	my ($cmd, $name);
	foreach $cmd (@_) {
		$name = ($cmd =~ /^(\S+)/)[0];    # remove any options
		return ($cmd) if (-x $name and !-d $name and $name =~ m:/:);    # check for absolute or relative path
		if (defined $ENV{PATH}) {
			my $dir;
			foreach $dir (split(/:/, $ENV{PATH})) {
				return "$dir/$cmd" if (-x "$dir/$name" && !-d "$dir/$name");
			}
		}
	}
	0;
}

sub GmodSettings2 {
	&is_admin;

	# modstyle is set the same as modcss as modcss is useless without it.
	$mynewsettings = $FORM{'main'} || $FORM{'advanced'} || $FORM{'news'} || $FORM{'security'}|| $FORM{'antispam'};

	my $filler  = q~                                                                               ~;
	my $setfile = << "EOF";
### Gmod Related Setttings ###

\$allow_gmod_admin = "$FORM{'allow_gmod_admin'}"; #
\$allow_gmod_profile = "$FORM{'allow_gmod_profile'}"; #
\$allow_gmod_aprofile = "$FORM{'allow_gmod_aprofile'}"; #
\$gmod_newfile = "on"; #

### Areas Gmods can Access ### 

%gmod_access = (

'newsettings;page=main',"$FORM{'main'}",
'newsettings;page=advanced', "$FORM{'advanced'}",
'editbots',"$FORM{'editbots'}",

'newsettings;page=news',"$FORM{'news'}",
'smilies',"$FORM{'smilies'}",
'setcensor',"$FORM{'setcensor'}",
'modagreement',"$FORM{'modagreement'}",

'referer_control',"$FORM{'referer_control'}",
'newsettings;page=security',"$FORM{'security'}",
'setup_guardian',"$FORM{'setup_guardian'}",
'newsettings;page=antispam',"$FORM{'antispam'}",

'managecats',"$FORM{'managecats'}",
'manageboards',"$FORM{'manageboards'}",
'helpadmin',"$FORM{'helpadmin'}",
'editemailtemplates',"$FORM{'editemailtemplates'}",

'addmember',"$FORM{'addmember'}",
'viewmembers',"$FORM{'viewmembers'}",
'modmemgr',"$FORM{'modmemgr'}",
'mailing',"$FORM{'mailing'}",
'ipban',"$FORM{'ipban'}",
'setreserve',"$FORM{'setreserve'}",

'modskin',"$FORM{'modskin'}",
'modcss',"$FORM{'modcss'}",
'modtemp',"$FORM{'modtemp'}",

'clean_log',"$FORM{'clean_log'}",
'boardrecount',"$FORM{'boardrecount'}",
'rebuildmesindex',"$FORM{'rebuildmesindex'}",
'membershiprecount',"$FORM{'membershiprecount'}",
'rebuildmemlist',"$FORM{'rebuildmemlist'}",
'rebuildmemhist',"$FORM{'rebuildmemhist'}",
'deleteoldthreads',"$FORM{'deleteoldthreads'}",
'manageattachments',"$FORM{'manageattachments'}",

'detailedversion',"$FORM{'detailedversion'}",
'stats',"$FORM{'stats'}",
'showclicks',"$FORM{'showclicks'}",
'errorlog',"$FORM{'errorlog'}",

'view_reglog',"$FORM{'view_reglog'}",

'modlist',"$FORM{'modlist'}",

);

%gmod_access2 = (
admin => "$FORM{'allow_gmod_admin'}",

newsettings => "$mynewsettings",
newsettings2 => "$mynewsettings",

deleteattachment => "$FORM{'manageattachments'}",
manageattachments2 => "$FORM{'manageattachments'}",
removeoldattachments => "$FORM{'manageattachments'}",
removebigattachments => "$FORM{'manageattachments'}",
rebuildattach => "$FORM{'manageattachments'}",
remghostattach => "$FORM{'manageattachments'}",

profile => "$FORM{'allow_gmod_profile'}",
profile2 => "$FORM{'allow_gmod_profile'}",
profileAdmin => "$FORM{'allow_gmod_aprofile'}",
profileAdmin2 => "$FORM{'allow_gmod_aprofile'}",
profileContacts => "$FORM{'allow_gmod_profile'}",
profileContacts2 => "$FORM{'allow_gmod_profile'}",
profileIM => "$FORM{'allow_gmod_profile'}",
profileIM2 => "$FORM{'allow_gmod_profile'}",
profileOptions => "$FORM{'allow_gmod_profile'}",
profileOptions2 => "$FORM{'allow_gmod_profile'}",

myprofileAdmin => "$FORM{'allow_gmod_aprofile'}",
myprofileAdmin2 => "$FORM{'allow_gmod_aprofile'}",

delgroup => "$FORM{'modmemgr'}",
editgroup => "$FORM{'modmemgr'}",
editAddGroup2 => "$FORM{'modmemgr'}",
modmemgr2 => "$FORM{'modmemgr'}",
assigned => "$FORM{'modmemgr'}",
assigned2 => "$FORM{'modmemgr'}",

reordercats => "$FORM{'managecats'}",
modifycatorder => "$FORM{'managecats'}",
modifycat => "$FORM{'managecats'}",
createcat => "$FORM{'managecats'}",
catscreen => "$FORM{'managecats'}",
reordercats2 => "$FORM{'managecats'}",
addcat => "$FORM{'managecats'}",
addcat2 => "$FORM{'managecats'}",

modtemplate2 => "$FORM{'modtemp'}",
modtemp2 => "$FORM{'modtemp'}",
modstyle => "$FORM{'modcss'}",
modstyle2 => "$FORM{'modcss'}",
modcss => "$FORM{'modcss'}",
modcss2 => "$FORM{'modcss'}",

modifyboard => "$FORM{'manageboards'}",
addboard => "$FORM{'manageboards'}",
addboard2 => "$FORM{'manageboards'}",
reorderboards2 => "$FORM{'manageboards'}",
boardscreen => "$FORM{'manageboards'}",

smilieput => "$FORM{'smilies'}",
smilieindex => "$FORM{'smilies'}",
smiliemove => "$FORM{'smilies'}",
addsmilies => "$FORM{'smilies'}",

addmember => "$FORM{'viewmembers'}",
addmember2 => "$FORM{'viewmembers'}",
deletemultimembers => "$FORM{'viewmembers'}",
ml => "$FORM{'viewmembers'}",

mailmultimembers => "$FORM{'mailing'}",
mailing2 => "$FORM{'mailing'}",

activate => "$FORM{'view_reglog'}",
admin_descision => "$FORM{'view_reglog'}",
apr_regentry => "$FORM{'view_reglog'}",
del_regentry => "$FORM{'view_reglog'}",
rej_regentry => "$FORM{'view_reglog'}",
view_regentry => "$FORM{'view_reglog'}",
clean_reglog => "$FORM{'view_reglog'}",

cleanerrorlog => "$FORM{'errorlog'}",
deleteerror => "$FORM{'errorlog'}",

do_clean_log => "$FORM{'clean_log'}",
modagreement2 => "$FORM{'modagreement'}",
advsettings2 => "$FORM{'advsettings'}",
referer_control2 => "$FORM{'referer_control'}",
removeoldthreads => "$FORM{'deleteoldthreads'}",
ipban2 => "$FORM{'ipban'}",
ipban3 => "$FORM{'ipban'}",
setcensor2 => "$FORM{'setcensor'}",
setreserve2 => "$FORM{'setreserve'}",

editbots2 => "$FORM{'editbots'}",

);

1;
EOF

	$setfile =~ s~(.+\;)\s+(\#.+$)~$1 . substr( $filler, 0, (70-(length $1)) ) . $2 ~gem;
	$setfile =~ s~(.{64,}\;)\s+(\#.+$)~$1 . "\n   " . $2~gem;
	$setfile =~ s~^\s\s\s+(\#.+$)~substr( $filler, 0, 70 ) . $1~gem;

	fopen(MODACCESS, ">$vardir/gmodsettings.txt");
	print MODACCESS $setfile;
	fclose(MODACCESS);

	$yySetLocation = qq~$adminurl~;
	&redirectexit;
}

sub EditPaths {

	# Simple output of env variables, for troubleshooting
	if ($ENV{'SCRIPT_FILENAME'} ne "") {
		$support_env_path = $ENV{'SCRIPT_FILENAME'};

		# replace \'s with /'s for Windows Servers
		$support_env_path =~ s~\\~/~g;

		# Remove Setupl.pl and cgi - and also nph- for buggy IIS.
		$support_env_path =~ s~(nph-)?AdminIndex.(pl|cgi)~~ig;
	} elsif ($ENV{'PATH_TRANSLATED'} ne "") {
		$support_env_path = $ENV{'PATH_TRANSLATED'};

		# replace \'s with /'s for Windows Servers
		$support_env_path =~ s~\\~/~g;

		# Remove Setupl.pl and cgi - and also nph- for buggy IIS.
		$support_env_path =~ s~(nph-)?AdminIndex.(pl|cgi)~~ig;
	}

	$yymain .= qq~
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
		<b>$edit_paths_txt{'33'}</b>
	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$edit_paths_txt{'34'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2">
			<br />
		  $support_env_path
			<br />
			<br />
	   </td>
     </tr>
	</table>
  </div>

<br />
<br />

<form action="$adminurl?action=editpaths2" method="post" enctype="application/x-www-form-urlencoded">
 <div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
   <table width="100%" cellspacing="1" cellpadding="4">
     <tr valign="middle">
       <td align="left" class="titlebg">
		<img src="$imagesdir/preferences.gif" alt="" border="0" />
&nbsp;<b>$edit_paths_txt{'1'}</b>
	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$edit_paths_txt{'2'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />
		<div class="setting_cell">
			$edit_paths_txt{'3'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="boardurl" size="40" value="$boardurl" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'4'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="boarddir" size="40" value="$boarddir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'5'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="boardsdir" size="40" value="$boardsdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'6'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="datadir" size="40" value="$datadir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'7'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="memberdir" size="40" value="$memberdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'8'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="sourcedir" size="40" value="$sourcedir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'9'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="admindir" size="40" value="$admindir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'10'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="vardir" size="40" value="$vardir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'11'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="langdir" size="40" value="$langdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'12'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="helpfile" size="40" value="$helpfile" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'13'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="templatesdir" size="40" value="$templatesdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'14'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="forumstylesdir" size="40" value="$forumstylesdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'15'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="adminstylesdir" size="40" value="$adminstylesdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'16'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="htmldir" size="40" value="$htmldir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'17'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="facesdir" size="40" value="$facesdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'18'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="smiliesdir" size="40" value="$smiliesdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'19'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="modimgdir" size="40" value="$modimgdir" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'20'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="uploaddir" size="40" value="$uploaddir" />
		</div>
		<br />

	   </td>
     </tr>
     <tr align="center" valign="middle">
       <td align="left" class="catbg"><span class="small">$edit_paths_txt{'21'}</span>
	   </td>
     </tr>
     <tr valign="middle">
       <td align="left" class="windowbg2"><br />

		<div class="setting_cell">
			$edit_paths_txt{'22'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="forumstylesurl" size="40" value="$forumstylesurl" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'23'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="adminstylesurl" size="40" value="$adminstylesurl" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'24'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="ubbcjspath" size="40" value="$ubbcjspath" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'25'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="faderpath" size="40" value="$faderpath" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'26'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="yabbcjspath" size="40" value="$yabbcjspath" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'27'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="postjspath" size="40" value="$postjspath" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'28'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="html_root" size="40" value="$html_root" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'29'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="facesurl" size="40" value="$facesurl" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'30'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="smiliesurl" size="40" value="$smiliesurl" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'31'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="modimgurl" size="40" value="$modimgurl" />
		</div>
		<br />
		<div class="setting_cell">
			$edit_paths_txt{'32'}
		</div>
		<div class="setting_cell2">
			<input type="text" name="uploadurl" size="40" value="$uploadurl" />
		</div>
		<br />
	   </td>
     </tr>
     <tr valign="middle">
       <td align="center" class="catbg">
		 <input type="hidden" name="lastsaved" value="$realname" />
		 <input type="hidden" name="lastdate" value="$date" />
		 <input type="submit" value="$admin_txt{'10'}" class="button" />
	   </td>
     </tr>
   </table>
 </div>
</form>
~;

	$action_area = "editpaths";
	&AdminTemplate;

}

sub EditPaths2 {

	&LoadCookie;          # Load the user's cookie (or set to guest)
	&LoadUserSettings;
	if (!$iamadmin) { &admin_fatal_error("no_access"); }

	$lastsaved      = $FORM{'lastsaved'};
	$lastdate       = $FORM{'lastdate'};
	$boardurl       = $FORM{'boardurl'};
	$boarddir       = $FORM{'boarddir'};
	$htmldir        = $FORM{'htmldir'};
	$uploaddir      = $FORM{'uploaddir'};
	$uploadurl      = $FORM{'uploadurl'};
	$html_root      = $FORM{'html_root'};
	$datadir        = $FORM{'datadir'};
	$boardsdir      = $FORM{'boardsdir'};
	$memberdir      = $FORM{'memberdir'};
	$sourcedir      = $FORM{'sourcedir'};
	$admindir       = $FORM{'admindir'};
	$vardir         = $FORM{'vardir'};
	$langdir        = $FORM{'langdir'};
	$helpfile       = $FORM{'helpfile'};
	$templatesdir   = $FORM{'templatesdir'};
	$forumstylesdir = $FORM{'forumstylesdir'};
	$forumstylesurl = $FORM{'forumstylesurl'};
	$adminstylesdir = $FORM{'adminstylesdir'};
	$adminstylesurl = $FORM{'adminstylesurl'};
	$facesdir       = $FORM{'facesdir'};
	$facesurl       = $FORM{'facesurl'};
	$smiliesdir     = $FORM{'smiliesdir'};
	$smiliesurl     = $FORM{'smiliesurl'};
	$modimgdir      = $FORM{'modimgdir'};
	$modimgurl      = $FORM{'modimgurl'};
	$ubbcjspath     = $FORM{'ubbcjspath'};
	$faderpath      = $FORM{'faderpath'};
	$yabbcjspath    = $FORM{'yabbcjspath'};
	$postjspath     = $FORM{'postjspath'};

	my $filler  = q~                                                                               ~;
	my $setfile = << "EOF";
###############################################################################
# Paths.pl                                                                    #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Community Software for Webmasters                               #
# Version:        YaBB 2.2 Release                                            #
# Packaged:       June 28, 2007                                               #
# Distributed by: http://www.yabbforum.com                                    #
# =========================================================================== #
# Copyright (c) 2000-2007 YaBB (www.yabbforum.com) - All Rights Reserved.     #
# Software by:  The YaBB Development Team                                     #
#               with assistance from the YaBB community.                      #
# Sponsored by: Xnull Internet Media, Inc. - http://www.ximinc.com            #
#               Your source for web hosting, web design, and domains.         #
###############################################################################

\$lastsaved = "$lastsaved";
\$lastdate = "$lastdate";

########## Directories ##########

\$boardurl = "$boardurl";                              		# URL of your board's folder (without trailing '/')
\$boarddir = "$boarddir";                                       # The server path to the board's folder (usually can be left as '.')
\$boardsdir = "$boardsdir";                                     # Directory with board data files
\$datadir = "$datadir";                                         # Directory with messages
\$memberdir = "$memberdir";                                     # Directory with member files
\$sourcedir = "$sourcedir";                                     # Directory with YaBB source files
\$admindir = "$admindir";                                       # Directory with YaBB admin source files
\$vardir = "$vardir";                                           # Directory with variable files
\$langdir = "$langdir";                                         # Directory with Language files and folders
\$helpfile = "$helpfile";									# Directory with Help files and folders
\$templatesdir = "$templatesdir";                               # Directory with template files and folders
\$forumstylesdir = "$forumstylesdir";                               # Directory with forum style files and folders
\$adminstylesdir = "$adminstylesdir";                               # Directory with admin style files and folders
\$htmldir = "$htmldir";                              		# Base Path for all html/css files and folders
\$facesdir = "$facesdir";                              		# Base Path for all avatar files
\$smiliesdir = "$smiliesdir";                              	# Base Path for all smilie files
\$modimgdir = "$modimgdir";                              	# Base Path for all mod images
\$uploaddir = "$uploaddir";                              	# Base Path for all attachment files

########## URL's ##########

\$forumstylesurl = "$forumstylesurl";			  	# Default Forum Style Directory
\$adminstylesurl = "$adminstylesurl";			  	# Default Admin Style Directory
\$ubbcjspath = "$ubbcjspath";			  		# Default Location for the ubbc.js file
\$faderpath = "$faderpath";			  		# Default Location for the fader.js file
\$yabbcjspath = "$yabbcjspath";			 	# Default Location for the yabbc.js file
\$postjspath = "$postjspath";			  		# Default Location for the post.js file
\$html_root = "$html_root";                            		# Base URL for all html/css files and folders
\$facesurl = "$facesurl";                              		# Base URL for all avatar files
\$smiliesurl = "$smiliesurl";                            	# Base URL for all smilie files
\$modimgurl = "$modimgurl";                            	# Base URL for all mod images
\$uploadurl = "$uploadurl";        	                    	# Base URL for all attachment files

1;
EOF

	$setfile =~ s~(.+\;)\s+(\#.+$)~$1 . substr( $filler, 0, (70-(length $1)) ) . $2 ~gem;
	$setfile =~ s~(.{64,}\;)\s+(\#.+$)~$1 . "\n   " . $2~gem;
	$setfile =~ s~^\s\s\s+(\#.+$)~substr( $filler, 0, 70 ) . $1~gem;

	fopen(FILE, ">Paths.pl");
	print FILE $setfile;
	fclose(FILE);

	$yySetLocation = qq~$adminurl~;
	&redirectexit;
}

1;
